/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.views.coverage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.ui.StandardModelElementContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.core.PHPToolkitUtil;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;
import org.eclipse.php.internal.debug.core.zend.debugger.CodeCoverageData;
import org.eclipse.php.internal.debug.ui.views.coverage.CodeCoverageResult;
import org.eclipse.php.internal.debug.ui.views.coverage.ICodeCoverageFilter;

public class CodeCoverageContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY = new Object[0];
    private static ICodeCoverageFilter[] filters;
    private Map<Object, Object[]> cachedChildren;
    private Map<Object, CodeCoverageResult> cachedCoverage;
    private Map<VirtualPath, CodeCoverageData> coveredFilesMap;
    private Map<VirtualPath, Object> fileDataMap;
    private Set<VirtualPath> remoteFiles;
    private StandardModelElementContentProvider provider = new StandardModelElementContentProvider(true);
    private IProject project;

    public CodeCoverageContentProvider() {
        CodeCoverageContentProvider.initializeFilters();
    }

    private static void initializeFilters() {
        if (filters == null) {
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.php.debug.ui.phpCodeCoverageFilter");
            LinkedList<ICodeCoverageFilter> filtersList = new LinkedList<ICodeCoverageFilter>();
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (element.getName().equals("filter")) {
                    try {
                        filtersList.add((ICodeCoverageFilter)element.createExecutableExtension("class"));
                    }
                    catch (CoreException e) {
                        PHPCorePlugin.log((Throwable)e);
                    }
                }
                ++n2;
            }
            filters = filtersList.toArray(new ICodeCoverageFilter[filtersList.size()]);
        }
    }

    public Object[] getChildren(Object element) {
        if (this.cachedChildren.containsKey(element)) {
            return this.cachedChildren.get(element);
        }
        if (element instanceof IFile || element instanceof ISourceModule) {
            return EMPTY;
        }
        if (element instanceof IProject && this.project != null && element != this.project) {
            return EMPTY;
        }
        Object[] children = this.provider.getChildren(element);
        ArrayList<Object> filteredChildrenList = new ArrayList<Object>(children.length);
        int i = 0;
        while (i < children.length) {
            Object child = children[i];
            if (child instanceof IFile || child instanceof ISourceModule) {
                if (!this.isFiltered(child)) {
                    filteredChildrenList.add(child);
                }
            } else if (this.hasChildren(child)) {
                filteredChildrenList.add(child);
            }
            ++i;
        }
        Object[] result = filteredChildrenList.toArray();
        this.cachedChildren.put(element, result);
        return result;
    }

    public Object[] getElements(Object inputElement) {
        if (this.coveredFilesMap.isEmpty()) {
            return new Object[0];
        }
        this.cachedChildren = new HashMap<Object, Object[]>(0);
        this.cachedCoverage = new HashMap<Object, CodeCoverageResult>(0);
        this.remoteFiles = new HashSet<VirtualPath>();
        HashMap<VirtualPath, Object> filteredDataMap = new HashMap<VirtualPath, Object>();
        for (VirtualPath path : this.fileDataMap.keySet()) {
            boolean isFiltered = false;
            ICodeCoverageFilter[] iCodeCoverageFilterArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                ICodeCoverageFilter filter = iCodeCoverageFilterArray[n2];
                if (filter.isFiltered(path)) {
                    isFiltered = true;
                    break;
                }
                ++n2;
            }
            if (isFiltered) continue;
            filteredDataMap.put(path, this.fileDataMap.get(path));
        }
        this.remoteFiles.addAll(filteredDataMap.keySet());
        Object[] elements = this.getChildren(inputElement);
        Object[] newElements = new Object[elements.length + this.remoteFiles.size()];
        System.arraycopy(elements, 0, newElements, 0, elements.length);
        int c = elements.length;
        for (VirtualPath key : this.remoteFiles) {
            newElements[c++] = filteredDataMap.get(key);
        }
        return newElements;
    }

    public Object getParent(Object element) {
        return this.provider.getParent(element);
    }

    public boolean hasChildren(Object element) {
        boolean hasChildren = this.provider.hasChildren(element);
        if (!hasChildren) {
            return false;
        }
        if (element instanceof IFile || element instanceof ISourceModule) {
            return false;
        }
        if (element instanceof IProject && this.project != null && element != this.project) {
            return false;
        }
        hasChildren = false;
        Object[] children = this.getChildren(element);
        int i = 0;
        while (i < children.length) {
            hasChildren |= this.hasChildren(children[i]) | !this.isFiltered(children[i]);
            ++i;
        }
        return hasChildren;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.provider.inputChanged(viewer, oldInput, newInput);
    }

    public void dispose() {
        this.provider.dispose();
    }

    public CodeCoverageResult getCodeCoverageResult(Object element) {
        CodeCoverageResult coverageResult;
        if (this.cachedCoverage.containsKey(element)) {
            return this.cachedCoverage.get(element);
        }
        CodeCoverageData coverageData = null;
        if (element instanceof IModelElement) {
            ISourceModule sourceModule = PHPToolkitUtil.getSourceModule((IModelElement)((IModelElement)element));
            if (sourceModule != null) {
                coverageData = this.coveredFilesMap.get(new VirtualPath(sourceModule.getResource().getName()));
            }
        } else {
            coverageData = element instanceof IFile ? this.coveredFilesMap.get(new VirtualPath(((IFile)element).getFullPath().toString())) : this.coveredFilesMap.get(new VirtualPath(element.toString()));
        }
        if (coverageData != null) {
            int linesNum = coverageData.getLinesNum();
            int linesCovered = 0;
            int significantLines = 0;
            byte[] coverageBitmask = coverageData.getCoverageBitmask();
            int i = 1;
            while (i <= linesNum) {
                if (coverageBitmask.length > i / 8 && (coverageBitmask[i / 8] >> i % 8 & 1) == 1) {
                    ++linesCovered;
                }
                ++i;
            }
            byte[] significanceBitmask = coverageData.getSignificanceBitmask();
            if (significanceBitmask != null) {
                int i2 = 1;
                while (i2 <= linesNum) {
                    if (significanceBitmask.length > i2 / 8) {
                        if ((significanceBitmask[i2 / 8] >> i2 % 8 & 1) == 1) {
                            ++significantLines;
                        } else if ((coverageBitmask[i2 / 8] >> i2 % 8 & 1) == 1) {
                            ++significantLines;
                        }
                    }
                    ++i2;
                }
            } else {
                significantLines = -1;
            }
            coverageResult = new CodeCoverageResult(linesNum, linesCovered, significantLines, 1);
        } else if (element instanceof IModelElement) {
            coverageResult = new CodeCoverageResult(0, 0, -1, 0);
        } else {
            coverageResult = new CodeCoverageResult(0, 0, -1, 0);
            Object[] children = this.getChildren(element);
            int i = 0;
            while (i < children.length) {
                coverageResult.addCoverageResult(this.getCodeCoverageResult(children[i]));
                ++i;
            }
            this.cachedCoverage.put(element, coverageResult);
        }
        return coverageResult;
    }

    public CodeCoverageData getCoverageData(String remoteFile) {
        return this.coveredFilesMap.get(new VirtualPath(remoteFile));
    }

    public CodeCoverageData getCoverageData(ISourceModule fileData) {
        return this.coveredFilesMap.get(new VirtualPath(fileData.getPath().toString()));
    }

    public CodeCoverageData getCoverageData(IFile file) {
        return this.coveredFilesMap.get(new VirtualPath(file.getFullPath().toString()));
    }

    public void setCoveredFiles(CodeCoverageData[] coveredFiles) {
        if (coveredFiles == null) {
            this.coveredFilesMap = new HashMap<VirtualPath, CodeCoverageData>(0);
            return;
        }
        this.coveredFilesMap = new HashMap<VirtualPath, CodeCoverageData>(coveredFiles.length);
        this.fileDataMap = new HashMap<VirtualPath, Object>(coveredFiles.length);
        CodeCoverageData[] codeCoverageDataArray = coveredFiles;
        int n = coveredFiles.length;
        int n2 = 0;
        while (n2 < n) {
            CodeCoverageData element = codeCoverageDataArray[n2];
            ISourceModule fileData = (ISourceModule)element.getAdapter(ISourceModule.class);
            if (fileData != null) {
                VirtualPath key = new VirtualPath(fileData.getPath().toString());
                this.coveredFilesMap.put(key, element);
                this.fileDataMap.put(key, fileData);
            } else {
                String localPath = element.getLocalFileName();
                IFile localFile = ResourcesPlugin.getWorkspace().getRoot().getFile(Path.fromOSString((String)localPath));
                if (localFile.exists()) {
                    key = new VirtualPath(localFile.getFullPath().toString());
                    this.coveredFilesMap.put(key, element);
                    this.fileDataMap.put(key, localFile);
                } else {
                    key = new VirtualPath(localPath);
                    this.coveredFilesMap.put(key, element);
                    this.fileDataMap.put(key, localPath);
                }
            }
            ++n2;
        }
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    private boolean isFiltered(Object child) {
        IFile localFile;
        String name;
        ISourceModule fileData;
        if (child instanceof IModelElement && (fileData = PHPToolkitUtil.getSourceModule((IModelElement)((IModelElement)child))) != null && this.coveredFilesMap.containsKey(new VirtualPath(name = fileData.getResource().getName()))) {
            this.remoteFiles.remove(name);
            return false;
        }
        if (child instanceof IFile && this.coveredFilesMap.containsKey(new VirtualPath((localFile = (IFile)child).getFullPath().toString()))) {
            this.remoteFiles.remove(localFile.getFullPath().toString());
            return false;
        }
        return true;
    }
}

