/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.php.internal.server.PHPServerUIMessages;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.server.ui.ServersPluginImages;
import org.eclipse.php.internal.ui.wizards.CompositeFragment;
import org.eclipse.php.internal.ui.wizards.IControlHandler;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ServerCompositeFragment
extends CompositeFragment {
    protected Text name;
    protected Text url;
    protected Combo combo;
    private Text webroot;

    public ServerCompositeFragment(Composite parent, IControlHandler handler, boolean isForEditing) {
        super(parent, handler, isForEditing);
        this.createDescription();
    }

    protected void createDescription() {
        this.setDisplayName(PHPServerUIMessages.getString("ServerCompositeFragment.server"));
        this.setDescription(PHPServerUIMessages.getString("ServerCompositeFragment.specifyInformation"));
        this.controlHandler.setDescription(this.getDescription());
        this.setImageDescriptor(ServersPluginImages.DESC_WIZ_SERVER);
        this.controlHandler.setImageDescriptor(this.getImageDescriptor());
        switch (this.controlHandler.getKind()) {
            case WIZARD: {
                this.setTitle(PHPServerUIMessages.getString("ServerCompositeFragment.newPhpServer"));
                break;
            }
            case EDITOR: {
                this.setTitle(PHPServerUIMessages.getString("ServerCompositeFragment.phpServer"));
                break;
            }
        }
        this.controlHandler.setTitle(this.getTitle());
    }

    public void setData(Object server) throws IllegalArgumentException {
        if (server != null && !(server instanceof Server)) {
            throw new IllegalArgumentException("The given object is not a Server");
        }
        super.setData(server);
        this.init();
        this.validate();
    }

    public Server getServer() {
        return (Server)this.getData();
    }

    protected void createContents(Composite parent) {
        Composite nameGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout = new GridLayout();
        layout.numColumns = 2;
        nameGroup.setLayout((Layout)layout);
        nameGroup.setLayoutData((Object)new GridData(768));
        Label label = new Label(nameGroup, 0);
        label.setText(PHPServerUIMessages.getString("ServerCompositeFragment.nameLabel"));
        GridData data = new GridData();
        label.setLayoutData((Object)data);
        this.name = new Text(nameGroup, 2048);
        data = new GridData(768);
        this.name.setLayoutData((Object)data);
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServerCompositeFragment.this.getServer().setName(ServerCompositeFragment.this.name.getText());
                ServerCompositeFragment.this.validate();
            }
        });
        this.createURLGroup(parent);
        this.init();
        this.validate();
        Dialog.applyDialogFont((Control)parent);
        this.name.forceFocus();
    }

    protected void init() {
        Object baseURL;
        Server server = this.getServer();
        if (this.name == null || server == null) {
            return;
        }
        if (this.getServer().getName() != null) {
            boolean nameSet = false;
            Object serverName = this.getServer().getName();
            String orgName = serverName;
            if (!this.isForEditing()) {
                int i = 0;
                while (i < 10) {
                    boolean ok = this.checkServerName((String)serverName);
                    if (ok) {
                        this.name.setText((String)serverName);
                        this.getServer().setName((String)serverName);
                        nameSet = true;
                        break;
                    }
                    serverName = orgName + " (" + Integer.toString(i + 2) + ")";
                    ++i;
                }
                if (!nameSet) {
                    this.name.setText("");
                    this.getServer().setName("");
                }
            } else {
                this.name.setText((String)serverName);
            }
        } else {
            this.name.setText("");
        }
        if (this.getServer().getDocumentRoot() != null) {
            this.webroot.setText(this.getServer().getDocumentRoot());
        }
        if (!((String)(baseURL = this.getServer().getBaseURL())).equals("")) {
            this.url.setText((String)baseURL);
            try {
                URL originalURL = new URL((String)baseURL);
                int port = originalURL.getPort();
                this.getServer().setPort(String.valueOf(port));
            }
            catch (Exception e) {
                this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.enterValidURL"), 3);
            }
        } else {
            baseURL = "http://" + server.getHost();
            this.url.setText((String)baseURL);
            try {
                this.getServer().setBaseURL((String)baseURL);
                URL createdURL = new URL((String)baseURL);
                int port = createdURL.getPort();
                this.getServer().setPort(String.valueOf(port));
            }
            catch (Exception e) {
                this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.enterValidURL"), 3);
            }
        }
    }

    public void validate() {
        boolean ok;
        if (this.getServer() == null) {
            this.setMessage("", 3);
            return;
        }
        this.setMessage(this.getDescription(), 0);
        String urlStr = this.url.getText();
        if (urlStr != null && !urlStr.trim().equals("") && !(ok = this.checkServerUrl(urlStr))) {
            this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.duplicateServerUrl"), 3);
        }
        if (urlStr != null) {
            try {
                URL url = new URL(urlStr);
                if (url.getPath() != null && url.getPath().length() != 0) {
                    urlStr = null;
                }
            }
            catch (MalformedURLException e1) {
                urlStr = null;
            }
        }
        if (urlStr == null || urlStr.equals("")) {
            this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.enterValidURL"), 3);
            return;
        }
        try {
            URL baseURL = new URL(urlStr);
            String host = baseURL.getHost();
            if (host.trim().length() == 0) {
                this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.serverURLEmpty"), 3);
            }
            int port = baseURL.getPort();
            this.getServer().setHost(host);
            this.getServer().setPort(String.valueOf(port));
        }
        catch (Exception e) {
            this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.enterValidURL"), 3);
            return;
        }
        String serverName = this.getServer().getName();
        if (serverName == null || serverName.trim().equals("")) {
            this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.missingServerName"), 3);
        } else {
            boolean ok2 = this.checkServerName(serverName);
            if (!ok2) {
                this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.duplicateServerName"), 3);
            }
        }
        String webrootStr = this.webroot.getText().trim();
        if (webrootStr.length() != 0 && !new Path(webrootStr).toFile().exists()) {
            this.setMessage(PHPServerUIMessages.getString("ServerCompositeFragment.webrootNotExists"), 3);
        }
        this.controlHandler.update();
    }

    protected void createURLGroup(Composite parent) {
        Composite urlGroupComposite = new Composite(parent, 0);
        GridLayout sLayout = new GridLayout();
        urlGroupComposite.setLayout((Layout)sLayout);
        GridData sGridData = new GridData(4, 4, true, true);
        urlGroupComposite.setLayoutData((Object)sGridData);
        Group group = new Group(urlGroupComposite, 0);
        group.setFont(urlGroupComposite.getFont());
        GridLayout layout = new GridLayout(3, false);
        group.setLayout((Layout)layout);
        GridData data = new GridData(768);
        group.setLayoutData((Object)data);
        group.setText(PHPServerUIMessages.getString("ServerCompositeFragment.serverProperties"));
        Label urlLabel = new Label((Composite)group, 0);
        urlLabel.setText(PHPServerUIMessages.getString("ServerCompositeFragment.baseURL"));
        this.url = new Text((Composite)group, 2048);
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.url.setLayoutData((Object)layoutData);
        this.url.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ServerCompositeFragment.this.getServer() != null) {
                    String urlStr = ServerCompositeFragment.this.url.getText();
                    try {
                        ServerCompositeFragment.this.getServer().setBaseURL(urlStr);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                ServerCompositeFragment.this.validate();
            }
        });
        Label labelRoot = new Label((Composite)group, 0);
        labelRoot.setText(PHPServerUIMessages.getString("ServerCompositeFragment.localWebRoot"));
        labelRoot.setLayoutData((Object)new GridData());
        this.webroot = new Text((Composite)group, 2048);
        this.webroot.setLayoutData((Object)new GridData(768));
        this.webroot.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ServerCompositeFragment.this.getServer() != null) {
                    String webrootStr = ServerCompositeFragment.this.webroot.getText();
                    ServerCompositeFragment.this.getServer().setDocumentRoot(webrootStr);
                }
                ServerCompositeFragment.this.validate();
            }
        });
        Button browseButton = new Button((Composite)group, 8);
        browseButton.setText(PHPServerUIMessages.getString("ServerCompositeFragment.browse"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String result;
                DirectoryDialog dialog = new DirectoryDialog(ServerCompositeFragment.this.getShell());
                if (!"".equals(ServerCompositeFragment.this.webroot.getText())) {
                    String initialDir = ServerCompositeFragment.this.webroot.getText();
                    dialog.setFilterPath(initialDir);
                }
                if ((result = dialog.open()) != null) {
                    ServerCompositeFragment.this.webroot.setText(result.toString());
                }
            }
        });
    }

    private boolean checkServerName(String name) {
        name = name.trim();
        Server[] allServers = ServersManager.getServers();
        if (allServers != null) {
            int size = allServers.length;
            int i = 0;
            while (i < size) {
                Server server = allServers[i];
                if (name.equals(server.getName()) && !this.getServer().getUniqueId().equals(server.getUniqueId())) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private boolean checkServerUrl(String url) {
        url = url.trim();
        Server[] allServers = ServersManager.getServers();
        if (allServers != null) {
            int size = allServers.length;
            int i = 0;
            while (i < size) {
                Server server = allServers[i];
                if (url.equals(server.getBaseURL()) && !this.getServer().getUniqueId().equals(server.getUniqueId())) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean performOk() {
        return true;
    }
}

