/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.format;

import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.commands.ExpressionContext;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.VersionedEdits;
import org.eclipse.lsp4e.operations.format.LSPFormatter;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class LSPFormatFilesHandler
extends AbstractHandler {
    private static final int SINGLE_FILE_TIMEOUT_MS = 5000;
    protected final LSPFormatter formatter = new LSPFormatter();

    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        Object object = event.getApplicationContext();
        if (object instanceof ExpressionContext) {
            ExpressionContext ctx = (ExpressionContext)object;
            Job job = Job.create((String)Messages.LSPFormatFilesHandler_FormattingSelectedFiles, monitor -> {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                Set<IFile> selectedFiles = this.getSelectedFiles(ctx);
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)selectedFiles.size());
                for (IFile file : selectedFiles) {
                    if (subMonitor.isCanceled()) {
                        return;
                    }
                    this.formatFile(file, monitor);
                    subMonitor.worked(1);
                }
                subMonitor.done();
            });
            job.setPriority(40);
            job.schedule();
        }
        return null;
    }

    protected void formatFile(IFile file, IProgressMonitor monitor) {
        if (!file.exists() || !LanguageServersRegistry.getInstance().canUseLanguageServer(file)) {
            return;
        }
        IDocumentProvider docProvider = this.getDocumentProvider(file);
        try {
            docProvider.connect((Object)file);
            IDocument doc = docProvider.getDocument((Object)file);
            if (doc == null) {
                return;
            }
            try {
                monitor.setTaskName(NLS.bind((String)Messages.LSPFormatFilesHandler_FormattingFile, (Object)file.getFullPath()));
                Optional<VersionedEdits> formatting = this.formatter.requestFormatting(doc, (ITextSelection)new TextSelection(0, 0)).get(5000L, TimeUnit.MILLISECONDS);
                formatting.ifPresent(edits -> {
                    docProvider.aboutToChange((Object)doc);
                    UI.getDisplay().syncExec(() -> {
                        try {
                            edits.apply();
                        }
                        catch (ConcurrentModificationException | BadLocationException e) {
                            LanguageServerPlugin.logError(e);
                        }
                    });
                    docProvider.changed((Object)doc);
                    this.saveDocument(docProvider, file, monitor);
                });
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                LanguageServerPlugin.logError(ex);
            }
            catch (Exception ex) {
                LanguageServerPlugin.logError(ex);
            }
        }
        finally {
            docProvider.disconnect((Object)file);
        }
    }

    protected IDocumentProvider getDocumentProvider(IFile file) {
        return DocumentProviderRegistry.getDefault().getDocumentProvider((IEditorInput)new FileEditorInput(file));
    }

    protected void saveDocument(IDocumentProvider docProvider, IFile file, IProgressMonitor monitor) {
        try {
            docProvider.saveDocument(monitor, (Object)file, docProvider.getDocument((Object)file), true);
        }
        catch (CoreException e) {
            LanguageServerPlugin.logError(e);
        }
    }

    protected Set<IFile> getSelectedFiles(ExpressionContext ctx) {
        Collection<?> selection = this.getSelection(ctx);
        if (selection.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<IFile> files = new HashSet<IFile>();
        for (Object item : selection) {
            try {
                if (!(item instanceof IResource)) continue;
                IResource resource = (IResource)item;
                if (resource instanceof IFile) {
                    IFile file = (IFile)resource;
                    files.add(file);
                    continue;
                }
                if (!(resource instanceof IProject) && !(resource instanceof IFolder)) continue;
                resource.accept(childResource -> {
                    if (childResource.isLinked() || childResource.isVirtual()) {
                        return false;
                    }
                    if (childResource instanceof IFile) {
                        IFile file = (IFile)childResource;
                        files.add(file);
                        return false;
                    }
                    return true;
                });
            }
            catch (CoreException ex) {
                LanguageServerPlugin.logError(ex);
            }
        }
        return files;
    }

    protected Collection<?> getSelection(ExpressionContext ctx) {
        Object defVariable = ctx.getDefaultVariable();
        if (defVariable instanceof Collection) {
            Collection defVariableAsCollection = (Collection)defVariable;
            return defVariableAsCollection;
        }
        return List.of(defVariable);
    }

    public void setEnabled(@Nullable Object evaluationContext) {
        block5: {
            Collection<?> selection;
            block7: {
                block6: {
                    if (!(evaluationContext instanceof ExpressionContext)) break block5;
                    ExpressionContext ctx = (ExpressionContext)evaluationContext;
                    selection = this.getSelection(ctx);
                    if (selection.isEmpty()) {
                        this.setBaseEnabled(false);
                        return;
                    }
                    if (selection.size() > 1) break block6;
                    if (!selection.stream().anyMatch(IContainer.class::isInstance)) break block7;
                }
                this.setBaseEnabled(true);
                return;
            }
            Object obj = selection.iterator().next();
            if (obj instanceof IFile) {
                IFile file = (IFile)obj;
                this.setBaseEnabled(LanguageServersRegistry.getInstance().canUseLanguageServer(file));
                return;
            }
        }
        this.setBaseEnabled(false);
    }
}

