/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.ui.StandardModelElementContentProvider;
import org.eclipse.dltk.internal.ui.navigator.ProjectFragmentContainer;
import org.eclipse.dltk.internal.ui.scriptview.BuildPathContainer;
import org.eclipse.dltk.internal.ui.scriptview.LibraryContainer;
import org.eclipse.dltk.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.progress.UIJob;

public class ScriptExplorerContentProvider
extends StandardModelElementContentProvider
implements ITreeContentProvider,
IElementChangedListener,
IPropertyChangeListener {
    protected static final int ORIGINAL = 0;
    protected static final int PARENT = 1;
    protected static final int GRANT_PARENT = 2;
    protected static final int PROJECT = 4;
    private TreeViewer fViewer;
    private Object fInput;
    private boolean fIsFlatLayout = false;
    private boolean fShowLibrariesNode = false;
    private boolean fFoldPackages = this.arePackagesFoldedInHierarchicalLayout();
    private Collection<Runnable> fPendingUpdates = null;
    private UIJob fUpdateJob;

    public ScriptExplorerContentProvider(boolean provideMembers) {
        super(provideMembers);
        DLTKUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private boolean arePackagesFoldedInHierarchicalLayout() {
        return this.getPreferenceStore().getBoolean("org.eclipse.dltk.ui.flatPackagesInPackageExplorer");
    }

    protected IPreferenceStore getPreferenceStore() {
        return DLTKUIPlugin.getDefault().getPreferenceStore();
    }

    protected Object getViewerInput() {
        return this.fInput;
    }

    protected static IModelElement convert(IResource resource) {
        IScriptProject project = DLTKCore.create((IProject)resource.getProject());
        if (project == null) {
            return null;
        }
        IModelElement scriptElement = ModelManager.create((IResource)resource, (IScriptProject)project);
        if (scriptElement == null || !scriptElement.exists()) {
            return null;
        }
        return scriptElement;
    }

    public void elementChanged(ElementChangedEvent event) {
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        try {
            if (this.inputDeleted(runnables)) {
                return;
            }
            try {
                this.processDelta(event.getDelta(), runnables);
            }
            catch (ModelException e) {
                DLTKUIPlugin.log(e);
            }
        }
        finally {
            this.executeRunnables(runnables);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void executeRunnables(Collection<Runnable> runnables) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            boolean hasPendingUpdates;
            ScriptExplorerContentProvider scriptExplorerContentProvider = this;
            synchronized (scriptExplorerContentProvider) {
                hasPendingUpdates = this.fPendingUpdates != null && !this.fPendingUpdates.isEmpty();
            }
            if (!hasPendingUpdates && ctrl.getDisplay().getThread() == Thread.currentThread() && !this.fViewer.isBusy()) {
                this.runUpdates(runnables);
            } else {
                scriptExplorerContentProvider = this;
                synchronized (scriptExplorerContentProvider) {
                    if (this.fPendingUpdates == null) {
                        this.fPendingUpdates = runnables;
                    } else {
                        this.fPendingUpdates.addAll(runnables);
                    }
                }
                this.postAsyncUpdate(ctrl.getDisplay());
            }
        }
    }

    private void postAsyncUpdate(Display display) {
        if (this.fUpdateJob == null) {
            this.fUpdateJob = new UIJob(display, "Update Script explorer"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    TreeViewer viewer = ScriptExplorerContentProvider.this.fViewer;
                    if (viewer != null && viewer.isBusy()) {
                        this.schedule(100L);
                    } else {
                        ScriptExplorerContentProvider.this.runPendingUpdates();
                    }
                    return Status.OK_STATUS;
                }
            };
            this.fUpdateJob.setSystem(true);
        }
        this.fUpdateJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runPendingUpdates() {
        Control control;
        Collection<Runnable> pendingUpdates;
        ScriptExplorerContentProvider scriptExplorerContentProvider = this;
        synchronized (scriptExplorerContentProvider) {
            pendingUpdates = this.fPendingUpdates;
            this.fPendingUpdates = null;
        }
        if (pendingUpdates != null && this.fViewer != null && (control = this.fViewer.getControl()) != null && !control.isDisposed()) {
            this.runUpdates(pendingUpdates);
        }
    }

    private void runUpdates(Collection<Runnable> runnables) {
        Iterator<Runnable> runnableIterator = runnables.iterator();
        while (runnableIterator.hasNext()) {
            runnableIterator.next().run();
        }
    }

    private boolean inputDeleted(Collection<Runnable> runnables) {
        if (this.fInput == null) {
            return false;
        }
        if (this.fInput instanceof IModelElement && ((IModelElement)this.fInput).exists()) {
            return false;
        }
        if (this.fInput instanceof IResource && ((IResource)this.fInput).exists()) {
            return false;
        }
        if (this.fInput instanceof WorkingSetModel) {
            return false;
        }
        if (this.fInput instanceof IWorkingSet) {
            return false;
        }
        this.postRefresh(this.fInput, 0, this.fInput, runnables);
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        DLTKCore.removeElementChangedListener((IElementChangedListener)this);
        DLTKUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    @Override
    protected Object[] getProjectFragmentContent(IProjectFragment root) throws ModelException {
        if (this.fIsFlatLayout) {
            return super.getProjectFragmentContent(root);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        this.getHierarchicalPackageChildren(root, null, result);
        if (!this.isProjectProjectFragment(root)) {
            Object[] nonJavaResources = root.getForeignResources();
            int i = 0;
            while (i < nonJavaResources.length) {
                result.add(nonJavaResources[i]);
                ++i;
            }
        }
        return result.toArray();
    }

    @Override
    protected Object[] getScriptFolderContent(IScriptFolder fragment) throws ModelException {
        if (this.fIsFlatLayout) {
            return super.getScriptFolderContent(fragment);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        this.getHierarchicalPackageChildren((IProjectFragment)fragment.getParent(), fragment, result);
        Object[] nonPackages = super.getScriptFolderContent(fragment);
        if (result.isEmpty()) {
            return nonPackages;
        }
        int i = 0;
        while (i < nonPackages.length) {
            result.add(nonPackages[i]);
            ++i;
        }
        return result.toArray();
    }

    @Override
    protected Object[] getFolderContent(IFolder folder) throws CoreException {
        if (this.fIsFlatLayout) {
            return super.getFolderContent(folder);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        this.getHierarchicalPackagesInFolder(folder, result);
        Object[] others = super.getFolderContent(folder);
        if (result.isEmpty()) {
            return others;
        }
        int i = 0;
        while (i < others.length) {
            result.add(others[i]);
            ++i;
        }
        return result.toArray();
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        try {
            if (parentElement instanceof IScriptModel) {
                return this.getExtendedChildren(parentElement, StandardModelElementContentProvider.concatenate(this.getScriptProjects((IScriptModel)parentElement), this.getNonJavaProjects((IScriptModel)parentElement)));
            }
            if (parentElement instanceof ProjectFragmentContainer) {
                return this.getExtendedChildren(parentElement, this.getContainerProjectFragments((ProjectFragmentContainer)parentElement));
            }
            if (parentElement instanceof IProject) {
                if (!((IProject)parentElement).isAccessible()) {
                    return StandardModelElementContentProvider.NO_CHILDREN;
                }
                return this.getExtendedChildren(parentElement, ((IProject)parentElement).members());
            }
            return super.getChildren(parentElement);
        }
        catch (CoreException e) {
            return this.getExtendedChildren(parentElement, StandardModelElementContentProvider.NO_CHILDREN);
        }
    }

    @Override
    protected Object[] getProjectFragments(IScriptProject project) throws ModelException {
        IBuildpathEntry classpathEntry;
        if (!project.getProject().isOpen()) {
            return StandardModelElementContentProvider.NO_CHILDREN;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        boolean addZIPContainer = false;
        IProjectFragment[] roots = project.getProjectFragments();
        int i = 0;
        while (i < roots.length) {
            block14: {
                int entryKind;
                IProjectFragment root = roots[i];
                try {
                    classpathEntry = root.getRawBuildpathEntry();
                }
                catch (ModelException e) {
                    break block14;
                }
                if (classpathEntry != null && (entryKind = classpathEntry.getEntryKind()) != 5) {
                    if (this.fShowLibrariesNode && entryKind == 1) {
                        addZIPContainer = true;
                    } else if (this.isProjectProjectFragment(root)) {
                        Object[] fragments = this.getProjectFragmentContent(root);
                        int j = 0;
                        while (j < fragments.length) {
                            result.add(fragments[j]);
                            ++j;
                        }
                    } else {
                        result.add(root);
                    }
                }
            }
            ++i;
        }
        if (addZIPContainer) {
            result.add(new LibraryContainer(project));
        }
        IBuildpathEntry[] rawBuidspath = project.getRawBuildpath();
        int i2 = 0;
        while (i2 < rawBuidspath.length) {
            classpathEntry = rawBuidspath[i2];
            if (classpathEntry.getEntryKind() == 5) {
                result.add(new BuildPathContainer(project, classpathEntry));
            }
            ++i2;
        }
        Object[] resources = project.getForeignResources();
        int i3 = 0;
        while (i3 < resources.length) {
            result.add(resources[i3]);
            ++i3;
        }
        return result.toArray();
    }

    private Object[] getContainerProjectFragments(ProjectFragmentContainer container) {
        return container.getChildren();
    }

    private Object[] getNonJavaProjects(IScriptModel model) throws ModelException {
        return model.getForeignResources();
    }

    @Override
    protected Object internalGetParent(Object element) {
        block8: {
            if (!this.fIsFlatLayout && element instanceof IScriptFolder) {
                return this.getHierarchicalPackageParent((IScriptFolder)element);
            }
            if (element instanceof IProjectFragment) {
                IProjectFragment root = (IProjectFragment)element;
                try {
                    IBuildpathEntry entry = root.getRawBuildpathEntry();
                    if (entry == null) break block8;
                    int entryKind = entry.getEntryKind();
                    if (entryKind == 5) {
                        return new BuildPathContainer(root.getScriptProject(), entry);
                    }
                    if (this.fShowLibrariesNode && entryKind == 1) {
                        return new LibraryContainer(root.getScriptProject());
                    }
                }
                catch (ModelException modelException) {}
            } else if (element instanceof ProjectFragmentContainer) {
                return ((ProjectFragmentContainer)element).getScriptProject();
            }
        }
        return super.internalGetParent(element);
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.fViewer = (TreeViewer)viewer;
        if (oldInput == null && newInput != null) {
            DLTKCore.addElementChangedListener((IElementChangedListener)this);
        } else if (oldInput != null && newInput == null) {
            DLTKCore.removeElementChangedListener((IElementChangedListener)this);
        }
        this.fInput = newInput;
    }

    private void getHierarchicalPackageChildren(IProjectFragment parent, IScriptFolder fragment, Collection<Object> result) throws ModelException {
        IModelElement[] children = parent.getChildren();
        if (fragment == null || fragment.isRootFolder()) {
            ArrayList<IModelElement> newElements = new ArrayList<IModelElement>();
            int i = 0;
            while (i < children.length) {
                IScriptFolder scriptFolder;
                if (children[i] instanceof IScriptFolder && (scriptFolder = (IScriptFolder)children[i]).isRootFolder()) {
                    IModelElement[] members = scriptFolder.getChildren();
                    int j = 0;
                    while (j < members.length) {
                        newElements.add(members[j]);
                        ++j;
                    }
                } else {
                    newElements.add(children[i]);
                }
                ++i;
            }
            children = newElements.toArray(new IModelElement[newElements.size()]);
        }
        String prefix = fragment != null ? fragment.getElementName() + "/" : "";
        int prefixLen = prefix.length();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof IScriptFolder) {
                IScriptFolder curr = (IScriptFolder)children[i];
                String name = curr.getElementName();
                if (name.startsWith(prefix) && name.length() > prefixLen && name.indexOf(47, prefixLen) == -1) {
                    if (this.fFoldPackages) {
                        curr = ScriptExplorerContentProvider.getFolded(children, curr);
                    }
                    result.add(curr);
                }
            } else {
                result.add(children[i]);
            }
            ++i;
        }
    }

    private void getHierarchicalPackagesInFolder(IFolder folder, Collection<Object> result) throws CoreException {
        IResource[] resources = folder.members();
        int i = 0;
        while (i < resources.length) {
            IFolder curr;
            IModelElement element;
            IResource resource = resources[i];
            if (resource instanceof IFolder && (element = ScriptExplorerContentProvider.convert((IResource)(curr = (IFolder)resource))) instanceof IScriptFolder) {
                if (this.fFoldPackages) {
                    IScriptFolder fragment = (IScriptFolder)element;
                    IProjectFragment root = (IProjectFragment)fragment.getParent();
                    element = ScriptExplorerContentProvider.getFolded(root.getChildren(), fragment);
                }
                result.add(element);
            }
            ++i;
        }
    }

    public Object getHierarchicalPackageParent(IScriptFolder child) {
        String name = child.getElementName();
        IProjectFragment parent = (IProjectFragment)child.getParent();
        int index = name.lastIndexOf(47);
        if (index != -1) {
            IResource resource;
            String realParentName = name.substring(0, index);
            IScriptFolder element = parent.getScriptFolder(realParentName);
            if (element != null && element.exists()) {
                try {
                    if (this.fFoldPackages && ScriptExplorerContentProvider.isEmpty(element) && ScriptExplorerContentProvider.findSinglePackageChild(element, parent.getChildren()) != null) {
                        return this.getHierarchicalPackageParent(element);
                    }
                }
                catch (ModelException modelException) {
                    // empty catch block
                }
                return element;
            }
            if (element != null && (resource = element.getResource()) != null) {
                return resource;
            }
        }
        if (parent.getResource() instanceof IProject) {
            return parent.getScriptProject();
        }
        return parent;
    }

    private static IScriptFolder getFolded(IModelElement[] children, IScriptFolder pack) throws ModelException {
        while (ScriptExplorerContentProvider.isEmpty(pack)) {
            IScriptFolder collapsed = ScriptExplorerContentProvider.findSinglePackageChild(pack, children);
            if (collapsed == null) {
                return pack;
            }
            pack = collapsed;
        }
        return pack;
    }

    private static boolean isEmpty(IScriptFolder fragment) throws ModelException {
        return !fragment.containsScriptResources() && fragment.getForeignResources().length == 0;
    }

    private static IScriptFolder findSinglePackageChild(IScriptFolder fragment, IModelElement[] children) {
        String prefix = fragment.getElementName() + "/";
        int prefixLen = prefix.length();
        IScriptFolder found = null;
        int i = 0;
        while (i < children.length) {
            IModelElement element = children[i];
            String name = element.getElementName();
            if (name.startsWith(prefix) && name.length() > prefixLen && name.indexOf(47, prefixLen) == -1) {
                if (found == null) {
                    found = (IScriptFolder)element;
                } else {
                    return null;
                }
            }
            ++i;
        }
        return found;
    }

    private boolean processDelta(IModelElementDelta delta, Collection<Runnable> runnables) throws ModelException {
        Object parent;
        IScriptProject proj;
        int kind = delta.getKind();
        int flags = delta.getFlags();
        IModelElement element = delta.getElement();
        int elementType = element.getElementType();
        if (!(elementType == 1 || elementType == 2 || (proj = element.getScriptProject()) != null && proj.getProject().isOpen())) {
            return false;
        }
        if (elementType == 4) {
            if ((flags & 9) == 1) {
                if (!this.fIsFlatLayout && !((parent = this.getHierarchicalPackageParent((IScriptFolder)element)) instanceof IProjectFragment)) {
                    this.postRefresh(this.internalGetParent(parent), 2, element, runnables);
                    return true;
                }
                this.postRefresh(this.internalGetParent(element), 1, element, runnables);
                return true;
            }
            if (!this.fIsFlatLayout) {
                if (kind == 2) {
                    parent = this.getHierarchicalPackageParent((IScriptFolder)element);
                    if (parent instanceof IProjectFragment) {
                        this.postRemove(element, runnables);
                        return false;
                    }
                    this.postRefresh(this.internalGetParent(parent), 2, element, runnables);
                    return true;
                }
                if (kind == 1) {
                    parent = this.getHierarchicalPackageParent((IScriptFolder)element);
                    if (parent instanceof IProjectFragment) {
                        if (this.fFoldPackages) {
                            this.postRefresh(parent, 1, element, runnables);
                            return true;
                        }
                        this.postAdd(parent, element, runnables);
                        return false;
                    }
                    this.postRefresh(this.internalGetParent(parent), 2, element, runnables);
                    return true;
                }
                this.handleAffectedChildren(delta, element, runnables);
                return false;
            }
        }
        if (elementType == 5) {
            ISourceModule cu = (ISourceModule)element;
            if (!ScriptModelUtil.isPrimary((ISourceModule)cu)) {
                return false;
            }
            if (!this.getProvideMembers() && cu.isWorkingCopy() && kind == 4) {
                return false;
            }
            if (kind == 4 && !ScriptExplorerContentProvider.isStructuralCUChange(flags)) {
                return false;
            }
            if (!this.isOnClassPath(cu)) {
                return false;
            }
        }
        if (elementType == 2) {
            if ((flags & 0x600) != 0) {
                this.postRefresh(element, 0, element, runnables);
                return false;
            }
            if ((flags & 0x20000) != 0) {
                this.postRefresh(element, 0, element, runnables);
                return false;
            }
            if (kind == 1) {
                this.postRemove(element.getResource(), runnables);
                this.postAdd(element.getParent(), element, runnables);
                return false;
            }
        }
        if (kind == 2) {
            IResource resource;
            parent = this.internalGetParent(element);
            if (element instanceof IScriptFolder) {
                if (this.fViewer.testFindItem(parent) != null) {
                    this.postRefresh(parent, 1, element, runnables);
                }
                return true;
            }
            if (element instanceof IProjectFragment && ((IProjectFragment)element).getKind() != 1 && (resource = element.getResource()) != null) {
                this.postRemove(resource, runnables);
            }
            this.postRemove(element, runnables);
            if (parent instanceof IScriptFolder) {
                this.postUpdateIcon((IModelElement)((IScriptFolder)parent), runnables);
            }
            if (this.isScriptFolderEmpty(element.getParent())) {
                if (this.fViewer.testFindItem(parent) != null) {
                    this.postRefresh(this.internalGetParent(parent), 2, element, runnables);
                }
                return true;
            }
            return false;
        }
        if (kind == 1) {
            parent = this.internalGetParent(element);
            if (parent instanceof IScriptFolder) {
                Object grandparent = this.internalGetParent(parent);
                if (parent.equals(this.fInput)) {
                    this.postRefresh(parent, 1, element, runnables);
                } else if (this.fViewer.testFindItem(parent) == null) {
                    this.postRefresh(grandparent, 2, element, runnables);
                } else {
                    this.postRefresh(parent, 1, element, runnables);
                }
                return true;
            }
            this.postAdd(parent, element, runnables);
        }
        if (elementType == 5 || elementType == 6) {
            if (kind == 4) {
                this.postRefresh(element, 0, element, runnables);
            }
            return false;
        }
        if (elementType == 3) {
            if ((flags & 0x8000) != 0) {
                this.postRefresh(element, 0, element, runnables);
                return false;
            }
            if ((flags & 9) == 1) {
                this.postRefresh(this.internalGetParent(element), 1, element, runnables);
                return true;
            }
            if (this.isBuildPathChange(delta)) {
                this.postRefresh(element.getScriptProject(), 4, element, runnables);
                return true;
            }
        }
        this.handleAffectedChildren(delta, element, runnables);
        return false;
    }

    private static boolean isStructuralCUChange(int flags) {
        return (flags & 8) != 0 || (flags & 0x4001) == 1;
    }

    void handleAffectedChildren(IModelElementDelta delta, IModelElement element, Collection<Runnable> runnables) throws ModelException {
        int count = 0;
        IResourceDelta[] resourceDeltas = delta.getResourceDeltas();
        if (resourceDeltas != null) {
            int i = 0;
            while (i < resourceDeltas.length) {
                int kind = resourceDeltas[i].getKind();
                if (kind == 1 || kind == 2) {
                    ++count;
                }
                ++i;
            }
        }
        IModelElementDelta[] affectedChildren = delta.getAffectedChildren();
        int i = 0;
        while (i < affectedChildren.length) {
            int kind = affectedChildren[i].getKind();
            if (kind == 1 || kind == 2) {
                ++count;
            }
            ++i;
        }
        if (count > 1) {
            if (element instanceof IScriptFolder) {
                IModelElement parent = (IModelElement)this.internalGetParent(element);
                if (element.equals(this.fInput)) {
                    this.postRefresh(element, 0, element, runnables);
                } else {
                    this.postRefresh(parent, 1, element, runnables);
                }
            } else if (element instanceof IProjectFragment) {
                Object toRefresh = this.internalGetParent(element);
                this.postRefresh(toRefresh, 0, toRefresh, runnables);
            } else {
                this.postRefresh(element, 0, element, runnables);
            }
            return;
        }
        if (resourceDeltas != null) {
            i = 0;
            while (i < resourceDeltas.length) {
                if (this.processResourceDelta(resourceDeltas[i], element, runnables)) {
                    return;
                }
                ++i;
            }
        }
        i = 0;
        while (i < affectedChildren.length) {
            if (this.processDelta(affectedChildren[i], runnables)) {
                return;
            }
            ++i;
        }
    }

    protected void processAffectedChildren(IModelElementDelta[] affectedChildren, Collection<Runnable> runnables) throws ModelException {
        int i = 0;
        while (i < affectedChildren.length) {
            this.processDelta(affectedChildren[i], runnables);
            ++i;
        }
    }

    private boolean isOnClassPath(ISourceModule element) {
        IScriptProject project = element.getScriptProject();
        if (project == null || !project.exists()) {
            return false;
        }
        return project.isOnBuildpath((IModelElement)element);
    }

    private void postUpdateIcon(IModelElement element, Collection<Runnable> runnables) {
        runnables.add(() -> this.fViewer.update((Object)element, new String[]{"org.eclipse.jface.image"}));
    }

    private boolean processResourceDelta(IResourceDelta delta, Object parent, Collection<Runnable> runnables) {
        int status = delta.getKind();
        int flags = delta.getFlags();
        IResource resource = delta.getResource();
        if (resource == null) {
            return false;
        }
        if ((status & 2) != 0) {
            if (parent instanceof IScriptFolder) {
                this.postRefresh(this.internalGetParent(parent), 1, parent, runnables);
                return true;
            }
            this.postRemove(resource, runnables);
            return false;
        }
        if ((status & 1) != 0) {
            if (parent instanceof IScriptFolder) {
                this.postRefresh(this.internalGetParent(parent), 1, parent, runnables);
                return true;
            }
            this.postAdd(parent, resource, runnables);
            return false;
        }
        if ((status & 4) != 0 && (flags & 0x8000) != 0) {
            this.postRefresh(parent, 1, resource, runnables);
            return true;
        }
        if ((flags & 0x4000) != 0) {
            this.postProjectStateChanged(this.internalGetParent(parent), runnables);
            return true;
        }
        IResourceDelta[] resourceDeltas = delta.getAffectedChildren();
        int count = 0;
        int i = 0;
        while (i < resourceDeltas.length) {
            int kind = resourceDeltas[i].getKind();
            if ((kind == 1 || kind == 2) && ++count > 1) {
                this.postRefresh(parent, 1, resource, runnables);
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < resourceDeltas.length) {
            if (this.processResourceDelta(resourceDeltas[i], resource, runnables)) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public void setIsFlatLayout(boolean state) {
        this.fIsFlatLayout = state;
    }

    public void setShowLibrariesNode(boolean state) {
        this.fShowLibrariesNode = state;
    }

    protected void postRefresh(Object root, int relation, Object affectedElement, Collection<Runnable> runnables) {
        if (this.isParent(root, this.fInput) || root instanceof IScriptModel) {
            root = this.fInput;
        }
        ArrayList<Object> toRefresh = new ArrayList<Object>(1);
        toRefresh.add(root);
        this.augmentElementToRefresh(toRefresh, relation, affectedElement);
        this.postRefresh(toRefresh, true, runnables);
    }

    protected void augmentElementToRefresh(List<Object> toRefresh, int relation, Object affectedElement) {
    }

    private boolean isParent(Object root, Object child) {
        Object parent = this.getParent(child);
        if (parent == null) {
            return false;
        }
        if (parent.equals(root)) {
            return true;
        }
        return this.isParent(root, parent);
    }

    protected void postRefresh(List<?> toRefresh, boolean updateLabels, Collection<Runnable> runnables) {
        runnables.add(() -> {
            for (Object item : toRefresh) {
                this.fViewer.refresh(item, updateLabels);
            }
        });
    }

    protected void postAdd(Object parent, Object element, Collection<Runnable> runnables) {
        runnables.add(() -> {
            Widget[] items = this.fViewer.testFindItems(element);
            int i = 0;
            while (i < items.length) {
                TreeItem parentItem;
                Widget item = items[i];
                if (item instanceof TreeItem && !item.isDisposed() && (parentItem = ((TreeItem)item).getParentItem()) != null && !parentItem.isDisposed() && parent.equals(parentItem.getData())) {
                    return;
                }
                ++i;
            }
            this.fViewer.add(parent, element);
        });
    }

    protected void postRemove(Object element, Collection<Runnable> runnables) {
        runnables.add(() -> this.fViewer.remove(element));
    }

    protected void postProjectStateChanged(Object root, Collection<Runnable> runnables) {
        runnables.add(() -> {
            this.fViewer.refresh(root, true);
            this.fViewer.setSelection(this.fViewer.getSelection());
        });
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.arePackagesFoldedInHierarchicalLayout() != this.fFoldPackages) {
            this.fFoldPackages = this.arePackagesFoldedInHierarchicalLayout();
            if (this.fViewer != null && !this.fViewer.getControl().isDisposed()) {
                this.fViewer.getControl().setRedraw(false);
                Object[] expandedObjects = this.fViewer.getExpandedElements();
                this.fViewer.refresh();
                this.fViewer.setExpandedElements(expandedObjects);
                this.fViewer.getControl().setRedraw(true);
            }
        }
    }
}

