/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text;

import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.ui.DLTKUILanguageManager;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.editor.IScriptAnnotation;
import org.eclipse.dltk.ui.text.ScriptCorrectionProcessorManager;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;

public class ScriptAnnotationUtils {
    public static boolean hasCorrections(IScriptAnnotation annotation) {
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)annotation.getSourceModule());
        if (toolkit == null) {
            return false;
        }
        IDLTKUILanguageToolkit uiToolkit = DLTKUILanguageManager.getLanguageToolkit(toolkit.getNatureId());
        if (uiToolkit != null && !uiToolkit.getPreferenceStore().getBoolean("ScriptEditor.ShowTemporaryProblem")) {
            return false;
        }
        return ScriptCorrectionProcessorManager.canFix(toolkit.getNatureId(), (Annotation)annotation);
    }

    public static boolean isQuickFixableType(Annotation annotation) {
        return (annotation instanceof IScriptAnnotation || annotation instanceof SimpleMarkerAnnotation) && !annotation.isMarkedDeleted();
    }
}

