/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.emf2xml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMAdapter;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMRenderer;
import org.eclipse.wst.common.internal.emf.resource.ReferencedResource;
import org.eclipse.wst.common.internal.emf.resource.TranslatorResource;
import org.eclipse.wst.common.internal.emf.utilities.DOMUtilities;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.common.internal.emfworkbench.integration.ResourceSetWorkbenchEditSynchronizer;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.model.ModelLifecycleEvent;
import org.eclipse.wst.sse.core.internal.provisional.IModelLifecycleListener;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeImpl;
import org.eclipse.wst.xml.core.internal.emf2xml.EMF2DOMSSEAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class EMF2DOMSSERenderer
extends EMF2DOMRenderer
implements IModelStateListener,
IModelLifecycleListener {
    protected Object aboutToChangeNode = null;
    protected boolean isBatchChanges = false;
    private boolean isSaving = false;
    private IModelManager modelManager;
    private Class resourceClass;
    private boolean reverting = false;
    protected IDOMModel xmlModel;
    protected String xmlModelId;
    protected boolean xmlModelReverted = false;

    public void accessForRead() {
        if (!this.resource.isNew()) {
            String id = this.getModelManagerId();
            this.getModelManager().getExistingModelForRead((Object)id);
        }
    }

    public void accessForWrite() {
        this.modelAccessForWrite();
    }

    public void batchModeEnd() {
        this.getXMLModel().changedModel();
        this.setRootNodeAdapterNotificationEnabled(true);
        this.isBatchChanges = false;
    }

    public void batchModeStart() {
        this.isBatchChanges = true;
        this.getXMLModel().aboutToChangeModel();
        this.setRootNodeAdapterNotificationEnabled(false);
    }

    private void cacheSynchronizationStamp() {
        IFile file = WorkbenchResourceHelper.getFile((ReferencedResource)this.resource);
        if (file != null && this.xmlModel != null) {
            this.xmlModel.resetSynchronizationStamp((IResource)file);
        }
    }

    protected void createDocument() {
        TranslatorResource res = this.getResource();
        res.setDefaults();
        IFile file = WorkbenchResourceHelper.getFile((ReferencedResource)this.resource);
        InputStream is = DOMUtilities.createHeaderInputStream((String)res.getDoctype(), (String)res.getPublicId(), (String)res.getSystemId());
        if (is == null) {
            return;
        }
        try {
            block13: {
                try {
                    try {
                        ArrayList<IContainer> folders = new ArrayList<IContainer>();
                        IContainer container = file.getParent();
                        while (container != null && !container.exists() && container instanceof IFolder) {
                            folders.add(container);
                            container = container.getParent();
                        }
                        IFolder folder = null;
                        int i = 0;
                        while (i < folders.size()) {
                            folder = (IFolder)folders.get(i);
                            folder.create(true, true, null);
                            ++i;
                        }
                        file.create(is, true, null);
                        file.setLocal(true, 1, null);
                    }
                    catch (CoreException e1) {
                        Logger.logException(e1);
                        if (is != null) {
                            is.close();
                        }
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        is.close();
                    }
                    throw throwable;
                }
                if (is != null) {
                    is.close();
                }
            }
            this.initializeXMLModel(file, this.resource.getWriteCount() != 0);
        }
        catch (IOException iOException) {
            Logger.log(4, "IWAE0017E Unexpected IO exception occurred creating xml document");
        }
    }

    protected void createDOMTreeIfNecessary() {
        if (this.needsToCreateDOM) {
            this.createDOMTree();
        }
    }

    protected EMF2DOMAdapter createRootDOMAdapter() {
        return new EMF2DOMSSEAdapter(this.getResource(), this.document, (EMF2DOMRenderer)this, this.getResource().getRootTranslator());
    }

    public void deRegisterAsModelLifecycleListener() {
        if (this.xmlModel != null) {
            this.xmlModel.removeModelLifecycleListener(this);
        }
    }

    public void deRegisterAsModelStateListener() {
        if (this.xmlModel != null) {
            this.xmlModel.removeModelStateListener(this);
        }
    }

    private void deregisterFromXMLModel() {
        EMF2DOMAdapter adapter;
        this.deRegisterAsModelStateListener();
        this.deRegisterAsModelLifecycleListener();
        try {
            this.getModelManager();
        }
        catch (ClassCastException classCastException) {
            return;
        }
        if (this.xmlModel != null) {
            int writeCount = this.resource.getWriteCount();
            int readCount = this.resource.getReadCount();
            int i = 0;
            while (i < writeCount) {
                this.xmlModel.releaseFromEdit();
                ++i;
            }
            int ii = 0;
            while (ii < readCount) {
                this.xmlModel.releaseFromRead();
                ++ii;
            }
        }
        if ((adapter = (EMF2DOMAdapter)EcoreUtil.getAdapter((List)this.resource.eAdapters(), (Object)EMF2DOMAdapter.ADAPTER_CLASS)) != null) {
            adapter.removeAdapters(adapter.getNode());
        }
        this.xmlModel = null;
        this.xmlModelId = null;
    }

    public void doSave(OutputStream outputStream, Map options) throws IOException {
        try {
            this.isSaving = true;
            if (outputStream != null) {
                throw new RuntimeException(((Object)((Object)this)).getClass().getName() + " should not use an OutputStream for saving");
            }
            this.createDOMTreeIfNecessary();
            ResourceSetWorkbenchEditSynchronizer synchronizer = (ResourceSetWorkbenchEditSynchronizer)((ProjectResourceSet)this.resource.getResourceSet()).getSynchronizer();
            IFile aFile = WorkbenchResourceHelper.getFile((ReferencedResource)this.resource);
            try {
                synchronizer.preSave(aFile, (Resource)this.resource);
                this.xmlModel.save(aFile);
            }
            catch (CoreException ex) {
                synchronizer.removeFromRecentlySavedList(aFile);
                Logger.logException(ex);
            }
            this.cacheSynchronizationStamp();
        }
        finally {
            this.isSaving = false;
        }
    }

    public EMF2DOMAdapter getExistingDOMAdapter(Node node) {
        INodeNotifier sseNode = (INodeNotifier)node;
        Collection adapters = sseNode.getAdapters();
        for (INodeAdapter adapter : adapters) {
            if (adapter == null || !adapter.isAdapterForType((Object)EMF2DOMAdapter.ADAPTER_CLASS)) continue;
            EMF2DOMSSEAdapter e2DAdapter = (EMF2DOMSSEAdapter)adapter;
            if (this.getResource() == null || e2DAdapter.getTarget() == null) {
                if (!this.resourceClass.equals(e2DAdapter.getResourceClass())) continue;
                return e2DAdapter;
            }
            if (e2DAdapter.getTarget() instanceof Resource) {
                if (e2DAdapter.getTarget() != this.getResource()) continue;
                return e2DAdapter;
            }
            TranslatorResource myTarget = this.getResource();
            EObject adapterTarget = (EObject)e2DAdapter.getTarget();
            if (adapterTarget.eResource() != myTarget && adapterTarget.eResource() != null) continue;
            return e2DAdapter;
        }
        return null;
    }

    protected IModelManager getModelManager() {
        if (this.modelManager == null) {
            this.modelManager = StructuredModelManager.getModelManager();
        }
        return this.modelManager;
    }

    protected String getModelManagerId() {
        if (this.xmlModelId == null) {
            IFile file = WorkbenchResourceHelper.getFile((ReferencedResource)this.getResource());
            this.xmlModelId = file != null ? this.getModelManager().calculateId(file) : String.valueOf(this.resource.getURI()) + Long.toString(System.currentTimeMillis());
        }
        return this.xmlModelId;
    }

    protected ResourceSet getResourceSet() {
        return this.resource == null ? null : this.resource.getResourceSet();
    }

    public IDOMModel getXMLModel() {
        return this.xmlModel;
    }

    public String getXMLModelId() {
        return this.xmlModelId;
    }

    private IDOMModel initializeXMLModel(IFile file, boolean forWrite) throws UnsupportedEncodingException, IOException {
        if (file == null || !file.exists()) {
            throw new FileNotFoundException(file == null ? "null" : file.getFullPath().toOSString());
        }
        try {
            IModelManager manager = this.getModelManager();
            String id = manager.calculateId(file);
            if (forWrite) {
                IDOMModel mod = (IDOMModel)manager.getExistingModelForEdit((Object)id);
                if (mod == null) {
                    this.setXMLModel((IDOMModel)manager.getModelForEdit(file));
                } else {
                    this.setXMLModel(mod);
                }
            } else {
                IDOMModel mod = (IDOMModel)manager.getExistingModelForRead((Object)id);
                if (mod == null) {
                    this.setXMLModel((IDOMModel)manager.getModelForRead(file));
                } else {
                    this.setXMLModel(mod);
                }
            }
            this.setXMLModelId(this.getXMLModel().getId());
            this.needsToCreateDOM = false;
        }
        catch (CoreException e) {
            Logger.logException(e);
            return null;
        }
        String id = this.getXMLModel().getId();
        this.syncReferenceCounts(id, forWrite);
        if (this.xmlModel != null) {
            this.document = this.xmlModel.getDocument();
        }
        return this.xmlModel;
    }

    public boolean isBatchMode() {
        return this.isBatchChanges;
    }

    public boolean isModified() {
        return this.getXMLModel() != null && this.getXMLModel().isDirty();
    }

    public boolean isShared() {
        if (this.xmlModel == null) {
            String id = this.getModelManagerId();
            return this.getModelManager().isShared((Object)id);
        }
        if (this.getResourceSet() == null) {
            return false;
        }
        return this.xmlModel.isShared();
    }

    public boolean isSharedForWrite() {
        if (this.getResourceSet() == null || this.xmlModel == null) {
            return false;
        }
        return this.xmlModel.isSharedForEdit();
    }

    protected void loadDocument(InputStream in, Map options) throws IOException {
        if (in != null) {
            throw new RuntimeException(((Object)((Object)this)).getClass().getName() + " should not use an InputStream for loading");
        }
        IFile file = WorkbenchResourceHelper.getFile((ReferencedResource)this.resource);
        this.initializeXMLModel(file, this.resource.getWriteCount() != 0);
        this.cacheSynchronizationStamp();
    }

    protected boolean managesDOMAdapters() {
        return false;
    }

    public void modelAboutToBeChanged(IStructuredModel model) {
        if (model.getStructuredDocument() != null) {
            this.aboutToChangeNode = model.getStructuredDocument().getFirstStructuredDocumentRegion();
        }
    }

    public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
    }

    private void modelAccessForWrite() {
        String id = this.getModelManagerId();
        this.getModelManager().getExistingModelForEdit((Object)id);
    }

    public void modelChanged(IStructuredModel model) {
        block8: {
            if (this.isBatchChanges) {
                return;
            }
            try {
                if (!this.reverting || this.aboutToChangeNode == null || model.getStructuredDocument() == null || model.getStructuredDocument().getFirstStructuredDocumentRegion() == this.aboutToChangeNode) break block8;
                String id = this.getModelManagerId();
                IStructuredModel tempModel = null;
                try {
                    tempModel = this.getModelManager().getExistingModelForEdit((Object)id);
                    this.xmlModelReverted = true;
                    this.resource.unload();
                }
                finally {
                    if (tempModel != null && tempModel.getReferenceCountForEdit() > 0) {
                        tempModel.releaseFromEdit();
                    }
                    this.reverting = false;
                }
            }
            finally {
                this.aboutToChangeNode = null;
            }
        }
    }

    public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
        if (!isDirty && this.resource.isModified()) {
            this.resource.setModified(false);
            long stamp = WorkbenchResourceHelper.computeModificationStamp((ReferencedResource)this.resource);
            WorkbenchResourceHelper.setSynhronizationStamp((ReferencedResource)this.resource, (long)stamp);
            IProject proj = WorkbenchResourceHelper.getProject((Resource)this.resource);
            ResourceSetWorkbenchEditSynchronizer synchronizer = (ResourceSetWorkbenchEditSynchronizer)((ProjectResourceSet)WorkbenchResourceHelperBase.getResourceSet((IProject)proj)).getSynchronizer();
            IFile aFile = WorkbenchResourceHelper.getFile((ReferencedResource)this.resource);
            synchronizer.preSave(aFile, (Resource)this.resource);
        }
        if (isDirty) {
            this.resource.setModified(true);
        }
    }

    public void modelReinitialized(IStructuredModel structuredModel) {
    }

    public void modelResourceDeleted(IStructuredModel model) {
    }

    public void modelResourceMoved(IStructuredModel oldModel, IStructuredModel newModel) {
    }

    public void preDelete() {
        if (this.resource.isLoaded()) {
            this.deregisterFromXMLModel();
        }
    }

    public void preUnload() {
        this.deregisterFromXMLModel();
    }

    public void processPostModelEvent(ModelLifecycleEvent event) {
        if (event.getType() == 5) {
            this.reverting = false;
        }
    }

    public void processPreModelEvent(ModelLifecycleEvent event) {
        if (event.getType() == 5) {
            this.reverting = true;
        }
        if (!this.isSaving && event.getType() == 1) {
            ResourceSetWorkbenchEditSynchronizer synchronizer = (ResourceSetWorkbenchEditSynchronizer)((ProjectResourceSet)this.resource.getResourceSet()).getSynchronizer();
            IFile aFile = WorkbenchResourceHelper.getFile((ReferencedResource)this.resource);
            synchronizer.preSave(aFile, (Resource)this.resource);
        }
    }

    public void registerAsModelLifecycleListener() {
        this.xmlModel.addModelLifecycleListener(this);
    }

    public void registerAsModelStateListener() {
        this.xmlModel.addModelStateListener(this);
    }

    public void releaseFromRead() {
        if (this.xmlModel != null) {
            this.xmlModel.releaseFromRead();
        }
    }

    public void releaseFromWrite() {
        if (this.xmlModel != null) {
            this.xmlModel.releaseFromEdit();
        }
    }

    public void removeDOMAdapter(Node aNode, EMF2DOMAdapter anAdapter) {
        ((IDOMNode)aNode).removeAdapter((EMF2DOMSSEAdapter)anAdapter);
    }

    public void replaceDocumentType(String docTypeName, String publicId, String systemId) {
        if (this.document == null) {
            return;
        }
        DocumentTypeImpl docType = (DocumentTypeImpl)this.document.getDoctype();
        if (docType == null) {
            return;
        }
        if (publicId == null && systemId == null) {
            this.document.removeChild(docType);
        } else {
            docType.setPublicId(publicId);
            docType.setSystemId(systemId);
        }
    }

    public void setBatchMode(boolean isBatch) {
        if (isBatch && this.isBatchChanges) {
            Logger.log(201, "setBatch was set to true when it was already true. This can be an indication of invalid calling order");
        }
        if (isBatch) {
            this.batchModeStart();
        } else {
            this.batchModeEnd();
        }
    }

    private void setRootNodeAdapterNotificationEnabled(boolean b) {
        EMF2DOMAdapter adapter;
        EObject root = this.resource.getRootObject();
        if (root != null && (adapter = (EMF2DOMAdapter)EcoreUtil.getExistingAdapter((Notifier)root, (Object)EMF2DOMAdapter.ADAPTER_CLASS)) != null) {
            adapter.setNotificationEnabled(b);
            if (b) {
                adapter.updateDOM();
            }
        }
    }

    public void setXMLModel(IDOMModel xmlModel) {
        this.deRegisterAsModelStateListener();
        this.deRegisterAsModelLifecycleListener();
        this.xmlModel = xmlModel;
        this.registerAsModelStateListener();
        this.registerAsModelLifecycleListener();
    }

    public void setXMLModelId(String id) {
        this.xmlModelId = id;
    }

    private void syncReferenceCounts(String id, boolean forWrite) {
        int editIndex = 0;
        int readIndex = 0;
        if (forWrite) {
            ++editIndex;
        } else {
            ++readIndex;
        }
        int writeCount = this.resource.getWriteCount();
        int readCount = this.resource.getReadCount();
        int i = writeCount;
        while (i > editIndex) {
            this.modelManager.getExistingModelForEdit((Object)id);
            --i;
        }
        i = readCount;
        while (i > readIndex) {
            this.modelManager.getExistingModelForRead((Object)id);
            --i;
        }
    }

    public boolean useStreamsForIO() {
        return false;
    }

    public boolean wasReverted() {
        return this.xmlModelReverted;
    }

    public void setResource(TranslatorResource resource) {
        super.setResource(resource);
        if (resource != null) {
            this.resourceClass = resource.getClass();
        }
    }

    public boolean isReverting() {
        return this.reverting;
    }
}

