/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.internal.wizards.datatransfer.MinimizedFileSystemElement;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.SelectFilesOperation;

public class PopulateRootOperation
extends SelectFilesOperation {
    public PopulateRootOperation(Object rootObject, IImportStructureProvider structureProvider) {
        super(rootObject, structureProvider);
    }

    @Override
    protected FileSystemElement createElement(FileSystemElement parent, Object fileSystemObject) throws InterruptedException {
        return this.createElement(parent, fileSystemObject, 2);
    }

    protected FileSystemElement createElement(FileSystemElement parent, Object fileSystemObject, int depth) throws InterruptedException {
        ModalContext.checkCanceled((IProgressMonitor)this.currentMonitor);
        boolean isContainer = this.provider.isFolder(fileSystemObject);
        String elementLabel = parent == null ? this.provider.getFullPath(fileSystemObject) : this.provider.getLabel(fileSystemObject);
        MinimizedFileSystemElement createdElement = new MinimizedFileSystemElement(elementLabel, parent, isContainer);
        createdElement.setFileSystemObject(fileSystemObject);
        if (isContainer && depth > 0) {
            ArrayList children = this.provider.getChildren(fileSystemObject);
            if (children == null) {
                children = new ArrayList(1);
            }
            Iterator childrenEnum = children.iterator();
            while (childrenEnum.hasNext()) {
                this.createElement(createdElement, childrenEnum.next(), depth - 1);
            }
            createdElement.setPopulated();
        }
        return createdElement;
    }
}

