/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.wst.jsdt.web.ui.actions.JsElementActionProxy;

public class ShowInScriptExplorerAction
extends JsElementActionProxy {
    private IResource getHostResource(IJavaScriptElement virtualElement) {
        IProject project = virtualElement.getJavaScriptProject().getProject();
        Path path = new Path(virtualElement.getHostPath().getPath());
        IResource host = project.getWorkspace().getRoot().findMember((IPath)path);
        return host;
    }

    @Override
    public Object[] getRunArgs(IAction action) {
        IJavaScriptElement[] elements = JsElementActionProxy.getJsElementsFromSelection(this.getCurrentSelection());
        if (elements != null && elements.length > 0) {
            return new Object[]{elements[0]};
        }
        return new Object[0];
    }

    @Override
    public Class[] getRunArgTypes() {
        return new Class[]{IJavaScriptElement.class};
    }

    @Override
    public void run(IAction action) {
        IJavaScriptElement[] elements = JsElementActionProxy.getJsElementsFromSelection(this.getCurrentSelection());
        if (elements == null || elements.length == 0) {
            return;
        }
        IResource resource = null;
        resource = elements[0].isVirtual() ? this.getHostResource(elements[0]) : elements[0].getResource();
        if (resource == null) {
            return;
        }
        try {
            PackageExplorerPart view = PackageExplorerPart.openInActivePerspective();
            view.tryToReveal((Object)resource);
            if (view instanceof ISetSelectionTarget) {
                StructuredSelection selection = new StructuredSelection((Object)resource);
                view.selectReveal((ISelection)selection);
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        this.setSelection(selection);
        IJavaScriptElement[] elements = JsElementActionProxy.getJsElementsFromSelection(this.getCurrentSelection());
        int i = 0;
        while (i < elements.length) {
            IResource resource;
            if (elements[i].isVirtual() && ((resource = this.getHostResource(elements[i])) == null || !resource.exists())) {
                action.setEnabled(false);
            }
            ++i;
        }
    }
}

