/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.util;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import org.eclipse.scout.sdk.core.util.Ensure;

public final class EventListenerList {
    private List<Object> m_listeners;
    private final Object m_lock = new Object();

    private List<Object> getOrCreateList() {
        if (this.m_listeners == null) {
            this.m_listeners = new ArrayList<Object>();
        }
        return this.m_listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_listeners == null) {
                return;
            }
            this.m_listeners.clear();
            this.m_listeners = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(EventListener listener) {
        Object object = this.m_lock;
        synchronized (object) {
            if (listener instanceof IWeakEventListener) {
                this.getOrCreateList().add(new WeakReference<EventListener>(listener));
            } else {
                this.getOrCreateList().add(Ensure.notNull(listener));
            }
        }
    }

    public Collection<EventListener> get() {
        return this.get(EventListener.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends EventListener> List<T> get(Class<T> type) {
        ArrayList<Object> listeners;
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_listeners == null) {
                return Collections.emptyList();
            }
            listeners = new ArrayList<Object>(this.m_listeners.size());
            Iterator<Object> iterator = this.m_listeners.iterator();
            while (iterator.hasNext()) {
                Object listener = iterator.next();
                if (listener instanceof Reference) {
                    Object inner = ((Reference)listener).get();
                    if (inner == null) {
                        iterator.remove();
                        continue;
                    }
                    listeners.add(inner);
                    continue;
                }
                listeners.add(listener);
            }
        }
        ArrayList<Object> result = listeners;
        if (type == null) {
            return Collections.unmodifiableList(result);
        }
        return result.stream().filter(candidate -> type.isAssignableFrom(candidate.getClass())).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(EventListener listenerToRemove) {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_listeners == null || listenerToRemove == null) {
                return false;
            }
            boolean removed = false;
            Iterator<Object> iterator = this.m_listeners.iterator();
            while (iterator.hasNext()) {
                Object inner;
                Object entry = iterator.next();
                if (entry == listenerToRemove) {
                    iterator.remove();
                    removed = true;
                    continue;
                }
                if (!(entry instanceof Reference) || (inner = ((Reference)entry).get()) != null && inner != listenerToRemove) continue;
                iterator.remove();
                removed = true;
            }
            if (removed && this.m_listeners.isEmpty()) {
                this.m_listeners = null;
            }
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_listeners == null) {
                return 0;
            }
            return this.m_listeners.size();
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public static interface IWeakEventListener
    extends EventListener {
    }
}

