/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.StashCreateHandler;
import org.eclipse.egit.ui.internal.commit.CommitEditor;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.selection.SelectionUtils;
import org.eclipse.egit.ui.internal.stash.StashCreateUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class StashesMenu
extends CompoundContributionItem
implements IWorkbenchContribution {
    private IServiceLocator serviceLocator;

    public void initialize(IServiceLocator locator) {
        this.serviceLocator = locator;
    }

    protected IContributionItem[] getContributionItems() {
        Repository repository = this.getRepository();
        ArrayList<Object> items = new ArrayList<Object>();
        items.add(StashesMenu.createStashChangesItem(repository));
        items.add(new Separator());
        items.addAll(StashesMenu.createStashItems(repository));
        return items.toArray(new IContributionItem[0]);
    }

    private static IContributionItem createStashChangesItem(final Repository repository) {
        Action action = new Action(UIText.StashesMenu_StashChangesActionText, UIIcons.STASH_CREATE){

            public void run() {
                StashCreateUI stashCreateUI = new StashCreateUI(repository);
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                stashCreateUI.createStash(shell);
            }

            public boolean isEnabled() {
                return StashCreateHandler.isEnabled(repository);
            }
        };
        return new ActionContributionItem((IAction)action);
    }

    private static Collection<IContributionItem> createStashItems(Repository repository) {
        if (repository == null) {
            return Collections.singleton(StashesMenu.createNoStashedChangesItem());
        }
        try {
            Collection stashCommits = Git.wrap((Repository)repository).stashList().call();
            if (stashCommits.isEmpty()) {
                return Collections.singleton(StashesMenu.createNoStashedChangesItem());
            }
            ArrayList<IContributionItem> items = new ArrayList<IContributionItem>(stashCommits.size());
            int index = 0;
            for (RevCommit stashCommit : stashCommits) {
                items.add((IContributionItem)StashesMenu.createStashItem(repository, stashCommit, index++));
            }
            return items;
        }
        catch (GitAPIException e) {
            String repoName = repository.getWorkTree().getName();
            String message = MessageFormat.format(UIText.StashesMenu_StashListError, repoName);
            Activator.logError(message, e);
            return Collections.singleton(StashesMenu.createNoStashedChangesItem());
        }
    }

    private static IContributionItem createNoStashedChangesItem() {
        Action action = new Action(UIText.StashesMenu_NoStashedChangesText){

            public boolean isEnabled() {
                return false;
            }
        };
        return new ActionContributionItem((IAction)action);
    }

    private Repository getRepository() {
        if (this.serviceLocator == null) {
            return null;
        }
        IHandlerService handlerService = (IHandlerService)this.serviceLocator.getService(IHandlerService.class);
        if (handlerService == null) {
            return null;
        }
        IEvaluationContext evaluationContext = handlerService.getCurrentState();
        return SelectionUtils.getRepository(evaluationContext);
    }

    private static ActionContributionItem createStashItem(final Repository repo, final RevCommit stashCommit, int index) {
        String text = MessageFormat.format(UIText.StashesMenu_StashItemText, index, stashCommit.getShortMessage());
        Action action = new Action(text){

            public void run() {
                RepositoryCommit repositoryCommit = new RepositoryCommit(repo, stashCommit);
                repositoryCommit.setStash(true);
                CommitEditor.openQuiet(repositoryCommit);
            }
        };
        return new ActionContributionItem((IAction)action);
    }
}

