/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.support.conversion;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.function.Function;
import org.junit.platform.commons.support.conversion.StringToObjectConverter;
import org.junit.platform.commons.util.Preconditions;

class StringToNumberConverter
implements StringToObjectConverter {
    private static final Map<Class<?>, Function<String, ?>> CONVERTERS = Map.of(Byte.class, Byte::decode, Short.class, Short::decode, Integer.class, Integer::decode, Long.class, Long::decode, Float.class, Float::valueOf, Double.class, Double::valueOf, BigInteger.class, BigInteger::new, BigDecimal.class, BigDecimal::new);

    StringToNumberConverter() {
    }

    @Override
    public boolean canConvertTo(Class<?> targetType) {
        return CONVERTERS.containsKey(targetType);
    }

    @Override
    public Object convert(String source, Class<?> targetType) {
        Function<String, ?> converter = Preconditions.notNull(CONVERTERS.get(targetType), () -> "No registered converter for %s".formatted(targetType.getName()));
        return converter.apply(source.replace("_", ""));
    }
}

