/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.environment.uri;

import java.net.URL;
import java.util.Hashtable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.environment.uri.IURI;
import org.eclipse.wst.common.environment.uri.IURIFactory;
import org.eclipse.wst.common.environment.uri.IURIScheme;
import org.eclipse.wst.common.environment.uri.URIException;
import org.eclipse.wst.common.internal.environment.eclipse.Messages;
import org.eclipse.wst.common.internal.environment.relative.RelativeScheme;

public class SimpleURIFactory
implements IURIFactory {
    private Hashtable schemes_ = new Hashtable();

    @Override
    public IURI newURI(String uri) throws URIException {
        IURIScheme scheme = this.newURIScheme(uri, false);
        return scheme.newURI(uri);
    }

    @Override
    public IURI newURI(URL url) throws URIException {
        IURIScheme scheme = this.newURIScheme(url.toString(), false);
        return scheme.newURI(url);
    }

    @Override
    public IURIScheme newURIScheme(String schemeOrURI) throws URIException {
        return this.newURIScheme(schemeOrURI, true);
    }

    public void registerScheme(String protocol, IURIScheme scheme) {
        this.schemes_.put(protocol, scheme);
    }

    private IURIScheme newURIScheme(String schemeOrURI, boolean checkForScheme) throws URIException {
        IURIScheme newScheme = null;
        if (schemeOrURI == null) {
            throw new URIException((IStatus)new Status(4, "id", 0, NLS.bind((String)Messages.MSG_NULL_ARG_SPECIFIED, (Object)"newURIScheme"), null));
        }
        int colon = schemeOrURI.indexOf(58);
        int slash = schemeOrURI.indexOf(47);
        if (checkForScheme && colon == -1 || colon != -1 && slash == -1 || colon != -1 && colon < slash) {
            String protocol;
            if (colon == -1) {
                colon = schemeOrURI.length();
            }
            if ((newScheme = (IURIScheme)this.schemes_.get(protocol = schemeOrURI.substring(0, colon))) == null) {
                throw new URIException((IStatus)new Status(4, "id", 0, NLS.bind((String)Messages.MSG_SCHEME_NOT_FOUND, (Object)schemeOrURI), null));
            }
        } else {
            if (schemeOrURI.startsWith("/")) {
                throw new URIException((IStatus)new Status(4, "id", 0, NLS.bind((String)Messages.MSG_ABSOLUTE_PATH_WITHOUT_SCHEME, (Object)schemeOrURI), null));
            }
            newScheme = new RelativeScheme();
        }
        return newScheme;
    }
}

