/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.services.IEvaluationReference;
import org.eclipse.ui.services.IEvaluationService;

public class SlaveEvaluationService
implements IEvaluationService {
    private final IEvaluationService parentService;
    private final Collection sourceProviders = new ArrayList();
    private final Collection serviceListeners = new ArrayList();
    private final Collection evaluationReferences = new ArrayList();

    public SlaveEvaluationService(IEvaluationService parent) {
        this.parentService = parent;
    }

    @Override
    public IEvaluationReference addEvaluationListener(Expression expression, IPropertyChangeListener listener, String property) {
        IEvaluationReference ref = this.parentService.addEvaluationListener(expression, listener, property);
        if (!this.evaluationReferences.contains(ref)) {
            this.evaluationReferences.add(ref);
        }
        return ref;
    }

    @Override
    public void addEvaluationReference(IEvaluationReference ref) {
        if (!this.evaluationReferences.contains(ref)) {
            this.evaluationReferences.add(ref);
        }
        this.parentService.addEvaluationReference(ref);
    }

    @Override
    public void addServiceListener(IPropertyChangeListener listener) {
        if (!this.serviceListeners.contains(listener)) {
            this.serviceListeners.add(listener);
        }
        this.parentService.addServiceListener(listener);
    }

    @Override
    public void addSourceProvider(ISourceProvider provider) {
        if (!this.sourceProviders.contains(provider)) {
            this.sourceProviders.add(provider);
        }
        this.parentService.addSourceProvider(provider);
    }

    @Override
    public IEvaluationContext getCurrentState() {
        return this.parentService.getCurrentState();
    }

    @Override
    public void removeEvaluationListener(IEvaluationReference ref) {
        this.evaluationReferences.remove(ref);
        this.parentService.removeEvaluationListener(ref);
    }

    @Override
    public void removeServiceListener(IPropertyChangeListener listener) {
        this.serviceListeners.remove(listener);
        this.parentService.removeServiceListener(listener);
    }

    @Override
    public void removeSourceProvider(ISourceProvider provider) {
        this.sourceProviders.remove(provider);
        this.parentService.removeSourceProvider(provider);
    }

    @Override
    public void dispose() {
        int n;
        int n2;
        Object[] objectArray;
        if (!this.evaluationReferences.isEmpty()) {
            objectArray = this.evaluationReferences.toArray();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                Object evaluationListener = objectArray[n];
                this.parentService.removeEvaluationListener((IEvaluationReference)evaluationListener);
                ++n;
            }
        }
        if (!this.serviceListeners.isEmpty()) {
            objectArray = this.serviceListeners.toArray();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                Object serviceListener = objectArray[n];
                this.parentService.removeServiceListener((IPropertyChangeListener)serviceListener);
                ++n;
            }
            this.serviceListeners.clear();
        }
        if (!this.sourceProviders.isEmpty()) {
            objectArray = this.sourceProviders.toArray();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                Object sourceProvider = objectArray[n];
                this.parentService.removeSourceProvider((ISourceProvider)sourceProvider);
                ++n;
            }
            this.sourceProviders.clear();
        }
    }

    @Override
    public void requestEvaluation(String propertyName) {
        this.parentService.requestEvaluation(propertyName);
    }
}

