/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.importexport;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.importexport.ExportTracePackageSelectTraceWizardPage;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.importexport.ExportTracePackageWizardPage;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class ExportTracePackageWizard
extends Wizard
implements IExportWizard {
    private static final String STORE_EXPORT_TRACE_WIZARD = "ExportTraceWizard";
    private IStructuredSelection fSelection;
    private List<TmfCommonProjectElement> fSelectedTraces;
    private ExportTracePackageWizardPage fPage;

    public ExportTracePackageWizard() {
        IDialogSettings workbenchSettings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(STORE_EXPORT_TRACE_WIZARD);
        if (section == null) {
            section = workbenchSettings.addNewSection(STORE_EXPORT_TRACE_WIZARD);
        }
        this.setDialogSettings(section);
        this.fSelectedTraces = new ArrayList<TmfCommonProjectElement>();
    }

    public ExportTracePackageWizard(List<TmfTraceElement> selectedTraces) {
        this();
        this.fSelectedTraces = new ArrayList<TmfTraceElement>(selectedTraces);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fSelection = selection;
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (item instanceof TmfExperimentElement) {
                TmfExperimentElement experimentElement = (TmfExperimentElement)item;
                this.fSelectedTraces.add(experimentElement);
                for (TmfTraceElement expTrace : experimentElement.getTraces()) {
                    TmfTraceElement trace = expTrace.getElementUnderTraceFolder();
                    if (this.fSelectedTraces.contains(trace)) continue;
                    this.fSelectedTraces.add(trace);
                }
            }
            ++n2;
        }
        this.setWindowTitle(Messages.ExportTracePackageWizardPage_Title);
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        return this.fPage.finish();
    }

    public void addPages() {
        super.addPages();
        this.fPage = new ExportTracePackageWizardPage(this.fSelection, this.fSelectedTraces);
        if (this.fSelectedTraces.isEmpty()) {
            this.addPage((IWizardPage)new ExportTracePackageSelectTraceWizardPage());
        }
        this.addPage((IWizardPage)this.fPage);
    }
}

