/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.midx;

import java.util.Set;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;

public interface MultiPackIndex {
    public String[] getPackNames();

    public boolean hasObject(AnyObjectId var1);

    public PackOffset find(AnyObjectId var1);

    public int findPosition(AnyObjectId var1);

    public int findBitmapPosition(PackOffset var1);

    public ObjectId getObjectAtBitmapPosition(int var1);

    public ObjectId getObjectAt(int var1);

    public int getObjectCount();

    public void resolve(Set<ObjectId> var1, AbbreviatedObjectId var2, int var3);

    public byte[] getChecksum();

    public long getMemorySize();

    public static class PackOffset
    implements Comparable<PackOffset> {
        private int packId;
        private long offset;

        public static PackOffset create(int packId, long offset) {
            return new PackOffset().setValues(packId, offset);
        }

        public PackOffset setValues(int packId, long offset) {
            this.packId = packId;
            this.offset = offset;
            return this;
        }

        public int getPackId() {
            return this.packId;
        }

        public long getOffset() {
            return this.offset;
        }

        public PackOffset copy() {
            PackOffset copy = new PackOffset();
            return copy.setValues(this.packId, this.offset);
        }

        @Override
        public int compareTo(PackOffset packOffset) {
            int cmp = this.packId - packOffset.packId;
            if (cmp != 0) {
                return cmp;
            }
            return Long.compare(this.offset, packOffset.offset);
        }
    }
}

