/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.ui.wizards;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IRegistry;
import org.eclipse.linuxtools.internal.docker.core.RegistryInfo;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageSearchModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageSearchPage;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageTagSelectionPage;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;

public class ImageSearch
extends Wizard {
    private final ImageSearchPage imageSearchPage;
    private final ImageTagSelectionPage imageTagSelectionPage;
    private final ImageSearchModel imageSearchModel;

    public ImageSearch(IDockerConnection connection, String name, IRegistry reg) {
        this.setWindowTitle(WizardMessages.getString("ImageSearch.title"));
        this.setNeedsProgressMonitor(true);
        this.imageSearchModel = new ImageSearchModel(connection, name);
        this.imageSearchPage = new ImageSearchPage(this.imageSearchModel, reg);
        this.imageTagSelectionPage = new ImageTagSelectionPage(this.imageSearchModel, reg);
    }

    public ImageSearch(IDockerConnection connection, String name) {
        this(connection, name, (IRegistry)new RegistryInfo("https://index.docker.io", true));
    }

    public void addPages() {
        this.addPage((IWizardPage)this.imageSearchPage);
        this.addPage((IWizardPage)this.imageTagSelectionPage);
    }

    public boolean canFinish() {
        return this.imageSearchPage.isPageComplete();
    }

    public boolean performFinish() {
        return true;
    }

    public String getSelectedImage() {
        return this.imageSearchPage.getSelectedImage().getName() + ":" + (this.imageTagSelectionPage.getSelectedImageTag() != null ? this.imageTagSelectionPage.getSelectedImageTag().getName() : "latest");
    }
}

