/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.build;

import org.eclipse.cdt.core.resources.ACBuilder;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class BuildPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int GROUP_VINDENT = 5;
    private static final int GROUP_HINDENT = 20;
    private Button buildActive;
    private Button buildAll;
    private Button buildOnlyOnRefChange;

    public BuildPreferencePage() {
        this.setPreferenceStore(CUIPlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferencesMessages.CBuildPreferencePage_description);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.cdt.ui.c_pref");
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(10);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        container.setLayout((Layout)layout);
        Group gr = this.addGroup(container, PreferencesMessages.CPluginPreferencePage_build_scope);
        Label l1 = new Label((Composite)gr, 0);
        l1.setText(PreferencesMessages.CPluginPreferencePage_1);
        GridData gd = new GridData(768);
        gd.verticalIndent = 5;
        l1.setLayoutData((Object)gd);
        boolean needAllConfigBuild = ACBuilder.needAllConfigBuild();
        this.buildActive = new Button((Composite)gr, 16);
        this.buildActive.setText(PreferencesMessages.CPluginPreferencePage_2);
        gd = new GridData(768);
        gd.verticalIndent = 5;
        gd.horizontalIndent = 20;
        this.buildActive.setLayoutData((Object)gd);
        this.buildActive.setSelection(!needAllConfigBuild);
        this.buildAll = new Button((Composite)gr, 16);
        this.buildAll.setText(PreferencesMessages.CPluginPreferencePage_3);
        gd = new GridData(768);
        gd.horizontalIndent = 20;
        this.buildAll.setLayoutData((Object)gd);
        this.buildAll.setSelection(needAllConfigBuild);
        this.addNote(gr, PreferencesMessages.CPluginPreferencePage_4);
        Group gr2 = this.addGroup(container, PreferencesMessages.CPluginPreferencePage_building_configurations);
        this.buildOnlyOnRefChange = new Button((Composite)gr2, 32);
        this.buildOnlyOnRefChange.setText(PreferencesMessages.CPluginPreferencePage_7);
        GridData gd2 = new GridData(768);
        gd2.verticalIndent = 5;
        this.buildOnlyOnRefChange.setLayoutData((Object)gd2);
        this.buildOnlyOnRefChange.setSelection(ACBuilder.buildConfigResourceChanges());
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    private void addNote(Group parent, String noteMessage) {
        Composite noteControl = this.createNoteComposite(JFaceResources.getDialogFont(), (Composite)parent, PreferencesMessages.CPluginPreferencePage_note, noteMessage);
        GridData gd = new GridData(256);
        gd.verticalIndent = 5;
        noteControl.setLayoutData((Object)gd);
    }

    protected Composite createNoteComposite(Font font, Composite composite, String title, String message) {
        Composite messageComposite = super.createNoteComposite(font, composite, title, message);
        Control[] children = messageComposite.getChildren();
        if (children.length == 2 && children[1] instanceof Label) {
            Label messageLabel = (Label)children[1];
            GridData gd = new GridData(768);
            gd.widthHint = 500;
            messageLabel.setLayoutData((Object)gd);
        }
        return messageComposite;
    }

    private Group addGroup(Composite parent, String label) {
        return this.addGroup(parent, label, 1);
    }

    private Group addGroup(Composite parent, String label, int numColumns) {
        Group group = new Group(parent, 0);
        group.setText(label);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(numColumns, false));
        return group;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        if (!super.performOk()) {
            return false;
        }
        ACBuilder.setAllConfigBuild((boolean)this.buildAll.getSelection());
        ACBuilder.setBuildConfigResourceChanges((boolean)this.buildOnlyOnRefChange.getSelection());
        return true;
    }

    protected void performDefaults() {
        ACBuilder.setAllConfigBuild((boolean)false);
        ACBuilder.setBuildConfigResourceChanges((boolean)false);
        this.buildActive.setSelection(true);
        this.buildAll.setSelection(false);
        this.buildOnlyOnRefChange.setSelection(false);
        super.performDefaults();
    }
}

