/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.clangd.format;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public final class RegexMarkerPattern {
    private final String markerID;
    private static final String EMPTY_STR = "";
    private final Pattern pattern;
    private final String fileExpression;
    private final String lineExpression;
    private final String columnExpression;
    private final String descriptionExpression;
    private final int severity;

    public RegexMarkerPattern(String pattern, String fileExpression, String lineExpression, String columnExpression, String descriptionExpression, int severity, String markerID) {
        this.pattern = Pattern.compile(pattern != null ? pattern : EMPTY_STR);
        this.fileExpression = fileExpression != null ? fileExpression : EMPTY_STR;
        this.lineExpression = lineExpression != null ? lineExpression : EMPTY_STR;
        this.columnExpression = columnExpression != null ? columnExpression : EMPTY_STR;
        this.descriptionExpression = descriptionExpression != null ? descriptionExpression : EMPTY_STR;
        this.severity = severity;
        this.markerID = markerID;
    }

    public void processLine(String line, IFile file, IDocument fileDocument) {
        if (line.length() > 0) {
            Matcher matcher = this.pattern.matcher(line);
            if (!matcher.matches()) {
                return;
            }
            String fileURI = matcher.replaceAll(this.fileExpression);
            if (!file.getLocation().toOSString().equals(fileURI)) {
                Platform.getLog(this.getClass()).error("Parsed .clang-format path does not match with modified .clang-format location: " + fileURI + " != " + file.getLocation().toOSString());
                return;
            }
            int lineNumber = 0;
            try {
                lineNumber = Integer.parseInt(matcher.replaceAll(this.lineExpression));
            }
            catch (NumberFormatException e) {
                Platform.getLog(this.getClass()).error("Cannot parse line number from pattern: " + this.pattern.pattern() + " within group: " + this.lineExpression);
            }
            int column = this.parseColumn(matcher, this.columnExpression);
            String message = matcher.replaceAll(this.descriptionExpression);
            ResourceInfo resourceInfo = this.getCharStartCharEnd(fileDocument, lineNumber, column);
            this.addMarker(file, message, this.severity, lineNumber, resourceInfo.charStart, resourceInfo.charEnd);
        }
    }

    private void addMarker(IFile file, String message, int severity, int lineNumber, int charStart, int charEnd) {
        if (this.existingMarker(file, message, severity, lineNumber)) {
            return;
        }
        try {
            if (file == null || !file.exists()) {
                return;
            }
            IMarker marker = file.createMarker(this.markerID);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", severity);
            if (lineNumber > 0) {
                marker.setAttribute("lineNumber", lineNumber);
            }
            marker.setAttribute("charStart", charStart);
            marker.setAttribute("charEnd", charEnd);
        }
        catch (CoreException e) {
            Platform.getLog(this.getClass()).error("Cannot create clang format error marker for " + file.getLocation().toOSString(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean existingMarker(IFile file, String message, int severity, int lineNumber) {
        if (file == null) return false;
        if (!file.exists()) return false;
        try {
            String mMessage;
            int mSeverity;
            int mlineNumber;
            IMarker[] markers = file.findMarkers(this.markerID, true, 1);
            List<IMarker> existingMarkers = Arrays.stream(markers).filter(cm -> cm.exists()).toList();
            Iterator<IMarker> iterator = existingMarkers.iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                IMarker m = iterator.next();
                mlineNumber = m.getAttribute("lineNumber", -1);
                mSeverity = m.getAttribute("severity", -1);
                mMessage = (String)m.getAttribute("message");
            } while (mlineNumber != lineNumber || mSeverity != severity || !mMessage.equals(message));
            return true;
        }
        catch (CoreException e) {
            Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private int parseColumn(Matcher matcher, String columnExpression) {
        int column = -1;
        try {
            String columnString = matcher.replaceAll(columnExpression).replace(':', ' ').trim();
            if (!columnString.isBlank()) {
                column = Integer.parseInt(columnString);
            }
        }
        catch (NumberFormatException e) {
            Platform.getLog(this.getClass()).error("Cannot parse column number from pattern: " + this.pattern.pattern() + " within group: " + columnExpression);
        }
        return column;
    }

    ResourceInfo getCharStartCharEnd(IDocument document, int lineNumber, int column) {
        ResourceInfo resourceInfo = new ResourceInfo();
        try {
            int zeroBasedLine = lineNumber > 0 ? lineNumber - 1 : lineNumber;
            int offset = document.getLineOffset(zeroBasedLine);
            resourceInfo.charStart = offset + column - 1;
            resourceInfo.charEnd = this.getLineEnd(document, zeroBasedLine);
        }
        catch (BadLocationException e) {
            Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
            resourceInfo.charStart = -1;
            resourceInfo.charEnd = -1;
        }
        return resourceInfo;
    }

    private int getLineEnd(IDocument document, int line) throws BadLocationException {
        IRegion region = document.getLineInformation(line);
        return region.getOffset() + region.getLength();
    }

    private class ResourceInfo {
        public int charStart = -1;
        public int charEnd = -1;

        private ResourceInfo() {
        }
    }
}

