/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.repositories.ui;

import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.equinox.internal.security.storage.SecurePreferencesRoot;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.commons.repositories.core.SecureCredentialsStore;
import org.eclipse.swt.widgets.Display;

public class UiSecureCredentialsStore
extends SecureCredentialsStore {
    private static AtomicBoolean loggedDeadlockDetectionFailure = new AtomicBoolean();

    public UiSecureCredentialsStore(String id) {
        super(id);
    }

    protected ISecurePreferences getSecurePreferences() {
        boolean acquiredLock = false;
        ILock lock = UiSecureCredentialsStore.getSecurePreferencesRootLock();
        try {
            if (lock != null && lock.getDepth() > 0) {
                this.sleep(200L);
                if (lock.getDepth() > 0 && !(acquiredLock = this.acquire(lock))) {
                    throw new RuntimeException("Aborting request to prevent deadlock accessing secure storage");
                }
            }
            ISecurePreferences iSecurePreferences = super.getSecurePreferences();
            return iSecurePreferences;
        }
        finally {
            if (lock != null && acquiredLock) {
                lock.release();
            }
        }
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.commons.repositories.ui", e.getMessage(), (Throwable)e));
        }
    }

    private boolean acquire(ILock lock) {
        if (Display.getCurrent() != null) {
            try {
                return lock.acquire(1L);
            }
            catch (InterruptedException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.commons.repositories.ui", e.getMessage(), (Throwable)e));
            }
        }
        return false;
    }

    protected static ILock getSecurePreferencesRootLock() {
        try {
            Field lockField = SecurePreferencesRoot.class.getDeclaredField("lock");
            lockField.setAccessible(true);
            return (ILock)lockField.get(null);
        }
        catch (Exception e) {
            if (!loggedDeadlockDetectionFailure.getAndSet(true)) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.commons.repositories.ui", "Deadlock detection failed", (Throwable)e));
            }
            return null;
        }
    }
}

