/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.generators.xml2dtd;

import java.util.Collection;
import java.util.Map;
import java.util.SortedSet;
import org.eclipse.lemminx.extensions.generators.AbstractXML2GrammarGenerator;
import org.eclipse.lemminx.extensions.generators.AttributeDeclaration;
import org.eclipse.lemminx.extensions.generators.Cardinality;
import org.eclipse.lemminx.extensions.generators.ElementDeclaration;
import org.eclipse.lemminx.extensions.generators.Grammar;
import org.eclipse.lemminx.extensions.generators.xml2dtd.DTDGeneratorSettings;
import org.eclipse.lemminx.utils.XMLBuilder;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class XML2DTDGenerator
extends AbstractXML2GrammarGenerator<DTDGeneratorSettings> {
    @Override
    protected void generate(Grammar grammar, DTDGeneratorSettings settings, XMLBuilder dtd, CancelChecker cancelChecker) {
        for (ElementDeclaration elementDecl : grammar.getElements()) {
            cancelChecker.checkCanceled();
            boolean hasCharacterContent = elementDecl.hasCharacterContent();
            dtd.startDTDElementDecl();
            dtd.addParameter(elementDecl.getName());
            Collection<ElementDeclaration> children = elementDecl.getElements();
            if (children.isEmpty()) {
                if (hasCharacterContent) {
                    dtd.addContent(" (#PCDATA)");
                } else {
                    dtd.addContent(" EMPTY");
                }
            } else if (!hasCharacterContent) {
                boolean first;
                boolean sequenced = elementDecl.getChildrenProperties().isSequenced();
                if (sequenced) {
                    dtd.addContent(" (");
                    first = true;
                    for (Map.Entry entry : elementDecl.getChildrenProperties().getCardinalities().entrySet()) {
                        cancelChecker.checkCanceled();
                        if (!first) {
                            dtd.addContent(",");
                        }
                        first = false;
                        dtd.addContent((String)entry.getKey());
                        Cardinality cardinality = (Cardinality)entry.getValue();
                        if (cardinality.getMin() == 0L && cardinality.getMax() == 1L) {
                            dtd.addContent("?");
                            continue;
                        }
                        if (cardinality.getMin() == 0L && cardinality.getMax() > 1L) {
                            dtd.addContent("*");
                            continue;
                        }
                        if (cardinality.getMax() <= 1L) continue;
                        dtd.addContent("+");
                    }
                    dtd.addContent(")");
                } else {
                    dtd.addContent(" (");
                    first = true;
                    for (ElementDeclaration elementDeclaration : children) {
                        cancelChecker.checkCanceled();
                        if (!first) {
                            dtd.addContent("|");
                        }
                        first = false;
                        dtd.addContent(elementDeclaration.getName());
                    }
                    dtd.addContent(")*");
                }
            } else {
                dtd.addContent("(#PCDATA");
                if (hasCharacterContent) {
                    for (ElementDeclaration elementInfo : children) {
                        cancelChecker.checkCanceled();
                        dtd.addContent("|");
                        dtd.addContent(elementInfo.getName());
                    }
                }
                dtd.addContent(")*");
            }
            dtd.closeStartElement();
            Collection<AttributeDeclaration> attributes = elementDecl.getAttributes();
            if (attributes.isEmpty()) continue;
            for (AttributeDeclaration attribute : attributes) {
                cancelChecker.checkCanceled();
                dtd.startDTDAttlistDecl();
                dtd.addParameter(elementDecl.getName());
                boolean bl = attribute.isRequired();
                boolean isID = attribute.isID(settings);
                boolean fixed = attribute.isFixedValue(settings);
                boolean enums = attribute.isEnums(settings);
                String tokentype = attribute.isAllNMTOKENs() ? "NMTOKEN" : "CDATA";
                dtd.addParameter(attribute.getName());
                if (isID) {
                    dtd.addParameter("ID");
                } else if (fixed) {
                    String val = attribute.getValues().first();
                    dtd.addParameter(tokentype);
                    dtd.addParameter("#FIXED");
                    dtd.addParameter("\"" + val + "\"");
                } else if (enums) {
                    dtd.addContent(" (");
                    SortedSet<String> values = attribute.getValues();
                    boolean first = true;
                    for (String value : values) {
                        if (!first) {
                            dtd.addContent("|");
                        }
                        dtd.addContent(value);
                        first = false;
                    }
                    dtd.addContent(")");
                } else {
                    dtd.addParameter(tokentype);
                }
                if (!fixed) {
                    if (bl) {
                        dtd.addParameter("#REQUIRED");
                    } else {
                        dtd.addParameter("#IMPLIED");
                    }
                }
                dtd.closeStartElement();
            }
        }
    }

    @Override
    protected String getFileExtension() {
        return "dtd";
    }

    @Override
    protected boolean isFlat() {
        return true;
    }
}

