/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.model.js.datatypedetect;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.scout.sdk.core.s.model.js.datatypedetect.IPropertyDataTypeOverride;
import org.eclipse.scout.sdk.core.s.model.js.prop.ScoutJsProperty;
import org.eclipse.scout.sdk.core.s.model.js.prop.ScoutJsPropertyType;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;

public class PropertyDataTypeDetector {
    private final List<IPropertyDataTypeOverride> m_overrides;

    public PropertyDataTypeDetector(List<IPropertyDataTypeOverride> overrides) {
        this.m_overrides = overrides;
    }

    public ScoutJsPropertyType detect(ScoutJsProperty property) {
        return this.m_overrides.stream().flatMap(override -> override.getOverrideFor(property).stream()).findFirst().orElseGet(() -> new ScoutJsPropertyType(property.field().dataType().orElse(null), property));
    }

    public void markUsed(String propertyName) {
        this.m_overrides.forEach(o -> o.markUsed(propertyName));
    }

    public Map<String, IDataType> unused() {
        return this.m_overrides.stream().flatMap(o -> o.unused().entrySet().stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a));
    }
}

