/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.VectorFieldFunction;
import org.apache.lucene.search.DocIdSetIterator;

public class FloatKnnVectorFieldSource
extends ValueSource {
    private final String fieldName;

    public FloatKnnVectorFieldSource(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        LeafReader reader = readerContext.reader();
        final FloatVectorValues vectorValues = reader.getFloatVectorValues(this.fieldName);
        if (vectorValues == null) {
            VectorFieldFunction.checkField(reader, this.fieldName, VectorEncoding.FLOAT32);
            return new VectorFieldFunction(this, this){
                private final DocIdSetIterator empty = DocIdSetIterator.empty();

                @Override
                public float[] floatVectorVal(int doc) throws IOException {
                    return null;
                }

                @Override
                protected DocIdSetIterator getVectorIterator() {
                    return this.empty;
                }
            };
        }
        return new VectorFieldFunction(this, this){
            KnnVectorValues.DocIndexIterator iterator;
            {
                super(valueSource);
                this.iterator = vectorValues.iterator();
            }

            @Override
            public float[] floatVectorVal(int doc) throws IOException {
                if (this.exists(doc)) {
                    return vectorValues.vectorValue(this.iterator.index());
                }
                return null;
            }

            @Override
            protected DocIdSetIterator getVectorIterator() {
                return this.iterator;
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatKnnVectorFieldSource other = (FloatKnnVectorFieldSource)o;
        return Objects.equals(this.fieldName, other.fieldName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClass().hashCode(), this.fieldName);
    }

    @Override
    public String description() {
        return "FloatKnnVectorFieldSource(" + this.fieldName + ")";
    }
}

