/**
 * Copyright (c) 2017, 2020 Kichwa Coders Ltd. and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j.debug;

import org.eclipse.lsp4j.jsonrpc.ProtocolSince;
import org.eclipse.lsp4j.jsonrpc.util.Preconditions;
import org.eclipse.lsp4j.jsonrpc.util.ToStringBuilder;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

/**
 * Response to 'locations' request.
 */
@ProtocolSince("1.68")
@SuppressWarnings("all")
public class LocationsResponse {
  /**
   * The source containing the location; either `source.path` or
   * `source.sourceReference` must be specified.
   */
  @NonNull
  private Source source;

  /**
   * The line number of the location. The client capability `linesStartAt1`
   * determines whether it is 0- or 1-based.
   */
  @NonNull
  private Integer line;

  /**
   * Position of the location within the `line`. It is measured in UTF-16 code
   * units and the client capability `columnsStartAt1` determines whether it
   * is 0- or 1-based. If no column is given, the first position in the start
   * line is assumed.
   * <p>
   * This is an optional property.
   */
  private Integer column;

  /**
   * End line of the location, present if the location refers to a range.  The
   * client capability `linesStartAt1` determines whether it is 0- or 1-based.
   * <p>
   * This is an optional property.
   */
  private Integer endLine;

  /**
   * End position of the location within `endLine`, present if the location
   * refers to a range. It is measured in UTF-16 code units and the client
   * capability `columnsStartAt1` determines whether it is 0- or 1-based.
   * <p>
   * This is an optional property.
   */
  private Integer endColumn;

  /**
   * The source containing the location; either `source.path` or
   * `source.sourceReference` must be specified.
   */
  @NonNull
  public Source getSource() {
    return this.source;
  }

  /**
   * The source containing the location; either `source.path` or
   * `source.sourceReference` must be specified.
   */
  public void setSource(@NonNull final Source source) {
    this.source = Preconditions.checkNotNull(source, "source");
  }

  /**
   * The line number of the location. The client capability `linesStartAt1`
   * determines whether it is 0- or 1-based.
   */
  @NonNull
  public Integer getLine() {
    return this.line;
  }

  /**
   * The line number of the location. The client capability `linesStartAt1`
   * determines whether it is 0- or 1-based.
   */
  public void setLine(@NonNull final Integer line) {
    this.line = Preconditions.checkNotNull(line, "line");
  }

  /**
   * Position of the location within the `line`. It is measured in UTF-16 code
   * units and the client capability `columnsStartAt1` determines whether it
   * is 0- or 1-based. If no column is given, the first position in the start
   * line is assumed.
   * <p>
   * This is an optional property.
   */
  public Integer getColumn() {
    return this.column;
  }

  /**
   * Position of the location within the `line`. It is measured in UTF-16 code
   * units and the client capability `columnsStartAt1` determines whether it
   * is 0- or 1-based. If no column is given, the first position in the start
   * line is assumed.
   * <p>
   * This is an optional property.
   */
  public void setColumn(final Integer column) {
    this.column = column;
  }

  /**
   * End line of the location, present if the location refers to a range.  The
   * client capability `linesStartAt1` determines whether it is 0- or 1-based.
   * <p>
   * This is an optional property.
   */
  public Integer getEndLine() {
    return this.endLine;
  }

  /**
   * End line of the location, present if the location refers to a range.  The
   * client capability `linesStartAt1` determines whether it is 0- or 1-based.
   * <p>
   * This is an optional property.
   */
  public void setEndLine(final Integer endLine) {
    this.endLine = endLine;
  }

  /**
   * End position of the location within `endLine`, present if the location
   * refers to a range. It is measured in UTF-16 code units and the client
   * capability `columnsStartAt1` determines whether it is 0- or 1-based.
   * <p>
   * This is an optional property.
   */
  public Integer getEndColumn() {
    return this.endColumn;
  }

  /**
   * End position of the location within `endLine`, present if the location
   * refers to a range. It is measured in UTF-16 code units and the client
   * capability `columnsStartAt1` determines whether it is 0- or 1-based.
   * <p>
   * This is an optional property.
   */
  public void setEndColumn(final Integer endColumn) {
    this.endColumn = endColumn;
  }

  @Override
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("source", this.source);
    b.add("line", this.line);
    b.add("column", this.column);
    b.add("endLine", this.endLine);
    b.add("endColumn", this.endColumn);
    return b.toString();
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    LocationsResponse other = (LocationsResponse) obj;
    if (this.source == null) {
      if (other.source != null)
        return false;
    } else if (!this.source.equals(other.source))
      return false;
    if (this.line == null) {
      if (other.line != null)
        return false;
    } else if (!this.line.equals(other.line))
      return false;
    if (this.column == null) {
      if (other.column != null)
        return false;
    } else if (!this.column.equals(other.column))
      return false;
    if (this.endLine == null) {
      if (other.endLine != null)
        return false;
    } else if (!this.endLine.equals(other.endLine))
      return false;
    if (this.endColumn == null) {
      if (other.endColumn != null)
        return false;
    } else if (!this.endColumn.equals(other.endColumn))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.source== null) ? 0 : this.source.hashCode());
    result = prime * result + ((this.line== null) ? 0 : this.line.hashCode());
    result = prime * result + ((this.column== null) ? 0 : this.column.hashCode());
    result = prime * result + ((this.endLine== null) ? 0 : this.endLine.hashCode());
    return prime * result + ((this.endColumn== null) ? 0 : this.endColumn.hashCode());
  }
}
