/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.remote.tabs;

import org.eclipse.cdt.dsf.gdb.internal.ui.launching.CMainTab;
import org.eclipse.cdt.internal.launch.remote.Activator;
import org.eclipse.cdt.internal.launch.remote.Messages;
import org.eclipse.cdt.launch.remote.IRemoteConnectionConfigurationConstants;
import org.eclipse.cdt.launch.remote.RemoteHelper;
import org.eclipse.cdt.launch.remote.RemoteUIHelper;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.ui.IRemoteUIConnectionService;
import org.eclipse.remote.ui.dialogs.RemoteResourceBrowser;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class RemoteCDSFMainTab
extends CMainTab {
    private static final String REMOTE_PROG_LABEL_TEXT = Messages.RemoteCMainTab_Program;
    private static final String SKIP_DOWNLOAD_BUTTON_TEXT = Messages.RemoteCMainTab_SkipDownload;
    private static final String REMOTE_PROG_TEXT_ERROR = Messages.RemoteCMainTab_ErrorNoProgram;
    private static final String REMOTE_PROG_NOT_ABSOLUTE = Messages.RemoteCMainTab_ErrorRemoteProgNotAbsolute;
    private static final String CONNECTION_TEXT_ERROR = Messages.RemoteCMainTab_ErrorNoConnection;
    private static final String PRE_RUN_LABEL_TEXT = Messages.RemoteCMainTab_Prerun;
    private static final String REMOTE_PATH_DEFAULT = "";
    private static final boolean SKIP_DOWNLOAD_TO_REMOTE_DEFAULT = false;
    protected Button newRemoteConnectionButton;
    protected Button editRemoteConnectionButton;
    protected Button remoteConnectionPropertiesButton;
    protected Button remoteBrowseButton;
    protected Label connectionLabel;
    protected Combo connectionCombo;
    protected Label remoteProgLabel;
    protected Text remoteProgText;
    protected Button skipDownloadButton;
    protected Button useLocalPathButton;
    private Text preRunText;
    private Label preRunLabel;
    private boolean isInitializing = false;

    public RemoteCDSFMainTab() {
        super(8);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite comp = (Composite)this.getControl();
        this.createVerticalSpacer(comp, 1);
        this.createRemoteConnectionGroup(comp, 4);
        this.createVerticalSpacer(comp, 1);
        this.createTargetExePathGroup(comp);
        this.createDownloadOption(comp);
        this.fProgText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                RemoteCDSFMainTab.this.setLocalPathForRemotePath();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.cdt.launch.remote.launchgroup");
    }

    public boolean isValid(ILaunchConfiguration config) {
        if (!super.isValid(config)) {
            return false;
        }
        this.setErrorMessage(null);
        int currentSelection = this.connectionCombo.getSelectionIndex();
        if (currentSelection < 0) {
            this.setErrorMessage(CONNECTION_TEXT_ERROR);
            return false;
        }
        String connection_name = this.connectionCombo.getItem(currentSelection);
        if (connection_name.isEmpty()) {
            this.setErrorMessage(CONNECTION_TEXT_ERROR);
            return false;
        }
        String remoteProgName = this.remoteProgText.getText().trim();
        if (remoteProgName.isEmpty()) {
            this.setErrorMessage(REMOTE_PROG_TEXT_ERROR);
            return false;
        }
        Path remoteProgPath = Path.forPosix((String)remoteProgName);
        if (!remoteProgPath.isAbsolute()) {
            this.setErrorMessage(REMOTE_PROG_NOT_ABSOLUTE);
            return false;
        }
        return true;
    }

    protected void createRemoteConnectionGroup(Composite parent, int colSpan) {
        Composite projComp = new Composite(parent, 0);
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 5;
        projLayout.marginHeight = 0;
        projLayout.marginWidth = 0;
        projComp.setLayout((Layout)projLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        projComp.setLayoutData((Object)gd);
        this.connectionLabel = new Label(projComp, 0);
        this.connectionLabel.setText(Messages.RemoteCMainTab_Connection);
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.connectionLabel.setLayoutData((Object)gd);
        this.connectionCombo = new Combo(projComp, 12);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.connectionCombo.setLayoutData((Object)gd);
        this.connectionCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RemoteCDSFMainTab.this.useDefaultsFromConnection();
                RemoteCDSFMainTab.this.updateConnectionButtons();
                RemoteCDSFMainTab.this.setDirty(true);
                RemoteCDSFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.newRemoteConnectionButton = this.createPushButton(projComp, Messages.RemoteCMainTab_New, null);
        this.newRemoteConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                RemoteCDSFMainTab.this.handleNewRemoteConnectionSelected();
                RemoteCDSFMainTab.this.updateLaunchConfigurationDialog();
                RemoteCDSFMainTab.this.updateConnectionPulldown();
            }
        });
        this.editRemoteConnectionButton = this.createPushButton(projComp, Messages.RemoteCMainTab_Edit, null);
        this.editRemoteConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                RemoteCDSFMainTab.this.handleEditRemoteConnectionSelected();
            }
        });
        this.remoteConnectionPropertiesButton = this.createPushButton(projComp, Messages.RemoteCMainTab_Properties, null);
        this.remoteConnectionPropertiesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                RemoteCDSFMainTab.this.handleRemoteConnectionPropertiesSelected();
            }
        });
        this.updateConnectionPulldown();
    }

    protected void createTargetExePathGroup(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 2;
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainComp.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        mainComp.setLayoutData((Object)gd);
        this.remoteProgLabel = new Label(mainComp, 0);
        this.remoteProgLabel.setText(REMOTE_PROG_LABEL_TEXT);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.remoteProgLabel.setLayoutData((Object)gd);
        this.remoteProgText = new Text(mainComp, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.remoteProgText.setLayoutData((Object)gd);
        this.remoteProgText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                RemoteCDSFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.remoteBrowseButton = this.createPushButton(mainComp, Messages.RemoteCMainTab_Remote_Path_Browse_Button, null);
        this.remoteBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                RemoteCDSFMainTab.this.handleRemoteBrowseSelected();
                RemoteCDSFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.preRunLabel = new Label(mainComp, 0);
        this.preRunLabel.setText(PRE_RUN_LABEL_TEXT);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.preRunLabel.setLayoutData((Object)gd);
        this.preRunText = new Text(mainComp, 2050);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.preRunText.setLayoutData((Object)gd);
        this.preRunText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                RemoteCDSFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void createDownloadOption(Composite parent) {
        Composite mainComp = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        mainComp.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        mainComp.setLayoutData((Object)gd);
        this.skipDownloadButton = this.createCheckButton(mainComp, SKIP_DOWNLOAD_BUTTON_TEXT);
        this.skipDownloadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                RemoteCDSFMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.skipDownloadButton.setEnabled(true);
    }

    protected void handleNewRemoteConnectionSelected() {
        RemoteUIHelper.newConnectionDialog(this.getControl().getShell());
    }

    protected void handleEditRemoteConnectionSelected() {
        RemoteUIHelper.editConnectionDialog(this.getCurrentConnection(), this.getControl().getShell());
    }

    protected IRemoteConnection getCurrentConnection() {
        int currentSelection = this.connectionCombo.getSelectionIndex();
        String remoteConnection = currentSelection >= 0 ? this.connectionCombo.getItem(currentSelection) : null;
        return RemoteHelper.getRemoteConnectionByName(remoteConnection);
    }

    protected void handleRemoteBrowseSelected() {
        IRemoteConnection currentConnectionSelected = this.getCurrentConnection();
        if (currentConnectionSelected != null && !currentConnectionSelected.isOpen() && currentConnectionSelected.getConnectionType().hasService(IRemoteUIConnectionService.class)) {
            IRemoteUIConnectionService uiConnService = (IRemoteUIConnectionService)currentConnectionSelected.getConnectionType().getService(IRemoteUIConnectionService.class);
            uiConnService.openConnectionWithProgress(this.getShell(), (IRunnableContext)new ProgressMonitorDialog(this.getShell()), currentConnectionSelected);
            if (!currentConnectionSelected.isOpen()) {
                return;
            }
        }
        RemoteResourceBrowser b = new RemoteResourceBrowser(this.getControl().getShell(), 0);
        b.setConnection(currentConnectionSelected);
        b.setTitle(Messages.RemoteCMainTab_Remote_Path_Browse_Button_Title);
        int returnCode = b.open();
        if (returnCode == 1) {
            return;
        }
        IFileStore selectedFile = b.getResource();
        if (selectedFile != null) {
            Path appPath;
            String lastSegment;
            String absPath = selectedFile.toURI().getPath();
            if (selectedFile.fetchInfo().isDirectory() && (lastSegment = (appPath = new Path(this.fProgText.getText().trim())).lastSegment()) != null && lastSegment.trim().length() > 0) {
                IPath remotePath = new Path(absPath).append(lastSegment.trim());
                absPath = remotePath.toPortableString();
            }
            this.remoteProgText.setText(absPath);
        }
    }

    protected void handleRemoteConnectionPropertiesSelected() {
        IRemoteConnection currentConnectionSelected = this.getCurrentConnection();
        class RemoteConnectionPropertyDialog
        extends Dialog {
            private IRemoteConnection fHost;
            boolean fbLocalHost;
            private Button fSkipDownloadBtn;
            private Text fWSRoot;
            private String fDialogTitle;

            public RemoteConnectionPropertyDialog(Shell parentShell, String dialogTitle, IRemoteConnection host) {
                super(parentShell);
                this.fDialogTitle = dialogTitle;
                this.fHost = host;
                IRemoteServicesManager remoteServicesManager = Activator.getService(IRemoteServicesManager.class);
                this.fbLocalHost = this.fHost.getConnectionType() == remoteServicesManager.getLocalConnectionType();
            }

            protected void configureShell(Shell shell) {
                super.configureShell(shell);
                shell.setText(this.fDialogTitle);
            }

            protected Control createDialogArea(Composite parent) {
                Composite composite = (Composite)super.createDialogArea(parent);
                Label label = new Label(composite, 64);
                label.setText(Messages.RemoteCMainTab_Properties_Location);
                GridData data = new GridData(1796);
                data.widthHint = this.convertHorizontalDLUsToPixels(300);
                label.setLayoutData((Object)data);
                label.setFont(parent.getFont());
                this.fWSRoot = new Text(composite, 2052);
                this.fWSRoot.setLayoutData((Object)new GridData(768));
                this.fSkipDownloadBtn = new Button(composite, 32);
                this.fSkipDownloadBtn.setText(Messages.RemoteCMainTab_Properties_Skip_default);
                if (!this.fbLocalHost) {
                    String value = RemoteUIHelper.getConnectionProperty(this.fHost, "remoteWsRoot");
                    if (!value.isEmpty()) {
                        this.fWSRoot.setText(value);
                    }
                    this.fSkipDownloadBtn.setSelection(Boolean.valueOf(RemoteUIHelper.getConnectionProperty(this.fHost, "defaultSkipDownload")).booleanValue());
                } else {
                    this.fSkipDownloadBtn.setEnabled(false);
                    this.fWSRoot.setEnabled(false);
                }
                RemoteConnectionPropertyDialog.applyDialogFont((Control)composite);
                return composite;
            }

            protected void buttonPressed(int buttonId) {
                if (!this.fbLocalHost && buttonId == 0) {
                    RemoteUIHelper.setConnectionProperty(this.fHost, "remoteWsRoot", this.fWSRoot.getText());
                    RemoteUIHelper.setConnectionProperty(this.fHost, "defaultSkipDownload", Boolean.toString(this.fSkipDownloadBtn.getSelection()));
                }
                super.buttonPressed(buttonId);
            }
        }
        RemoteConnectionPropertyDialog dlg = new RemoteConnectionPropertyDialog(this.getControl().getShell(), Messages.RemoteCMainTab_Properties_title, currentConnectionSelected);
        dlg.setBlockOnOpen(true);
        dlg.open();
    }

    protected void updateConnectionPulldown() {
        this.connectionCombo.removeAll();
        IRemoteConnection[] connections = RemoteHelper.getSuitableConnections();
        int i = 0;
        while (i < connections.length) {
            this.connectionCombo.add(connections[i].getName());
            ++i;
        }
        if (connections.length > 0) {
            this.connectionCombo.select(connections.length - 1);
        }
        this.updateConnectionButtons();
    }

    private void updateConnectionButtons() {
        if (this.remoteConnectionPropertiesButton == null || this.remoteConnectionPropertiesButton.isDisposed()) {
            return;
        }
        if (this.editRemoteConnectionButton == null || this.editRemoteConnectionButton.isDisposed()) {
            return;
        }
        boolean bEnable = false;
        IRemoteConnection currentConnectionSelected = this.getCurrentConnection();
        if (currentConnectionSelected != null && currentConnectionSelected.getConnectionType().canEdit()) {
            bEnable = true;
        }
        this.remoteConnectionPropertiesButton.setEnabled(bEnable);
        this.editRemoteConnectionButton.setEnabled(bEnable);
    }

    protected void updateTargetProgFromConfig(ILaunchConfiguration config) {
        String targetPath = null;
        try {
            targetPath = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_PATH, REMOTE_PATH_DEFAULT);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.remoteProgText.setText(targetPath);
        String prelaunchCmd = null;
        try {
            prelaunchCmd = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_PRERUN_COMMANDS, REMOTE_PATH_DEFAULT);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.preRunText.setText(prelaunchCmd);
    }

    protected void updateSkipDownloadFromConfig(ILaunchConfiguration config) {
        boolean downloadToTarget = true;
        try {
            downloadToTarget = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_SKIP_DOWNLOAD_TO_TARGET, this.getDefaultSkipDownload());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.skipDownloadButton.setSelection(downloadToTarget);
    }

    private void setLocalPathForRemotePath() {
        String programName = this.fProgText.getText().trim();
        boolean bUpdateRemote = false;
        String remoteName = this.remoteProgText.getText().trim();
        String remoteWsRoot = this.getRemoteWSRoot();
        if (remoteName.length() == 0) {
            bUpdateRemote = true;
        } else if (remoteWsRoot.length() != 0) {
            bUpdateRemote = remoteName.equals(remoteWsRoot);
        }
        if (programName.length() != 0 && bUpdateRemote) {
            Path exePath = new Path(programName);
            if (!exePath.isAbsolute()) {
                IProject project = this.getCProject().getProject();
                exePath = project.getFile(programName).getLocation();
                IPath wsRoot = project.getWorkspace().getRoot().getLocation();
                exePath = this.makeRelativeToWSRootLocation((IPath)exePath, remoteWsRoot, wsRoot);
            }
            String path = exePath.toString();
            this.remoteProgText.setText(path);
        }
    }

    private void useDefaultsFromConnection() {
        if (this.isInitializing) {
            return;
        }
        if (this.remoteProgText != null && !this.remoteProgText.isDisposed()) {
            String remoteName = this.remoteProgText.getText().trim();
            String remoteWsRoot = this.getRemoteWSRoot();
            if (remoteName.length() == 0) {
                this.remoteProgText.setText(remoteWsRoot);
            } else {
                IPath wsRoot = Platform.getLocation();
                IPath remotePath = this.makeRelativeToWSRootLocation((IPath)new Path(remoteName), remoteWsRoot, wsRoot);
                this.remoteProgText.setText(remotePath.toString());
            }
        }
        if (this.skipDownloadButton != null && !this.skipDownloadButton.isDisposed()) {
            this.skipDownloadButton.setSelection(this.getDefaultSkipDownload());
            if (RemoteHelper.getFileSubsystem(this.getCurrentConnection()) == null) {
                this.skipDownloadButton.setEnabled(false);
            } else {
                this.skipDownloadButton.setEnabled(true);
            }
        }
        if (this.remoteBrowseButton != null && !this.remoteBrowseButton.isDisposed()) {
            if (RemoteHelper.getFileSubsystem(this.getCurrentConnection()) == null) {
                this.remoteBrowseButton.setEnabled(false);
            } else {
                this.remoteBrowseButton.setEnabled(true);
            }
        }
    }

    private IPath makeRelativeToWSRootLocation(IPath exePath, String remoteWsRoot, IPath wsRoot) {
        if (remoteWsRoot.length() != 0 && wsRoot.isPrefixOf(exePath)) {
            return new Path(remoteWsRoot).append(exePath.removeFirstSegments(wsRoot.segmentCount()).setDevice(null));
        }
        return exePath;
    }

    private String getRemoteWSRoot() {
        String value;
        IRemoteConnection host = this.getCurrentConnection();
        if (host != null && !(value = RemoteUIHelper.getConnectionProperty(host, "remoteWsRoot")).isEmpty()) {
            return value;
        }
        return REMOTE_PATH_DEFAULT;
    }

    private boolean getDefaultSkipDownload() {
        IRemoteConnection host = this.getCurrentConnection();
        if (host != null) {
            if (RemoteHelper.getFileSubsystem(host) == null) {
                return true;
            }
            String value = RemoteUIHelper.getConnectionProperty(host, "defaultSkipDownload");
            if (!value.isEmpty()) {
                return Boolean.valueOf(value);
            }
        }
        return false;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.isInitializing = true;
        String remoteConnection = null;
        try {
            remoteConnection = config.getAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_CONNECTION, REMOTE_PATH_DEFAULT);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        String[] items = this.connectionCombo.getItems();
        int i = 0;
        i = 0;
        while (i < items.length) {
            if (items[i].equals(remoteConnection)) break;
            ++i;
        }
        if (i < items.length) {
            this.connectionCombo.select(i);
        } else if (items.length > 0) {
            this.connectionCombo.select(0);
        }
        super.initializeFrom(config);
        this.updateTargetProgFromConfig(config);
        this.updateSkipDownloadFromConfig(config);
        this.updateConnectionButtons();
        this.isInitializing = false;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        int currentSelection = this.connectionCombo.getSelectionIndex();
        config.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_CONNECTION, currentSelection >= 0 ? this.connectionCombo.getItem(currentSelection) : null);
        config.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_PATH, this.remoteProgText.getText());
        config.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_SKIP_DOWNLOAD_TO_TARGET, this.skipDownloadButton.getSelection());
        config.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_PRERUN_COMMANDS, this.preRunText.getText());
        super.performApply(config);
    }

    public String getId() {
        return "org.eclipse.cdt.launch.remote.dsf.mainTab";
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        super.setDefaults(config);
        config.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_CONNECTION, REMOTE_PATH_DEFAULT);
        config.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_REMOTE_PATH, REMOTE_PATH_DEFAULT);
        config.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_SKIP_DOWNLOAD_TO_TARGET, false);
        config.setAttribute(IRemoteConnectionConfigurationConstants.ATTR_PRERUN_COMMANDS, REMOTE_PATH_DEFAULT);
    }
}

