/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.utils;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithoutAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.model.type.impl.PieSeriesImpl;

public class ChartUtil {
    public static final Chart createPieChart(String[] labels, double[] values) {
        if (labels == null || labels.length <= 0) {
            return null;
        }
        ChartWithoutAxes cwoaPie = ChartWithoutAxesImpl.create();
        cwoaPie.setSeriesThickness(8.0);
        cwoaPie.setDimension(ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL);
        cwoaPie.getBlock().setBackground((Fill)ColorDefinitionImpl.TRANSPARENT());
        Plot p = cwoaPie.getPlot();
        p.getClientArea().setBackground((Fill)ColorDefinitionImpl.TRANSPARENT());
        p.getClientArea().getOutline().setVisible(false);
        p.getOutline().setVisible(false);
        Legend lg = cwoaPie.getLegend();
        lg.setPosition(Position.BELOW_LITERAL);
        lg.getText().getFont().setSize(10.0f);
        lg.setBackground(null);
        lg.getOutline().setVisible(false);
        cwoaPie.getTitle().setVisible(false);
        TextDataSet categoryValues = TextDataSetImpl.create((Object)labels);
        NumberDataSet seriesValues = NumberDataSetImpl.create((Object)values);
        Series categorySeries = SeriesImpl.create();
        categorySeries.setDataSet((DataSet)categoryValues);
        SeriesDefinition categorySeriesDefinition = SeriesDefinitionImpl.create();
        cwoaPie.getSeriesDefinitions().add((Object)categorySeriesDefinition);
        categorySeriesDefinition.getSeriesPalette().update(0);
        categorySeriesDefinition.getSeries().add((Object)categorySeries);
        PieSeries pieSeries = (PieSeries)PieSeriesImpl.create();
        pieSeries.setDataSet((DataSet)seriesValues);
        pieSeries.setExplosion(15);
        pieSeries.setRatio(1.0);
        pieSeries.getLabel().setVisible(false);
        pieSeries.getTitle().setVisible(false);
        SeriesDefinition pieSeriesDefinition = SeriesDefinitionImpl.create();
        pieSeriesDefinition.getQuery().setDefinition("");
        categorySeriesDefinition.getSeriesDefinitions().add((Object)pieSeriesDefinition);
        pieSeriesDefinition.getSeries().add((Object)pieSeries);
        return cwoaPie;
    }
}

