/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import org.eclipse.pde.internal.core.isite.ISiteCategoryDefinition;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDEDetailsSections;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDEMasterDetailsBlock;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.site.CategoryDetailsSection;
import org.eclipse.pde.internal.ui.editor.site.CategorySection;
import org.eclipse.pde.internal.ui.editor.site.FeatureDetailsSection;
import org.eclipse.pde.internal.ui.editor.site.PortabilitySection;
import org.eclipse.pde.internal.ui.editor.site.SiteFeatureAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class FeaturesPage
extends PDEFormPage {
    public static final String PAGE_ID = "features";
    private CategorySection fCategorySection;
    private final SiteFeaturesBlock fBlock = new SiteFeaturesBlock();

    public FeaturesPage(PDEFormEditor editor) {
        super(editor, PAGE_ID, PDEUIMessages.FeaturesPage_title);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        form.setText(PDEUIMessages.FeaturesPage_header);
        form.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_SITE_XML_OBJ));
        this.fBlock.createContent(managedForm);
        this.fCategorySection.fireSelection();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), "org.eclipse.pde.doc.user.manifest_site_features");
    }

    private IDetailsPage createFeatureDetails() {
        return new PDEDetailsSections(){

            @Override
            protected PDESection[] createSections(PDEFormPage page, Composite parent) {
                return new PDESection[]{new FeatureDetailsSection(this.getPage(), parent), new PortabilitySection(this.getPage(), parent)};
            }

            @Override
            public String getContextId() {
                return "site-context";
            }
        };
    }

    private IDetailsPage createCategoryDetails() {
        return new PDEDetailsSections(){

            @Override
            protected PDESection[] createSections(PDEFormPage page, Composite parent) {
                return new PDESection[]{new CategoryDetailsSection(this.getPage(), parent)};
            }

            @Override
            public String getContextId() {
                return "site-context";
            }
        };
    }

    @Override
    protected String getHelpResource() {
        return "org.eclipse.pde.doc.user.manifest_site_features";
    }

    public class SiteFeaturesBlock
    extends PDEMasterDetailsBlock {
        public SiteFeaturesBlock() {
            super(FeaturesPage.this);
        }

        @Override
        protected PDESection createMasterSection(IManagedForm managedForm, Composite parent) {
            FeaturesPage.this.fCategorySection = new CategorySection(this.getPage(), parent);
            return FeaturesPage.this.fCategorySection;
        }

        protected void registerPages(DetailsPart detailsPart) {
            detailsPart.setPageProvider(new IDetailsPageProvider(){

                public Object getPageKey(Object object) {
                    if (object instanceof SiteFeatureAdapter) {
                        return SiteFeatureAdapter.class;
                    }
                    if (object instanceof ISiteCategoryDefinition) {
                        return ISiteCategoryDefinition.class;
                    }
                    return object.getClass();
                }

                public IDetailsPage getPage(Object key) {
                    if (key.equals(SiteFeatureAdapter.class)) {
                        return FeaturesPage.this.createFeatureDetails();
                    }
                    if (key.equals(ISiteCategoryDefinition.class)) {
                        return FeaturesPage.this.createCategoryDetails();
                    }
                    return null;
                }
            });
        }
    }
}

