/**
 * Copyright (c) 2017, 2020 Kichwa Coders Ltd. and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j.debug;

import org.eclipse.lsp4j.jsonrpc.util.ToStringBuilder;

/**
 * Properties of a breakpoint location returned from the 'breakpointLocations' request.
 */
@SuppressWarnings("all")
public class BreakpointLocation {
  /**
   * Start line of breakpoint location.
   */
  private int line;

  /**
   * The start position of a breakpoint location. Position is measured in UTF-16 code units and
   * the client capability {@link InitializeRequestArguments#getColumnsStartAt1} determines
   * whether it is 0- or 1-based.
   * <p>
   * This is an optional property.
   */
  private Integer column;

  /**
   * The end line of breakpoint location if the location covers a range.
   * <p>
   * This is an optional property.
   */
  private Integer endLine;

  /**
   * The end position of a breakpoint location (if the location covers a range).
   * Position is measured in UTF-16 code units and the client capability
   * {@link InitializeRequestArguments#getColumnsStartAt1} determines whether it is 0- or 1-based.
   * <p>
   * This is an optional property.
   */
  private Integer endColumn;

  /**
   * Start line of breakpoint location.
   */
  public int getLine() {
    return this.line;
  }

  /**
   * Start line of breakpoint location.
   */
  public void setLine(final int line) {
    this.line = line;
  }

  /**
   * The start position of a breakpoint location. Position is measured in UTF-16 code units and
   * the client capability {@link InitializeRequestArguments#getColumnsStartAt1} determines
   * whether it is 0- or 1-based.
   * <p>
   * This is an optional property.
   */
  public Integer getColumn() {
    return this.column;
  }

  /**
   * The start position of a breakpoint location. Position is measured in UTF-16 code units and
   * the client capability {@link InitializeRequestArguments#getColumnsStartAt1} determines
   * whether it is 0- or 1-based.
   * <p>
   * This is an optional property.
   */
  public void setColumn(final Integer column) {
    this.column = column;
  }

  /**
   * The end line of breakpoint location if the location covers a range.
   * <p>
   * This is an optional property.
   */
  public Integer getEndLine() {
    return this.endLine;
  }

  /**
   * The end line of breakpoint location if the location covers a range.
   * <p>
   * This is an optional property.
   */
  public void setEndLine(final Integer endLine) {
    this.endLine = endLine;
  }

  /**
   * The end position of a breakpoint location (if the location covers a range).
   * Position is measured in UTF-16 code units and the client capability
   * {@link InitializeRequestArguments#getColumnsStartAt1} determines whether it is 0- or 1-based.
   * <p>
   * This is an optional property.
   */
  public Integer getEndColumn() {
    return this.endColumn;
  }

  /**
   * The end position of a breakpoint location (if the location covers a range).
   * Position is measured in UTF-16 code units and the client capability
   * {@link InitializeRequestArguments#getColumnsStartAt1} determines whether it is 0- or 1-based.
   * <p>
   * This is an optional property.
   */
  public void setEndColumn(final Integer endColumn) {
    this.endColumn = endColumn;
  }

  @Override
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("line", this.line);
    b.add("column", this.column);
    b.add("endLine", this.endLine);
    b.add("endColumn", this.endColumn);
    return b.toString();
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    BreakpointLocation other = (BreakpointLocation) obj;
    if (other.line != this.line)
      return false;
    if (this.column == null) {
      if (other.column != null)
        return false;
    } else if (!this.column.equals(other.column))
      return false;
    if (this.endLine == null) {
      if (other.endLine != null)
        return false;
    } else if (!this.endLine.equals(other.endLine))
      return false;
    if (this.endColumn == null) {
      if (other.endColumn != null)
        return false;
    } else if (!this.endColumn.equals(other.endColumn))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + this.line;
    result = prime * result + ((this.column== null) ? 0 : this.column.hashCode());
    result = prime * result + ((this.endLine== null) ? 0 : this.endLine.hashCode());
    return prime * result + ((this.endColumn== null) ? 0 : this.endColumn.hashCode());
  }
}
