/**
 * Copyright (c) 2016-2018 TypeFox and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j;

import org.eclipse.lsp4j.jsonrpc.ProtocolDraft;
import org.eclipse.lsp4j.jsonrpc.ProtocolSince;
import org.eclipse.lsp4j.jsonrpc.util.ToStringBuilder;

/**
 * Additional data about a workspace edit.
 */
@ProtocolDraft
@ProtocolSince("3.18.0")
@SuppressWarnings("all")
public class WorkspaceEditMetadata {
  /**
   * Signal to the editor that this edit is a refactoring.
   */
  private Boolean isRefactoring;

  public WorkspaceEditMetadata() {
  }

  /**
   * Signal to the editor that this edit is a refactoring.
   */
  public Boolean getIsRefactoring() {
    return this.isRefactoring;
  }

  /**
   * Signal to the editor that this edit is a refactoring.
   */
  public void setIsRefactoring(final Boolean isRefactoring) {
    this.isRefactoring = isRefactoring;
  }

  @Override
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("isRefactoring", this.isRefactoring);
    return b.toString();
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    WorkspaceEditMetadata other = (WorkspaceEditMetadata) obj;
    if (this.isRefactoring == null) {
      if (other.isRefactoring != null)
        return false;
    } else if (!this.isRefactoring.equals(other.isRefactoring))
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    return 31 * 1 + ((this.isRefactoring== null) ? 0 : this.isRefactoring.hashCode());
  }
}
