/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.index.ui;

import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.mylyn.internal.tasks.core.IRepositoryModelListener;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.index.core.TaskListIndex;
import org.eclipse.mylyn.internal.tasks.index.ui.AbstractIndexReference;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;

public class IndexReference
extends AbstractIndexReference {
    private static TaskListIndex theIndex;
    private static AtomicInteger referenceCount;
    private static IRepositoryModelListener listener;
    private TaskListIndex index;

    static {
        referenceCount = new AtomicInteger();
        listener = () -> {
            Class<IndexReference> clazz = IndexReference.class;
            synchronized (IndexReference.class) {
                if (theIndex != null) {
                    theIndex.setLocation(IndexReference.getDefaultIndexLocation());
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        };
    }

    static File getDefaultIndexLocation() {
        return new File(TasksUiPlugin.getDefault().getDataDirectory(), ".taskListIndex");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskListIndex index() {
        Class<IndexReference> clazz = IndexReference.class;
        synchronized (IndexReference.class) {
            if (this.index == null) {
                if (theIndex == null && TasksUiPlugin.getTaskDataManager() != null) {
                    TaskRepositoryManager repositoryManager = TasksUiPlugin.getRepositoryManager();
                    theIndex = new TaskListIndex(TasksUiPlugin.getTaskList(), TasksUiPlugin.getTaskDataManager(), (IRepositoryManager)repositoryManager, IndexReference.getDefaultIndexLocation());
                    TasksUiPlugin.getDefault().addModelListener(listener);
                }
                this.index = theIndex;
                referenceCount.incrementAndGet();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class<IndexReference> clazz = IndexReference.class;
        synchronized (IndexReference.class) {
            if (this.index != null) {
                this.index = null;
                if (referenceCount.decrementAndGet() == 0) {
                    TasksUiPlugin.getDefault().removeModelListener(listener);
                    theIndex.close();
                    theIndex = null;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

