/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.internal.compress.CompressCircularSeries;
import org.eclipse.swtchart.model.Node;

public class NodeDataModel {
    private String Id;
    private Node rootNode;
    private Node rootPointer;
    private HashMap<String, Node> tree;
    private List<Node>[] nodesAtLevels;
    private CompressCircularSeries compressCircularSeries;

    public NodeDataModel() {
        this("Circular Chart");
    }

    public NodeDataModel(String id) {
        this.Id = id;
        this.rootNode = new Node(id, -1.0, this);
        this.tree = new HashMap();
        this.initialiseRootNode();
        this.rootPointer = this.rootNode;
        this.compressCircularSeries = new CompressCircularSeries(this);
    }

    private void initialiseRootNode() {
        this.rootNode.changeParent(this.rootNode);
        this.rootNode.setVisible(true);
        this.rootNode.setAngleBounds(new Point(0, 360));
        this.rootNode.setDataModel(this);
        this.rootNode.setSliceColor(Display.getDefault().getSystemColor(1));
        this.tree.put(this.Id, this.rootNode);
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public HashMap<String, Node> getTree() {
        return this.tree;
    }

    public Node getNodeById(String id) {
        return this.tree.get(id);
    }

    public List<Node>[] getNodes() {
        return this.nodesAtLevels;
    }

    public void setNodes(ArrayList<Node>[] arrayList) {
        this.nodesAtLevels = arrayList;
    }

    public Node getRootPointer() {
        return this.rootPointer;
    }

    public void setRootPointer(Node pointer) {
        this.rootPointer = pointer;
        this.rootPointer.setSliceColor(Display.getDefault().getSystemColor(1));
        this.rootPointer.setAngleBounds(new Point(0, 360));
        this.update();
    }

    public String getId() {
        return this.Id;
    }

    public void setId(String id) {
        this.Id = id;
        this.rootNode.setId(id);
    }

    public void update() {
        this.getRootPointer().updateValues();
        int maxTreeDepth = this.rootPointer.getMaxSubTreeDepth() - 1;
        this.setNodes(new ArrayList[maxTreeDepth + 1]);
        ArrayList[] node = (ArrayList[])this.getNodes();
        int i = 0;
        while (i <= maxTreeDepth) {
            node[i] = new ArrayList();
            ++i;
        }
        this.setNodes(node);
        node[0].add(this.rootPointer);
        this.getRootPointer().updateAngularBounds();
        this.getRootPointer().setVisible(true);
        this.compressCircularSeries.update();
    }

    public CompressCircularSeries getCompressor() {
        return this.compressCircularSeries;
    }
}

