/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.registry;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jdt.annotation.Owning;
import org.eclipse.tm4e.core.internal.utils.ResourceUtils;

public interface IGrammarSource {
    public static final /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$tm4e$core$registry$IGrammarSource$ContentType;

    private static ContentType guessFileFormat(String fileName) {
        String extension;
        return switch (extension = fileName.substring(fileName.lastIndexOf(46) + 1).trim().toLowerCase()) {
            case "json" -> ContentType.JSON;
            case "yml", "yaml", "yaml-tmlanguage" -> ContentType.YAML;
            case "xml", "plist", "tmlanguage" -> ContentType.XML;
            default -> throw new IllegalArgumentException("Unsupported file type: " + fileName);
        };
    }

    public static IGrammarSource fromFile(Path file) {
        return IGrammarSource.fromFile(file, null, null);
    }

    public static IGrammarSource fromFile(final Path file, @Nullable ContentType contentType, final @Nullable Charset charset) {
        final URI uri = file.toUri();
        final ContentType contentType1 = contentType == null ? IGrammarSource.guessFileFormat(file.toString()) : contentType;
        return new IGrammarSource(){

            @Override
            @Owning
            public Reader getReader() throws IOException {
                return Files.newBufferedReader(file, charset == null ? StandardCharsets.UTF_8 : charset);
            }

            @Override
            public URI getURI() {
                return uri;
            }

            @Override
            public ContentType getContentType() {
                return contentType1;
            }

            @Override
            public long getLastModified() {
                return file.toFile().lastModified();
            }
        };
    }

    public static IGrammarSource fromResource(Class<?> clazz, String resourceName) {
        return IGrammarSource.fromResource(clazz, resourceName, null, null);
    }

    public static IGrammarSource fromResource(final Class<?> clazz, final String resourceName, @Nullable ContentType contentType, final @Nullable Charset charset) {
        final URI uri = ResourceUtils.getResourceURI(clazz, resourceName);
        final ContentType contentType1 = contentType == null ? IGrammarSource.guessFileFormat(resourceName) : contentType;
        return new IGrammarSource(){

            @Override
            @Owning
            public Reader getReader() throws IOException {
                return ResourceUtils.getResourceReader(clazz, resourceName, charset);
            }

            @Override
            public URI getURI() {
                return uri;
            }

            @Override
            public ContentType getContentType() {
                return contentType1;
            }

            @Override
            public long getLastModified() {
                try {
                    return ResourceUtils.getResourceLastModified(clazz, resourceName);
                }
                catch (IOException ex) {
                    return 0L;
                }
            }
        };
    }

    public static IGrammarSource fromString(final ContentType contentType, final String content) {
        final URI uri = URI.create("data:" + (switch (contentType) {
            case ContentType.JSON -> "application/json";
            case ContentType.YAML -> "application/x-yaml";
            case ContentType.XML -> "application/xml";
            default -> "text/plain";
        }) + ";charset=UTF-8," + URLEncoder.encode(content, StandardCharsets.UTF_8));
        final long modified = System.currentTimeMillis();
        return new IGrammarSource(){

            @Override
            @Owning
            public Reader getReader() {
                return new StringReader(content);
            }

            @Override
            public URI getURI() {
                return uri;
            }

            @Override
            public ContentType getContentType() {
                return contentType;
            }

            @Override
            public long getLastModified() {
                return modified;
            }
        };
    }

    default public ContentType getContentType() {
        return IGrammarSource.guessFileFormat(this.getURI().getPath());
    }

    public URI getURI();

    @Owning
    public Reader getReader() throws IOException;

    public long getLastModified();

    public static enum ContentType {
        JSON,
        YAML,
        XML;

    }
}

