/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.internal.DPIUtil;

final class AutoScaleCalculation {
    private AutoScaleCalculation() {
    }

    static AutoScale parseFrom(String value) {
        if (value != null) {
            if ("false".equalsIgnoreCase(value)) {
                return new AutoScaleNone();
            }
            if ("half".equalsIgnoreCase(value)) {
                return new AutoScaleHalf();
            }
            if ("quarter".equalsIgnoreCase(value)) {
                return new AutoScaleQuarter();
            }
            if ("exact".equalsIgnoreCase(value)) {
                return new AutoScaleExact();
            }
            if ("integer".equalsIgnoreCase(value)) {
                return new AutoScaleInteger();
            }
            try {
                int zoomValue = Integer.parseInt(value);
                return new AutoScaleValue(zoomValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return AutoScaleCalculation.getDefaultAutoScale();
    }

    private static AutoScale getDefaultAutoScale() {
        return DPIUtil.isMonitorSpecificScalingActive() ? new AutoScaleQuarter() : new AutoScaleInteger();
    }

    static interface AutoScale {
        public int getAutoScaledZoom(int var1);

        public boolean isCompatibleToMonitorSpecificScaling();
    }

    private static class AutoScaleExact
    implements AutoScale {
        private static final String AS_STRING = "exact";

        private AutoScaleExact() {
        }

        @Override
        public int getAutoScaledZoom(int zoom) {
            return zoom;
        }

        @Override
        public boolean isCompatibleToMonitorSpecificScaling() {
            return true;
        }

        public String toString() {
            return AS_STRING;
        }
    }

    private static class AutoScaleHalf
    implements AutoScale {
        private static final String AS_STRING = "half";

        private AutoScaleHalf() {
        }

        @Override
        public int getAutoScaledZoom(int zoom) {
            return (int)Math.rint((double)zoom / 50.0) * 50;
        }

        @Override
        public boolean isCompatibleToMonitorSpecificScaling() {
            return false;
        }

        public String toString() {
            return AS_STRING;
        }
    }

    private static class AutoScaleInteger
    implements AutoScale {
        private static final String AS_STRING = "integer";

        private AutoScaleInteger() {
        }

        @Override
        public int getAutoScaledZoom(int zoom) {
            return Math.max((zoom + 25) / 100 * 100, 100);
        }

        @Override
        public boolean isCompatibleToMonitorSpecificScaling() {
            return false;
        }

        public String toString() {
            return AS_STRING;
        }
    }

    private static class AutoScaleNone
    implements AutoScale {
        private static final String AS_STRING = "false";

        private AutoScaleNone() {
        }

        @Override
        public int getAutoScaledZoom(int zoom) {
            return 100;
        }

        @Override
        public boolean isCompatibleToMonitorSpecificScaling() {
            return false;
        }

        public String toString() {
            return AS_STRING;
        }
    }

    private static class AutoScaleQuarter
    implements AutoScale {
        private static final String AS_STRING = "quarter";

        private AutoScaleQuarter() {
        }

        @Override
        public int getAutoScaledZoom(int zoom) {
            return Math.round((float)zoom / 25.0f) * 25;
        }

        @Override
        public boolean isCompatibleToMonitorSpecificScaling() {
            return true;
        }

        public String toString() {
            return AS_STRING;
        }
    }

    private static class AutoScaleValue
    implements AutoScale {
        private final int fixedZoom;

        AutoScaleValue(int zoom) {
            this.fixedZoom = zoom;
        }

        @Override
        public int getAutoScaledZoom(int zoom) {
            return this.fixedZoom;
        }

        @Override
        public boolean isCompatibleToMonitorSpecificScaling() {
            return false;
        }

        public String toString() {
            return "" + this.fixedZoom;
        }
    }
}

