/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.initParser;

import java.io.StringWriter;
import java.text.MessageFormat;
import org.eclipse.jem.internal.proxy.initParser.EvaluationException;
import org.eclipse.jem.internal.proxy.initParser.Expression;
import org.eclipse.jem.internal.proxy.initParser.Message;
import org.eclipse.jem.internal.proxy.initParser.PrimitiveOperation;
import org.eclipse.jem.internal.proxy.initParser.ProxyInitParserMessages;

public class Field
extends Expression {
    public boolean isComplete;
    protected java.lang.reflect.Field fField;
    public Expression receiver;
    public String fieldName;
    protected Class fResultType;

    public Field(Expression aReceiver, char[] token, ClassLoader aClassLoader) {
        this.receiver = aReceiver;
        if (token.length > 0) {
            this.fieldName = new String(token);
        }
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    @Override
    public Object evaluate() throws Exception {
        Object receiverValue = this.receiver.evaluate();
        try {
            this.cacheField();
            return this.fField.get(receiverValue);
        }
        catch (Exception e) {
            throw new EvaluationException(e);
        }
    }

    protected void cacheField() throws Exception {
        if (this.fField == null) {
            Class aReceiverClass = this.getEvaluationTypeClass(this.receiver);
            this.fField = aReceiverClass.getField(this.fieldName);
            this.fResultType = this.fField.getType();
        }
    }

    @Override
    public Class getTypeClass() throws Exception {
        if (this.fResultType == null) {
            this.cacheField();
        }
        return this.fResultType;
    }

    @Override
    protected String getTypeClassName() {
        return "";
    }

    @Override
    public Expression push(char[] token, char tokenDelimiter) {
        if (tokenDelimiter == '(') {
            return new Message(this, token, this.fClassLoader);
        }
        if (token.length > 0 && (tokenDelimiter == '.' || tokenDelimiter == ' ' || tokenDelimiter == ',')) {
            this.isComplete = true;
            return new Field(this, token, this.fClassLoader);
        }
        if (this.fieldName != null && tokenDelimiter == ',') {
            this.isComplete = true;
            return this;
        }
        if (!this.isComplete && this.fieldName == null) {
            this.fieldName = new String(token);
            return this;
        }
        if (tokenDelimiter == '|' || tokenDelimiter == '&') {
            this.isComplete = true;
            PrimitiveOperation result = new PrimitiveOperation(this, tokenDelimiter);
            return result;
        }
        if (token.length == 0 && tokenDelimiter == ' ') {
            return this;
        }
        throw new RuntimeException(MessageFormat.format(ProxyInitParserMessages.getString("UnexpectedToken_EXC_"), new StringBuffer(token.length + 1).append(token).append(tokenDelimiter).toString()));
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write("Field Name=\"");
        if (this.fieldName != null) {
            writer.write(this.fieldName);
        } else {
            writer.write("UNNAMED");
        }
        writer.write("\" Receiver=");
        if (this.receiver != null) {
            writer.write(this.receiver.toString());
        } else {
            writer.write("NONE");
        }
        return writer.toString();
    }

    @Override
    public boolean isPrimitive() throws Exception {
        this.cacheField();
        return this.getTypeClass().isPrimitive();
    }
}

