/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.ui.internal.launch;

import java.io.File;
import java.util.Optional;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaJRETab;
import org.eclipse.jdt.internal.debug.ui.jres.JREDescriptor;
import org.eclipse.jdt.internal.debug.ui.launcher.VMArgumentsBlock;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.internal.launch.MavenLaunchDelegate;
import org.eclipse.m2e.internal.launch.Messages;
import org.eclipse.m2e.jdt.MavenExecutionJre;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenJRETab
extends JavaJRETab {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenJRETab.class);
    private final VMArgumentsBlock vmArgumentsBlock = new VMArgumentsBlock();

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite comp = (Composite)this.fJREBlock.getControl();
        ((GridData)comp.getLayoutData()).grabExcessVerticalSpace = true;
        ((GridData)comp.getLayoutData()).verticalAlignment = 4;
        this.vmArgumentsBlock.createControl(comp);
        ((GridData)this.vmArgumentsBlock.getControl().getLayoutData()).horizontalSpan = 2;
    }

    protected IJavaProject getJavaProject() {
        File pomDir = MavenLaunchDelegate.getPomDirectory(this.getLaunchConfiguration());
        return MavenLaunchDelegate.getContainer(pomDir).map(IResource::getProject).filter(IResource::exists).map(JavaCore::create).filter(IJavaElement::exists).orElse(null);
    }

    protected JREDescriptor getDefaultJREDescriptor() {
        File pomDirectory = MavenLaunchDelegate.getPomDirectory(this.getLaunchConfiguration());
        NullProgressMonitor monitor = new NullProgressMonitor();
        String details = null;
        Optional<IMavenProjectFacade> mavenProjectFacade = MavenLaunchDelegate.getMavenProject(pomDirectory, (IProgressMonitor)monitor);
        if (mavenProjectFacade.isPresent()) {
            try {
                Optional mavenExecutionJre = MavenExecutionJre.forProject((IMavenProjectFacade)mavenProjectFacade.get(), (IProgressMonitor)monitor);
                Optional mavenJre = mavenExecutionJre.flatMap(jre -> jre.getBestMatchingVM());
                if (mavenJre.isPresent()) {
                    details = NLS.bind((String)Messages.MavenJRETab_lblDefaultDetailsRequiredJavaVersion, (Object)((IVMInstall)mavenJre.get()).getName(), (Object)((MavenExecutionJre)mavenExecutionJre.get()).getExecutionJreVersionRange());
                }
            }
            catch (CoreException ex) {
                LOGGER.warn("Unable to determine Maven JRE for project " + mavenProjectFacade.get().getProject().getName(), (Throwable)ex);
            }
        }
        if (details == null) {
            details = super.getDefaultJREDescriptor().getDescription();
        }
        final String finalDetails = details;
        return new JREDescriptor(){

            public String getDescription() {
                return NLS.bind((String)Messages.MavenJRETab_lblDefault, (Object)finalDetails);
            }
        };
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        IStatus status = this.fJREBlock.getStatus();
        if (!status.isOK()) {
            this.setErrorMessage(status.getMessage());
            return false;
        }
        ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            return dynamicTab.isValid(config);
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        this.vmArgumentsBlock.performApply(configuration);
        this.setLaunchConfigurationWorkingCopy(configuration);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        this.vmArgumentsBlock.initializeFrom(configuration);
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
        this.vmArgumentsBlock.setLaunchConfigurationDialog(dialog);
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.setLaunchConfigurationWorkingCopy(workingCopy);
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }
}

