/*
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at
 
     http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 =================== DO NOT EDIT THIS FILE ====================
 Generated by Modello 2.5.1,
 any modifications will be overwritten.
 ==============================================================
 */

package org.apache.maven.model;

/**
 * 
 *         
 *         The <code>&lt;scm&gt;</code> element contains
 * informations required to the SCM
 *         (Source Control Management) of the project.
 *         
 *       
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class Scm
    implements java.io.Serializable, java.lang.Cloneable, org.apache.maven.model.InputLocationTracker
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             
     *             The source control management system URL
     *             that describes the repository and how to connect
     * to the
     *             repository. For more information, see the
     *             <a
     * href="https://maven.apache.org/scm/scm-url-format.html">URL
     * format</a>
     *             and <a
     * href="https://maven.apache.org/scm/scms-overview.html">list
     * of supported SCMs</a>.
     *             This connection is read-only.
     *             <br><b>Default value is</b>: parent value [+
     * path adjustment] + (artifactId or project.directory
     * property), or just parent value if
     *             scm's
     * <code>child.scm.connection.inherit.append.path="false"</code>
     *             
     *           
     */
    private String connection;

    /**
     * 
     *             
     *             Just like <code>connection</code>, but for
     * developers, i.e. this scm connection
     *             will not be read only.
     *             <br><b>Default value is</b>: parent value [+
     * path adjustment] + (artifactId or project.directory
     * property), or just parent value if
     *             scm's
     * <code>child.scm.developerConnection.inherit.append.path="false"</code>
     *             
     *           
     */
    private String developerConnection;

    /**
     * The tag of current code. By default, it's set to HEAD during
     * development.
     */
    private String tag = "HEAD";

    /**
     * 
     *             
     *             The URL to the project's browsable SCM
     * repository, such as ViewVC or Fisheye.
     *             <br><b>Default value is</b>: parent value [+
     * path adjustment] + (artifactId or project.directory
     * property), or just parent value if
     *             scm's
     * <code>child.scm.url.inherit.append.path="false"</code>
     *             
     *           
     */
    private String url;

    /**
     * 
     *             
     *             When children inherit from scm connection,
     * append path or not? Note: While the type
     *             of this field is <code>String</code> for
     * technical reasons, the semantic type is actually
     *             <code>Boolean</code>
     *             <br><b>Default value is</b>: <code>true</code>
     *             <br><b>Since</b>: Maven 3.6.1
     *             
     *           .
     */
    private String childScmConnectionInheritAppendPath;

    /**
     * 
     *             
     *             When children inherit from scm developer
     * connection, append path or not? Note: While the type
     *             of this field is <code>String</code> for
     * technical reasons, the semantic type is actually
     *             <code>Boolean</code>
     *             <br><b>Default value is</b>: <code>true</code>
     *             <br><b>Since</b>: Maven 3.6.1
     *             
     *           .
     */
    private String childScmDeveloperConnectionInheritAppendPath;

    /**
     * 
     *             
     *             When children inherit from scm url, append path
     * or not? Note: While the type
     *             of this field is <code>String</code> for
     * technical reasons, the semantic type is actually
     *             <code>Boolean</code>
     *             <br><b>Default value is</b>: <code>true</code>
     *             <br><b>Since</b>: Maven 3.6.1
     *             
     *           .
     */
    private String childScmUrlInheritAppendPath;

    /**
     * Field locations.
     */
    private java.util.Map<Object, InputLocation> locations;

    /**
     * Field location.
     */
    private InputLocation location;

    /**
     * Field connectionLocation.
     */
    private InputLocation connectionLocation;

    /**
     * Field developerConnectionLocation.
     */
    private InputLocation developerConnectionLocation;

    /**
     * Field tagLocation.
     */
    private InputLocation tagLocation;

    /**
     * Field urlLocation.
     */
    private InputLocation urlLocation;

    /**
     * Field childScmConnectionInheritAppendPathLocation.
     */
    private InputLocation childScmConnectionInheritAppendPathLocation;

    /**
     * Field childScmDeveloperConnectionInheritAppendPathLocation.
     */
    private InputLocation childScmDeveloperConnectionInheritAppendPathLocation;

    /**
     * Field childScmUrlInheritAppendPathLocation.
     */
    private InputLocation childScmUrlInheritAppendPathLocation;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method clone.
     * 
     * @return Scm
     */
    public Scm clone()
    {
        try
        {
            Scm copy = (Scm) super.clone();

            if ( copy.locations != null )
            {
                copy.locations = new java.util.LinkedHashMap( copy.locations );
            }

            return copy;
        }
        catch ( java.lang.Exception ex )
        {
            throw (java.lang.RuntimeException) new java.lang.UnsupportedOperationException( getClass().getName()
                + " does not support clone()" ).initCause( ex );
        }
    } //-- Scm clone()

    /**
     * Get when children inherit from scm connection, append path
     * or not? Note: While the type
     *             of this field is <code>String</code> for
     * technical reasons, the semantic type is actually
     *             <code>Boolean</code>
     *             <br><b>Default value is</b>: <code>true</code>
     *             <br><b>Since</b>: Maven 3.6.1.
     * 
     * @return String
     */
    public String getChildScmConnectionInheritAppendPath()
    {
        return this.childScmConnectionInheritAppendPath;
    } //-- String getChildScmConnectionInheritAppendPath()

    /**
     * Get when children inherit from scm developer connection,
     * append path or not? Note: While the type
     *             of this field is <code>String</code> for
     * technical reasons, the semantic type is actually
     *             <code>Boolean</code>
     *             <br><b>Default value is</b>: <code>true</code>
     *             <br><b>Since</b>: Maven 3.6.1.
     * 
     * @return String
     */
    public String getChildScmDeveloperConnectionInheritAppendPath()
    {
        return this.childScmDeveloperConnectionInheritAppendPath;
    } //-- String getChildScmDeveloperConnectionInheritAppendPath()

    /**
     * Get when children inherit from scm url, append path or not?
     * Note: While the type
     *             of this field is <code>String</code> for
     * technical reasons, the semantic type is actually
     *             <code>Boolean</code>
     *             <br><b>Default value is</b>: <code>true</code>
     *             <br><b>Since</b>: Maven 3.6.1.
     * 
     * @return String
     */
    public String getChildScmUrlInheritAppendPath()
    {
        return this.childScmUrlInheritAppendPath;
    } //-- String getChildScmUrlInheritAppendPath()

    /**
     * Get the source control management system URL
     *             that describes the repository and how to connect
     * to the
     *             repository. For more information, see the
     *             <a
     * href="https://maven.apache.org/scm/scm-url-format.html">URL
     * format</a>
     *             and <a
     * href="https://maven.apache.org/scm/scms-overview.html">list
     * of supported SCMs</a>.
     *             This connection is read-only.
     *             <br><b>Default value is</b>: parent value [+
     * path adjustment] + (artifactId or project.directory
     * property), or just parent value if
     *             scm's
     * <code>child.scm.connection.inherit.append.path="false"</code>
     * 
     * @return String
     */
    public String getConnection()
    {
        return this.connection;
    } //-- String getConnection()

    /**
     * Get just like <code>connection</code>, but for developers,
     * i.e. this scm connection
     *             will not be read only.
     *             <br><b>Default value is</b>: parent value [+
     * path adjustment] + (artifactId or project.directory
     * property), or just parent value if
     *             scm's
     * <code>child.scm.developerConnection.inherit.append.path="false"</code>
     * 
     * @return String
     */
    public String getDeveloperConnection()
    {
        return this.developerConnection;
    } //-- String getDeveloperConnection()

    /**
     * 
     * 
     * @param key a key object.
     * @return InputLocation
     */
    public InputLocation getLocation( Object key )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "" :
                {
                    return this.location;
                }
                case "connection" :
                {
                    return connectionLocation;
                }
                case "developerConnection" :
                {
                    return developerConnectionLocation;
                }
                case "tag" :
                {
                    return tagLocation;
                }
                case "url" :
                {
                    return urlLocation;
                }
                case "childScmConnectionInheritAppendPath" :
                {
                    return childScmConnectionInheritAppendPathLocation;
                }
                case "childScmDeveloperConnectionInheritAppendPath" :
                {
                    return childScmDeveloperConnectionInheritAppendPathLocation;
                }
                case "childScmUrlInheritAppendPath" :
                {
                    return childScmUrlInheritAppendPathLocation;
                }
                default :
                {
                    return getOtherLocation( key );
                }
                }
            }
            else
            {
                return getOtherLocation( key );
            }
    } //-- InputLocation getLocation( Object )

    /**
     * 
     * 
     * @param key a key object.
     * @param location a location object.
     */
    public void setLocation( Object key, InputLocation location )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "" :
                {
                    this.location = location;
                    return;
                }
                case "connection" :
                {
                    connectionLocation = location;
                    return;
                }
                case "developerConnection" :
                {
                    developerConnectionLocation = location;
                    return;
                }
                case "tag" :
                {
                    tagLocation = location;
                    return;
                }
                case "url" :
                {
                    urlLocation = location;
                    return;
                }
                case "childScmConnectionInheritAppendPath" :
                {
                    childScmConnectionInheritAppendPathLocation = location;
                    return;
                }
                case "childScmDeveloperConnectionInheritAppendPath" :
                {
                    childScmDeveloperConnectionInheritAppendPathLocation = location;
                    return;
                }
                case "childScmUrlInheritAppendPath" :
                {
                    childScmUrlInheritAppendPathLocation = location;
                    return;
                }
                default :
                {
                    setOtherLocation( key, location );
                    return;
                }
            }
        }
        else
        {
            setOtherLocation( key, location );
        }
    } //-- void setLocation( Object, InputLocation )

    /**
     * 
     * 
     * @param key a key object.
     * @param location a location object.
     */
    public void setOtherLocation( Object key, InputLocation location )
    {
        if ( location != null )
        {
            if ( this.locations == null )
            {
                this.locations = new java.util.LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put( key, location );
        }
    } //-- void setOtherLocation( Object, InputLocation )

    /**
     * 
     * 
     * @param key a key object.
     * @return InputLocation
     */
    private InputLocation getOtherLocation( Object key )
    {
        return ( locations != null ) ? locations.get( key ) : null;
    } //-- InputLocation getOtherLocation( Object )

    /**
     * Get the tag of current code. By default, it's set to HEAD
     * during development.
     * 
     * @return String
     */
    public String getTag()
    {
        return this.tag;
    } //-- String getTag()

    /**
     * Get the URL to the project's browsable SCM repository, such
     * as ViewVC or Fisheye.
     *             <br><b>Default value is</b>: parent value [+
     * path adjustment] + (artifactId or project.directory
     * property), or just parent value if
     *             scm's
     * <code>child.scm.url.inherit.append.path="false"</code>
     * 
     * @return String
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl()

    /**
     * Set when children inherit from scm connection, append path
     * or not? Note: While the type
     *             of this field is <code>String</code> for
     * technical reasons, the semantic type is actually
     *             <code>Boolean</code>
     *             <br><b>Default value is</b>: <code>true</code>
     *             <br><b>Since</b>: Maven 3.6.1.
     * 
     * @param childScmConnectionInheritAppendPath a
     * childScmConnectionInheritAppendPath object.
     */
    public void setChildScmConnectionInheritAppendPath( String childScmConnectionInheritAppendPath )
    {
        this.childScmConnectionInheritAppendPath = childScmConnectionInheritAppendPath;
    } //-- void setChildScmConnectionInheritAppendPath( String )

    /**
     * Set when children inherit from scm developer connection,
     * append path or not? Note: While the type
     *             of this field is <code>String</code> for
     * technical reasons, the semantic type is actually
     *             <code>Boolean</code>
     *             <br><b>Default value is</b>: <code>true</code>
     *             <br><b>Since</b>: Maven 3.6.1.
     * 
     * @param childScmDeveloperConnectionInheritAppendPath a
     * childScmDeveloperConnectionInheritAppendPath object.
     */
    public void setChildScmDeveloperConnectionInheritAppendPath( String childScmDeveloperConnectionInheritAppendPath )
    {
        this.childScmDeveloperConnectionInheritAppendPath = childScmDeveloperConnectionInheritAppendPath;
    } //-- void setChildScmDeveloperConnectionInheritAppendPath( String )

    /**
     * Set when children inherit from scm url, append path or not?
     * Note: While the type
     *             of this field is <code>String</code> for
     * technical reasons, the semantic type is actually
     *             <code>Boolean</code>
     *             <br><b>Default value is</b>: <code>true</code>
     *             <br><b>Since</b>: Maven 3.6.1.
     * 
     * @param childScmUrlInheritAppendPath a
     * childScmUrlInheritAppendPath object.
     */
    public void setChildScmUrlInheritAppendPath( String childScmUrlInheritAppendPath )
    {
        this.childScmUrlInheritAppendPath = childScmUrlInheritAppendPath;
    } //-- void setChildScmUrlInheritAppendPath( String )

    /**
     * Set the source control management system URL
     *             that describes the repository and how to connect
     * to the
     *             repository. For more information, see the
     *             <a
     * href="https://maven.apache.org/scm/scm-url-format.html">URL
     * format</a>
     *             and <a
     * href="https://maven.apache.org/scm/scms-overview.html">list
     * of supported SCMs</a>.
     *             This connection is read-only.
     *             <br><b>Default value is</b>: parent value [+
     * path adjustment] + (artifactId or project.directory
     * property), or just parent value if
     *             scm's
     * <code>child.scm.connection.inherit.append.path="false"</code>
     * 
     * @param connection a connection object.
     */
    public void setConnection( String connection )
    {
        this.connection = connection;
    } //-- void setConnection( String )

    /**
     * Set just like <code>connection</code>, but for developers,
     * i.e. this scm connection
     *             will not be read only.
     *             <br><b>Default value is</b>: parent value [+
     * path adjustment] + (artifactId or project.directory
     * property), or just parent value if
     *             scm's
     * <code>child.scm.developerConnection.inherit.append.path="false"</code>
     * 
     * @param developerConnection a developerConnection object.
     */
    public void setDeveloperConnection( String developerConnection )
    {
        this.developerConnection = developerConnection;
    } //-- void setDeveloperConnection( String )

    /**
     * Set the tag of current code. By default, it's set to HEAD
     * during development.
     * 
     * @param tag a tag object.
     */
    public void setTag( String tag )
    {
        this.tag = tag;
    } //-- void setTag( String )

    /**
     * Set the URL to the project's browsable SCM repository, such
     * as ViewVC or Fisheye.
     *             <br><b>Default value is</b>: parent value [+
     * path adjustment] + (artifactId or project.directory
     * property), or just parent value if
     *             scm's
     * <code>child.scm.url.inherit.append.path="false"</code>
     * 
     * @param url a url object.
     */
    public void setUrl( String url )
    {
        this.url = url;
    } //-- void setUrl( String )

    
            

    public boolean isChildScmConnectionInheritAppendPath()
    {
        return ( childScmConnectionInheritAppendPath != null ) ? Boolean.parseBoolean( childScmConnectionInheritAppendPath ) : true;
    }

    public void setChildScmConnectionInheritAppendPath( boolean childScmConnectionInheritAppendPath )
    {
        this.childScmConnectionInheritAppendPath = String.valueOf( childScmConnectionInheritAppendPath );
    }

    public boolean isChildScmDeveloperConnectionInheritAppendPath()
    {
        return ( childScmDeveloperConnectionInheritAppendPath != null ) ? Boolean.parseBoolean( childScmDeveloperConnectionInheritAppendPath ) : true;
    }

    public void setChildScmDeveloperConnectionInheritAppendPath( boolean childScmDeveloperConnectionInheritAppendPath )
    {
        this.childScmDeveloperConnectionInheritAppendPath = String.valueOf( childScmDeveloperConnectionInheritAppendPath );
    }

    public boolean isChildScmUrlInheritAppendPath()
    {
        return ( childScmUrlInheritAppendPath != null ) ? Boolean.parseBoolean( childScmUrlInheritAppendPath ) : true;
    }

    public void setChildScmUrlInheritAppendPath( boolean childScmUrlInheritAppendPath )
    {
        this.childScmUrlInheritAppendPath = String.valueOf( childScmUrlInheritAppendPath );
    }

            
          
    
            
    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return "Scm {connection=" + connection + "}";
    }
            
          
}
