/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.tool;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import jdk.jfr.internal.consumer.ChunkHeader;
import jdk.jfr.internal.consumer.RecordingInput;
import jdk.jfr.internal.tool.Command;
import jdk.jfr.internal.tool.UserDataException;
import jdk.jfr.internal.tool.UserSyntaxException;

final class Disassemble
extends Command {
    Disassemble() {
    }

    @Override
    public String getName() {
        return "disassemble";
    }

    @Override
    public List<String> getOptionSyntax() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("[--output <directory>]");
        arrayList.add("[--max-chunks <chunks>]");
        arrayList.add("[--max-size <size>]");
        arrayList.add("<file>");
        return arrayList;
    }

    @Override
    public void displayOptionUsage(PrintStream printStream) {
        printStream.println(" --output <directory>    The location to write the disassembled file,");
        printStream.println("                         by default the current directory");
        printStream.println("");
        printStream.println(" --max-chunks <chunks>   Maximum number of chunks per disassembled file,");
        printStream.println("                         by default 5. The chunk size varies, but is ");
        printStream.println("                         typically around 15 MB.");
        printStream.println("");
        printStream.println(" --max-size <size>       Maximum number of bytes per file.");
        printStream.println("");
        printStream.println("  <file>                 Location of the recording file (.jfr)");
    }

    @Override
    public String getDescription() {
        return "Disassamble a recording file into smaller files/chunks";
    }

    @Override
    public void execute(Deque<String> deque) throws UserSyntaxException, UserDataException {
        List<Long> list;
        Object object;
        if (deque.isEmpty()) {
            throw new UserSyntaxException("missing file");
        }
        Path path = this.getJFRInputFile(deque);
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        String string = System.getProperty("user.dir");
        int n3 = deque.size();
        while (n3 > 0) {
            if (this.acceptOption(deque, "--output")) {
                string = deque.pop();
            }
            if (this.acceptOption(deque, "--max-size")) {
                object = deque.pop();
                try {
                    n2 = Integer.parseInt((String)object);
                    if (n2 < 1) {
                        throw new UserDataException("max size must be at least 1");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new UserDataException("not a valid value for --max-size.");
                }
            }
            if (this.acceptOption(deque, "--max-chunks")) {
                object = deque.pop();
                try {
                    n = Integer.parseInt((String)object);
                    if (n < 1) {
                        throw new UserDataException("max chunks must be at least 1.");
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new UserDataException("not a valid value for --max-size.");
                }
            }
            if (n3 == deque.size()) {
                throw new UserSyntaxException("unknown option " + deque.peek());
            }
            n3 = deque.size();
        }
        object = this.getDirectory(string);
        this.println();
        this.println("Examining recording " + path + " ...");
        if (n2 != Integer.MAX_VALUE && n == Integer.MAX_VALUE) {
            try {
                long l = Files.size(path);
                if ((long)n2 >= l) {
                    this.println();
                    this.println("File size (" + l + ") does not exceed max size (" + n2 + ")");
                    return;
                }
            }
            catch (IOException iOException) {
                throw new UserDataException("unexpected i/o error when determining file size" + iOException.getMessage());
            }
        }
        if (n2 == Integer.MAX_VALUE && n == Integer.MAX_VALUE) {
            n = 5;
        }
        try {
            list = this.findChunkSizes(path);
        }
        catch (IOException iOException) {
            throw new UserDataException("unexpected i/o error. " + iOException.getMessage());
        }
        if (n2 == Integer.MAX_VALUE == list.size() <= n) {
            throw new UserDataException("number of chunks in recording (" + list.size() + ") doesn't exceed max chunks (" + n + ")");
        }
        this.println();
        if (list.size() <= 0) {
            throw new UserDataException("no JFR chunks found in file.");
        }
        List<Long> list2 = this.combineChunkSizes(list, n, n2);
        this.print("File consists of " + list.size() + " chunks. The recording will be split into ");
        this.println(list2.size() + " files");
        this.println();
        this.splitFile((Path)object, path, list2);
    }

    private List<Long> findChunkSizes(Path path) throws IOException {
        try (RecordingInput recordingInput = new RecordingInput(path.toFile());){
            ArrayList<Long> arrayList = new ArrayList<Long>();
            ChunkHeader chunkHeader = new ChunkHeader(recordingInput);
            arrayList.add(chunkHeader.getSize());
            while (!chunkHeader.isLastChunk()) {
                chunkHeader = chunkHeader.nextHeader();
                arrayList.add(chunkHeader.getSize());
            }
            ArrayList<Long> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    private List<Long> combineChunkSizes(List<Long> list, int n, long l) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        int n2 = 1;
        long l2 = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            long l3 = list.get(i);
            if (l2 + l3 > l) {
                arrayList.add(l2);
                n2 = 1;
                l2 = l3;
                continue;
            }
            l2 += l3;
            if (n2 == n) {
                arrayList.add(l2);
                l2 = 0L;
                n2 = 1;
                continue;
            }
            ++n2;
        }
        if (l2 != 0L) {
            arrayList.add(l2);
        }
        return arrayList;
    }

    private void splitFile(Path path, Path path2, List<Long> list) throws UserDataException {
        Object object;
        int n = String.valueOf(list.size() - 1).length();
        String string = path2.getFileName().toString();
        String string2 = string.subSequence(0, string.length() - 4) + "_%0" + n + "d.jfr";
        for (int i = 0; i < list.size(); ++i) {
            object = String.format(string2, i);
            try {
                Path path3 = path.resolve((String)object);
                if (!Files.exists(path3, new LinkOption[0])) continue;
                throw new UserDataException("can't create disassembled file " + path3 + ", a file with that name already exist");
            }
            catch (InvalidPathException invalidPathException) {
                throw new UserDataException("can't construct path with filename" + (String)object);
            }
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(path2.toFile())));
            object = null;
            try {
                for (int i = 0; i < list.size(); ++i) {
                    Long l = list.get(i);
                    byte[] byArray = this.readBytes(dataInputStream, l.intValue());
                    String string3 = String.format(string2, i);
                    Path path4 = path.resolve(string3);
                    File file = path4.toFile();
                    this.println("Writing " + file + " ... " + byArray.length);
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    fileOutputStream.write(byArray);
                    fileOutputStream.close();
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (dataInputStream != null) {
                    if (object != null) {
                        try {
                            dataInputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        dataInputStream.close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new UserDataException("i/o error writing file " + path2);
        }
    }

    private byte[] readBytes(InputStream inputStream, int n) throws UserDataException, IOException {
        int n2;
        byte[] byArray = new byte[n];
        for (int i = 0; i < byArray.length; i += n2) {
            n2 = inputStream.read(byArray, i, byArray.length - i);
            if (n2 != -1) continue;
            throw new UserDataException("unexpected end of data");
        }
        return byArray;
    }
}

