"use strict";
(self["webpackChunkcdt_cloud_blueprint_app"] = self["webpackChunkcdt_cloud_blueprint_app"] || []).push([["vendors-node_modules_theia_ai-chat_lib_browser_ai-chat-frontend-module_js"],{

/***/ "../../node_modules/@theia/ai-chat/lib/browser/ai-chat-frontend-module.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/browser/ai-chat-frontend-module.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const common_1 = __webpack_require__(/*! @theia/ai-core/lib/common */ "../../node_modules/@theia/ai-core/lib/common/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_2 = __webpack_require__(/*! ../common */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
const chat_agents_variable_contribution_1 = __webpack_require__(/*! ../common/chat-agents-variable-contribution */ "../../node_modules/@theia/ai-chat/lib/common/chat-agents-variable-contribution.js");
const custom_chat_agent_1 = __webpack_require__(/*! ../common/custom-chat-agent */ "../../node_modules/@theia/ai-chat/lib/common/custom-chat-agent.js");
const response_content_matcher_1 = __webpack_require__(/*! ../common/response-content-matcher */ "../../node_modules/@theia/ai-chat/lib/common/response-content-matcher.js");
const ai_chat_preferences_1 = __webpack_require__(/*! ./ai-chat-preferences */ "../../node_modules/@theia/ai-chat/lib/browser/ai-chat-preferences.js");
const change_set_file_element_1 = __webpack_require__(/*! ./change-set-file-element */ "../../node_modules/@theia/ai-chat/lib/browser/change-set-file-element.js");
const custom_agent_frontend_application_contribution_1 = __webpack_require__(/*! ./custom-agent-frontend-application-contribution */ "../../node_modules/@theia/ai-chat/lib/browser/custom-agent-frontend-application-contribution.js");
const frontend_chat_service_1 = __webpack_require__(/*! ./frontend-chat-service */ "../../node_modules/@theia/ai-chat/lib/browser/frontend-chat-service.js");
const custom_agent_factory_1 = __webpack_require__(/*! ./custom-agent-factory */ "../../node_modules/@theia/ai-chat/lib/browser/custom-agent-factory.js");
const chat_tool_request_service_1 = __webpack_require__(/*! ../common/chat-tool-request-service */ "../../node_modules/@theia/ai-chat/lib/common/chat-tool-request-service.js");
const change_set_file_service_1 = __webpack_require__(/*! ./change-set-file-service */ "../../node_modules/@theia/ai-chat/lib/browser/change-set-file-service.js");
const context_variable_label_provider_1 = __webpack_require__(/*! ./context-variable-label-provider */ "../../node_modules/@theia/ai-chat/lib/browser/context-variable-label-provider.js");
const context_file_variable_label_provider_1 = __webpack_require__(/*! ./context-file-variable-label-provider */ "../../node_modules/@theia/ai-chat/lib/browser/context-file-variable-label-provider.js");
const file_chat_variable_contribution_1 = __webpack_require__(/*! ./file-chat-variable-contribution */ "../../node_modules/@theia/ai-chat/lib/browser/file-chat-variable-contribution.js");
const context_summary_variable_1 = __webpack_require__(/*! ../common/context-summary-variable */ "../../node_modules/@theia/ai-chat/lib/common/context-summary-variable.js");
const context_details_variable_1 = __webpack_require__(/*! ../common/context-details-variable */ "../../node_modules/@theia/ai-chat/lib/common/context-details-variable.js");
const change_set_variable_1 = __webpack_require__(/*! ./change-set-variable */ "../../node_modules/@theia/ai-chat/lib/browser/change-set-variable.js");
const chat_session_naming_service_1 = __webpack_require__(/*! ../common/chat-session-naming-service */ "../../node_modules/@theia/ai-chat/lib/common/chat-session-naming-service.js");
const change_set_decorator_service_1 = __webpack_require__(/*! ./change-set-decorator-service */ "../../node_modules/@theia/ai-chat/lib/browser/change-set-decorator-service.js");
const chat_session_summary_agent_1 = __webpack_require__(/*! ../common/chat-session-summary-agent */ "../../node_modules/@theia/ai-chat/lib/common/chat-session-summary-agent.js");
const task_context_variable_contribution_1 = __webpack_require__(/*! ./task-context-variable-contribution */ "../../node_modules/@theia/ai-chat/lib/browser/task-context-variable-contribution.js");
const task_context_variable_label_provider_1 = __webpack_require__(/*! ./task-context-variable-label-provider */ "../../node_modules/@theia/ai-chat/lib/browser/task-context-variable-label-provider.js");
const task_context_service_1 = __webpack_require__(/*! ./task-context-service */ "../../node_modules/@theia/ai-chat/lib/browser/task-context-service.js");
const task_context_storage_service_1 = __webpack_require__(/*! ./task-context-storage-service */ "../../node_modules/@theia/ai-chat/lib/browser/task-context-storage-service.js");
const ai_chat_frontend_contribution_1 = __webpack_require__(/*! ./ai-chat-frontend-contribution */ "../../node_modules/@theia/ai-chat/lib/browser/ai-chat-frontend-contribution.js");
exports["default"] = new inversify_1.ContainerModule(bind => {
    (0, core_1.bindContributionProvider)(bind, common_1.Agent);
    (0, core_1.bindContributionProvider)(bind, common_2.ChatAgent);
    bind(chat_tool_request_service_1.ChatToolRequestService).toSelf().inSingletonScope();
    bind(common_2.ChatAgentServiceImpl).toSelf().inSingletonScope();
    bind(common_2.ChatAgentService).toService(common_2.ChatAgentServiceImpl);
    bind(common_2.PinChatAgent).toConstantValue(true);
    bind(chat_session_naming_service_1.ChatSessionNamingService).toSelf().inSingletonScope();
    bind(chat_session_naming_service_1.ChatSessionNamingAgent).toSelf().inSingletonScope();
    bind(common_1.Agent).toService(chat_session_naming_service_1.ChatSessionNamingAgent);
    (0, core_1.bindContributionProvider)(bind, response_content_matcher_1.ResponseContentMatcherProvider);
    bind(response_content_matcher_1.DefaultResponseContentMatcherProvider).toSelf().inSingletonScope();
    bind(response_content_matcher_1.ResponseContentMatcherProvider).toService(response_content_matcher_1.DefaultResponseContentMatcherProvider);
    bind(response_content_matcher_1.DefaultResponseContentFactory).toSelf().inSingletonScope();
    bind(common_1.AIVariableContribution).to(chat_agents_variable_contribution_1.ChatAgentsVariableContribution).inSingletonScope();
    bind(common_2.ChatRequestParserImpl).toSelf().inSingletonScope();
    bind(common_2.ChatRequestParser).toService(common_2.ChatRequestParserImpl);
    bind(frontend_chat_service_1.FrontendChatServiceImpl).toSelf().inSingletonScope();
    bind(common_2.ChatService).toService(frontend_chat_service_1.FrontendChatServiceImpl);
    bind(browser_1.PreferenceContribution).toConstantValue({ schema: ai_chat_preferences_1.aiChatPreferences });
    bind(custom_chat_agent_1.CustomChatAgent).toSelf();
    bind(custom_agent_factory_1.CustomAgentFactory).toFactory(ctx => (id, name, description, prompt, defaultLLM) => {
        const agent = ctx.container.get(custom_chat_agent_1.CustomChatAgent);
        agent.id = id;
        agent.name = name;
        agent.description = description;
        agent.prompt = prompt;
        agent.languageModelRequirements = [{
                purpose: 'chat',
                identifier: defaultLLM,
            }];
        ctx.container.get(common_2.ChatAgentService).registerChatAgent(agent);
        ctx.container.get(common_1.AgentService).registerAgent(agent);
        return agent;
    });
    bind(browser_1.FrontendApplicationContribution).to(custom_agent_frontend_application_contribution_1.AICustomAgentsFrontendApplicationContribution).inSingletonScope();
    bind(context_variable_label_provider_1.ContextVariableLabelProvider).toSelf().inSingletonScope();
    bind(browser_1.LabelProviderContribution).toService(context_variable_label_provider_1.ContextVariableLabelProvider);
    bind(context_file_variable_label_provider_1.ContextFileVariableLabelProvider).toSelf().inSingletonScope();
    bind(browser_1.LabelProviderContribution).toService(context_file_variable_label_provider_1.ContextFileVariableLabelProvider);
    bind(change_set_file_service_1.ChangeSetFileService).toSelf().inSingletonScope();
    bind(change_set_file_element_1.ChangeSetFileElementFactory).toFactory(ctx => (args) => {
        const container = ctx.container.createChild();
        container.bind(change_set_file_element_1.ChangeSetElementArgs).toConstantValue(args);
        container.bind(change_set_file_element_1.ChangeSetFileElement).toSelf().inSingletonScope();
        return container.get(change_set_file_element_1.ChangeSetFileElement);
    });
    bind(change_set_decorator_service_1.ChangeSetDecoratorService).toSelf().inSingletonScope();
    bind(browser_1.FrontendApplicationContribution).toService(change_set_decorator_service_1.ChangeSetDecoratorService);
    (0, core_1.bindContributionProvider)(bind, change_set_decorator_service_1.ChangeSetDecorator);
    bind(common_2.ToolCallChatResponseContentFactory).toSelf().inSingletonScope();
    bind(common_1.AIVariableContribution).to(file_chat_variable_contribution_1.FileChatVariableContribution).inSingletonScope();
    bind(common_1.AIVariableContribution).to(context_summary_variable_1.ContextSummaryVariableContribution).inSingletonScope();
    bind(common_1.AIVariableContribution).to(context_details_variable_1.ContextDetailsVariableContribution).inSingletonScope();
    bind(common_1.AIVariableContribution).to(change_set_variable_1.ChangeSetVariableContribution).inSingletonScope();
    bind(chat_session_summary_agent_1.ChatSessionSummaryAgent).toSelf().inSingletonScope();
    bind(common_1.Agent).toService(chat_session_summary_agent_1.ChatSessionSummaryAgent);
    bind(task_context_variable_contribution_1.TaskContextVariableContribution).toSelf().inSingletonScope();
    bind(common_1.AIVariableContribution).toService(task_context_variable_contribution_1.TaskContextVariableContribution);
    bind(task_context_variable_label_provider_1.TaskContextVariableLabelProvider).toSelf().inSingletonScope();
    bind(browser_1.LabelProviderContribution).toService(task_context_variable_label_provider_1.TaskContextVariableLabelProvider);
    bind(task_context_service_1.TaskContextService).toSelf().inSingletonScope();
    bind(task_context_storage_service_1.InMemoryTaskContextStorage).toSelf().inSingletonScope();
    bind(task_context_service_1.TaskContextStorageService).toService(task_context_storage_service_1.InMemoryTaskContextStorage);
    bind(ai_chat_frontend_contribution_1.AIChatFrontendContribution).toSelf().inSingletonScope();
    bind(core_1.CommandContribution).toService(ai_chat_frontend_contribution_1.AIChatFrontendContribution);
});


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/browser/ai-chat-preferences.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/browser/ai-chat-preferences.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.aiChatPreferences = exports.PIN_CHAT_AGENT_PREF = exports.DEFAULT_CHAT_AGENT_PREF = void 0;
const ai_core_preferences_1 = __webpack_require__(/*! @theia/ai-core/lib/browser/ai-core-preferences */ "../../node_modules/@theia/ai-core/lib/browser/ai-core-preferences.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
exports.DEFAULT_CHAT_AGENT_PREF = 'ai-features.chat.defaultChatAgent';
exports.PIN_CHAT_AGENT_PREF = 'ai-features.chat.pinChatAgent';
exports.aiChatPreferences = {
    type: 'object',
    properties: {
        [exports.DEFAULT_CHAT_AGENT_PREF]: {
            type: 'string',
            description: core_1.nls.localize('theia/ai/chat/defaultAgent/description', 'Optional: <agent-name> of the Chat Agent that shall be invoked, if no agent is explicitly mentioned with @<agent-name> in the user query. \
If no Default Agent is configured, Theia´s defaults will be applied.'),
            title: ai_core_preferences_1.AI_CORE_PREFERENCES_TITLE,
        },
        [exports.PIN_CHAT_AGENT_PREF]: {
            type: 'boolean',
            description: core_1.nls.localize('theia/ai/chat/pinChatAgent/description', 'Enable agent pinning to automatically keep a mentioned chat agent active across prompts, reducing the need for repeated mentions.\
You can manually unpin or switch agents anytime.'),
            default: true,
            title: ai_core_preferences_1.AI_CORE_PREFERENCES_TITLE,
        }
    }
};


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/browser/change-set-variable.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/browser/change-set-variable.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeSetVariableContribution = exports.CHANGE_SET_SUMMARY_VARIABLE = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/workspace/lib/browser */ "../../node_modules/@theia/workspace/lib/browser/index.js");
const common_1 = __webpack_require__(/*! ../common */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
exports.CHANGE_SET_SUMMARY_VARIABLE = {
    id: common_1.CHANGE_SET_SUMMARY_VARIABLE_ID,
    description: core_1.nls.localize('theia/ai/core/changeSetSummaryVariable/description', 'Provides a summary of the files in a change set and their contents.'),
    name: common_1.CHANGE_SET_SUMMARY_VARIABLE_ID,
};
let ChangeSetVariableContribution = class ChangeSetVariableContribution {
    registerVariables(service) {
        service.registerResolver(exports.CHANGE_SET_SUMMARY_VARIABLE, this);
    }
    canResolve(request, context) {
        return request.variable.name === exports.CHANGE_SET_SUMMARY_VARIABLE.name ? 50 : 0;
    }
    async resolve(request, context) {
        var _a;
        if (!common_1.ChatSessionContext.is(context) || request.variable.name !== exports.CHANGE_SET_SUMMARY_VARIABLE.name) {
            return undefined;
        }
        if (!((_a = context.model.changeSet) === null || _a === void 0 ? void 0 : _a.getElements().length)) {
            return {
                variable: exports.CHANGE_SET_SUMMARY_VARIABLE,
                value: ''
            };
        }
        const entries = await Promise.all(context.model.changeSet.getElements().map(async (element) => `- file: ${await this.workspaceService.getWorkspaceRelativePath(element.uri)}, status: ${element.state}`));
        return {
            variable: exports.CHANGE_SET_SUMMARY_VARIABLE,
            value: `## Previously Proposed Changes
You have previously proposed changes for the following files. Some suggestions may have been accepted by the user, while others may still be pending.
${entries.join('\n')}
`
        };
    }
};
exports.ChangeSetVariableContribution = ChangeSetVariableContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.WorkspaceService),
    tslib_1.__metadata("design:type", browser_1.WorkspaceService)
], ChangeSetVariableContribution.prototype, "workspaceService", void 0);
exports.ChangeSetVariableContribution = ChangeSetVariableContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ChangeSetVariableContribution);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/browser/context-file-variable-label-provider.js":
/*!*********************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/browser/context-file-variable-label-provider.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ContextFileVariableLabelProvider = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const ai_core_1 = __webpack_require__(/*! @theia/ai-core */ "../../node_modules/@theia/ai-core/lib/common/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const change_set_file_service_1 = __webpack_require__(/*! ./change-set-file-service */ "../../node_modules/@theia/ai-chat/lib/browser/change-set-file-service.js");
let ContextFileVariableLabelProvider = class ContextFileVariableLabelProvider {
    canHandle(element) {
        if (ai_core_1.AIVariableResolutionRequest.is(element) && element.variable.name === 'file') {
            return 10;
        }
        return -1;
    }
    getIcon(element) {
        return this.labelProvider.getIcon(this.getUri(element));
    }
    getName(element) {
        return this.labelProvider.getName(this.getUri(element));
    }
    getLongName(element) {
        return this.labelProvider.getLongName(this.getUri(element));
    }
    getDetails(element) {
        return this.labelProvider.getDetails(this.getUri(element));
    }
    getUri(element) {
        if (!ai_core_1.AIVariableResolutionRequest.is(element)) {
            return undefined;
        }
        return new core_1.URI(element.arg);
    }
};
exports.ContextFileVariableLabelProvider = ContextFileVariableLabelProvider;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.LabelProvider),
    tslib_1.__metadata("design:type", browser_1.LabelProvider)
], ContextFileVariableLabelProvider.prototype, "labelProvider", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(change_set_file_service_1.ChangeSetFileService),
    tslib_1.__metadata("design:type", change_set_file_service_1.ChangeSetFileService)
], ContextFileVariableLabelProvider.prototype, "changeSetFileService", void 0);
exports.ContextFileVariableLabelProvider = ContextFileVariableLabelProvider = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ContextFileVariableLabelProvider);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/browser/context-variable-label-provider.js":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/browser/context-variable-label-provider.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ContextVariableLabelProvider = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const ai_core_1 = __webpack_require__(/*! @theia/ai-core */ "../../node_modules/@theia/ai-core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
let ContextVariableLabelProvider = class ContextVariableLabelProvider {
    canHandle(element) {
        if (ai_core_1.AIVariableResolutionRequest.is(element)) {
            return 1;
        }
        return -1;
    }
    getIcon(element) {
        return 'codicon codicon-variable';
    }
    getName(element) {
        if (!ai_core_1.AIVariableResolutionRequest.is(element)) {
            return undefined;
        }
        return element.variable.name;
    }
    getLongName(element) {
        if (!ai_core_1.AIVariableResolutionRequest.is(element)) {
            return undefined;
        }
        return element.variable.name + (element.arg ? ':' + element.arg : '');
    }
    getDetails(element) {
        if (!ai_core_1.AIVariableResolutionRequest.is(element)) {
            return undefined;
        }
        return element.arg;
    }
};
exports.ContextVariableLabelProvider = ContextVariableLabelProvider;
exports.ContextVariableLabelProvider = ContextVariableLabelProvider = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ContextVariableLabelProvider);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/browser/custom-agent-factory.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/browser/custom-agent-factory.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CustomAgentFactory = void 0;
exports.CustomAgentFactory = Symbol('CustomAgentFactory');


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/browser/custom-agent-frontend-application-contribution.js":
/*!*******************************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/browser/custom-agent-frontend-application-contribution.js ***!
  \*******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AICustomAgentsFrontendApplicationContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const ai_core_1 = __webpack_require__(/*! @theia/ai-core */ "../../node_modules/@theia/ai-core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! ../common */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
const custom_agent_factory_1 = __webpack_require__(/*! ./custom-agent-factory */ "../../node_modules/@theia/ai-chat/lib/browser/custom-agent-factory.js");
let AICustomAgentsFrontendApplicationContribution = class AICustomAgentsFrontendApplicationContribution {
    constructor() {
        this.knownCustomAgents = new Map();
    }
    onStart() {
        var _a, _b;
        (_a = this.customizationService) === null || _a === void 0 ? void 0 : _a.getCustomAgents().then(customAgents => {
            customAgents.forEach(agent => {
                this.customAgentFactory(agent.id, agent.name, agent.description, agent.prompt, agent.defaultLLM);
                this.knownCustomAgents.set(agent.id, agent);
            });
        }).catch(e => {
            console.error('Failed to load custom agents', e);
        });
        (_b = this.customizationService) === null || _b === void 0 ? void 0 : _b.onDidChangeCustomAgents(() => {
            var _a;
            (_a = this.customizationService) === null || _a === void 0 ? void 0 : _a.getCustomAgents().then(customAgents => {
                const customAgentsToAdd = customAgents.filter(agent => !this.knownCustomAgents.has(agent.id) || !ai_core_1.CustomAgentDescription.equals(this.knownCustomAgents.get(agent.id), agent));
                const customAgentIdsToRemove = [...this.knownCustomAgents.values()].filter(agent => !customAgents.find(a => ai_core_1.CustomAgentDescription.equals(a, agent))).map(a => a.id);
                // delete first so we don't have to deal with the case where we add and remove the same agentId
                customAgentIdsToRemove.forEach(id => {
                    this.chatAgentService.unregisterChatAgent(id);
                    this.agentService.unregisterAgent(id);
                    this.knownCustomAgents.delete(id);
                });
                customAgentsToAdd
                    .forEach(agent => {
                    this.customAgentFactory(agent.id, agent.name, agent.description, agent.prompt, agent.defaultLLM);
                    this.knownCustomAgents.set(agent.id, agent);
                });
            }).catch(e => {
                console.error('Failed to load custom agents', e);
            });
        });
    }
    onStop() {
    }
};
exports.AICustomAgentsFrontendApplicationContribution = AICustomAgentsFrontendApplicationContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(custom_agent_factory_1.CustomAgentFactory),
    tslib_1.__metadata("design:type", Function)
], AICustomAgentsFrontendApplicationContribution.prototype, "customAgentFactory", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_core_1.PromptCustomizationService),
    tslib_1.__metadata("design:type", Object)
], AICustomAgentsFrontendApplicationContribution.prototype, "customizationService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_core_1.AgentService),
    tslib_1.__metadata("design:type", Object)
], AICustomAgentsFrontendApplicationContribution.prototype, "agentService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.ChatAgentService),
    tslib_1.__metadata("design:type", Object)
], AICustomAgentsFrontendApplicationContribution.prototype, "chatAgentService", void 0);
exports.AICustomAgentsFrontendApplicationContribution = AICustomAgentsFrontendApplicationContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], AICustomAgentsFrontendApplicationContribution);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/browser/file-chat-variable-contribution.js":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/browser/file-chat-variable-contribution.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FileChatVariableContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const ai_core_1 = __webpack_require__(/*! @theia/ai-core */ "../../node_modules/@theia/ai-core/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/ai-core/lib/browser */ "../../node_modules/@theia/ai-core/lib/browser/index.js");
const file_variable_contribution_1 = __webpack_require__(/*! @theia/ai-core/lib/browser/file-variable-contribution */ "../../node_modules/@theia/ai-core/lib/browser/file-variable-contribution.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const monaco = __webpack_require__(/*! @theia/monaco-editor-core */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/editor.main.js");
const quick_file_select_service_1 = __webpack_require__(/*! @theia/file-search/lib/browser/quick-file-select-service */ "../../node_modules/@theia/file-search/lib/browser/quick-file-select-service.js");
const browser_2 = __webpack_require__(/*! @theia/workspace/lib/browser */ "../../node_modules/@theia/workspace/lib/browser/index.js");
const file_service_1 = __webpack_require__(/*! @theia/filesystem/lib/browser/file-service */ "../../node_modules/@theia/filesystem/lib/browser/file-service.js");
const ai_chat_frontend_contribution_1 = __webpack_require__(/*! ./ai-chat-frontend-contribution */ "../../node_modules/@theia/ai-chat/lib/browser/ai-chat-frontend-contribution.js");
let FileChatVariableContribution = class FileChatVariableContribution {
    registerVariables(service) {
        service.registerArgumentPicker(file_variable_contribution_1.FILE_VARIABLE, this.triggerArgumentPicker.bind(this));
        service.registerArgumentCompletionProvider(file_variable_contribution_1.FILE_VARIABLE, this.provideArgumentCompletionItems.bind(this));
        service.registerDropHandler(this.handleDrop.bind(this));
    }
    async triggerArgumentPicker() {
        const quickPick = this.quickInputService.createQuickPick();
        quickPick.items = await this.quickFileSelectService.getPicks();
        const updateItems = async (value) => {
            quickPick.items = await this.quickFileSelectService.getPicks(value, core_1.CancellationToken.None);
        };
        const onChangeListener = quickPick.onDidChangeValue(updateItems);
        quickPick.show();
        return new Promise(resolve => {
            quickPick.onDispose(onChangeListener.dispose);
            quickPick.onDidAccept(async () => {
                const selectedItem = quickPick.selectedItems[0];
                if (selectedItem && quick_file_select_service_1.FileQuickPickItem.is(selectedItem)) {
                    quickPick.dispose();
                    resolve(await this.wsService.getWorkspaceRelativePath(selectedItem.uri));
                }
            });
        });
    }
    async provideArgumentCompletionItems(model, position, matchString) {
        const context = browser_1.AIVariableCompletionContext.get(file_variable_contribution_1.FILE_VARIABLE.name, model, position, matchString);
        if (!context) {
            return undefined;
        }
        const { userInput, range, prefix } = context;
        const picks = await this.quickFileSelectService.getPicks(userInput, core_1.CancellationToken.None);
        return Promise.all(picks
            .filter(quick_file_select_service_1.FileQuickPickItem.is)
            // only show files with highlights, if the user started typing to filter down the results
            .filter(p => { var _a; return !userInput || ((_a = p.highlights) === null || _a === void 0 ? void 0 : _a.label); })
            .map(async (pick, index) => {
            const relativePath = await this.wsService.getWorkspaceRelativePath(pick.uri);
            return {
                label: pick.label,
                kind: monaco.languages.CompletionItemKind.File,
                range,
                insertText: `${prefix}${relativePath}`,
                detail: await this.wsService.getWorkspaceRelativePath(pick.uri.parent),
                // don't let monaco filter the items, as we only return picks that are filtered
                filterText: userInput,
                // keep the order of the items, but move them to the end of the list
                sortText: `ZZ${index.toString().padStart(4, '0')}_${pick.label}`,
                command: {
                    title: ai_chat_frontend_contribution_1.VARIABLE_ADD_CONTEXT_COMMAND.label,
                    id: ai_chat_frontend_contribution_1.VARIABLE_ADD_CONTEXT_COMMAND.id,
                    arguments: [file_variable_contribution_1.FILE_VARIABLE.name, relativePath]
                }
            };
        }));
    }
    async handleDrop(event, _) {
        var _a;
        const data = (_a = event.dataTransfer) === null || _a === void 0 ? void 0 : _a.getData('selected-tree-nodes');
        if (!data) {
            return undefined;
        }
        try {
            const nodes = JSON.parse(data);
            const variables = [];
            const texts = [];
            for (const node of nodes) {
                const [, filePath] = node.split(':');
                if (!filePath) {
                    continue;
                }
                const uri = core_1.URI.fromFilePath(filePath);
                if (await this.fileService.exists(uri)) {
                    const wsRelativePath = await this.wsService.getWorkspaceRelativePath(uri);
                    variables.push({
                        variable: file_variable_contribution_1.FILE_VARIABLE,
                        arg: wsRelativePath
                    });
                    texts.push(`${ai_core_1.PromptText.VARIABLE_CHAR}${file_variable_contribution_1.FILE_VARIABLE.name}${ai_core_1.PromptText.VARIABLE_SEPARATOR_CHAR}${wsRelativePath}`);
                }
            }
            return { variables, text: texts.length ? texts.join(' ') : undefined };
        }
        catch {
            return undefined;
        }
    }
};
exports.FileChatVariableContribution = FileChatVariableContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(file_service_1.FileService),
    tslib_1.__metadata("design:type", file_service_1.FileService)
], FileChatVariableContribution.prototype, "fileService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_2.WorkspaceService),
    tslib_1.__metadata("design:type", browser_2.WorkspaceService)
], FileChatVariableContribution.prototype, "wsService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.QuickInputService),
    tslib_1.__metadata("design:type", Object)
], FileChatVariableContribution.prototype, "quickInputService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(quick_file_select_service_1.QuickFileSelectService),
    tslib_1.__metadata("design:type", quick_file_select_service_1.QuickFileSelectService)
], FileChatVariableContribution.prototype, "quickFileSelectService", void 0);
exports.FileChatVariableContribution = FileChatVariableContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], FileChatVariableContribution);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/browser/frontend-chat-service.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/browser/frontend-chat-service.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2024 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FrontendChatServiceImpl = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const common_1 = __webpack_require__(/*! ../common */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const ai_chat_preferences_1 = __webpack_require__(/*! ./ai-chat-preferences */ "../../node_modules/@theia/ai-chat/lib/browser/ai-chat-preferences.js");
const change_set_file_service_1 = __webpack_require__(/*! ./change-set-file-service */ "../../node_modules/@theia/ai-chat/lib/browser/change-set-file-service.js");
/**
 * Customizes the ChatServiceImpl to consider preference based default chat agent
 */
let FrontendChatServiceImpl = class FrontendChatServiceImpl extends common_1.ChatServiceImpl {
    getAgent(parsedRequest, session) {
        var _a;
        let agent = this.initialAgentSelection(parsedRequest);
        if (!this.preferenceService.get(ai_chat_preferences_1.PIN_CHAT_AGENT_PREF)) {
            return agent;
        }
        if (!session.pinnedAgent && agent && agent.id !== ((_a = this.defaultChatAgentId) === null || _a === void 0 ? void 0 : _a.id)) {
            session.pinnedAgent = agent;
        }
        else if (session.pinnedAgent && this.getMentionedAgent(parsedRequest) === undefined) {
            agent = session.pinnedAgent;
        }
        return agent;
    }
    initialAgentSelection(parsedRequest) {
        const agentPart = this.getMentionedAgent(parsedRequest);
        if (!agentPart) {
            const configuredDefaultChatAgent = this.getConfiguredDefaultChatAgent();
            if (configuredDefaultChatAgent) {
                return configuredDefaultChatAgent;
            }
        }
        return super.initialAgentSelection(parsedRequest);
    }
    getConfiguredDefaultChatAgent() {
        const configuredDefaultChatAgentId = this.preferenceService.get(ai_chat_preferences_1.DEFAULT_CHAT_AGENT_PREF, undefined);
        const configuredDefaultChatAgent = configuredDefaultChatAgentId ? this.chatAgentService.getAgent(configuredDefaultChatAgentId) : undefined;
        if (configuredDefaultChatAgentId && !configuredDefaultChatAgent) {
            this.logger.warn(`The configured default chat agent with id '${configuredDefaultChatAgentId}' does not exist.`);
        }
        return configuredDefaultChatAgent;
    }
    createSession(location, options, pinnedAgent) {
        const session = super.createSession(location, options, pinnedAgent);
        session.model.onDidChange(event => {
            const changeSet = event.changeSet;
            if (event.kind === 'removeChangeSet') {
                this.changeSetFileService.closeDiffsForSession(session.id);
            }
            else if (changeSet) {
                this.changeSetFileService.closeDiffsForSession(session.id, changeSet.getElements().map(({ uri }) => uri));
            }
        });
        return session;
    }
};
exports.FrontendChatServiceImpl = FrontendChatServiceImpl;
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.PreferenceService),
    tslib_1.__metadata("design:type", Object)
], FrontendChatServiceImpl.prototype, "preferenceService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(change_set_file_service_1.ChangeSetFileService),
    tslib_1.__metadata("design:type", change_set_file_service_1.ChangeSetFileService)
], FrontendChatServiceImpl.prototype, "changeSetFileService", void 0);
exports.FrontendChatServiceImpl = FrontendChatServiceImpl = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], FrontendChatServiceImpl);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/browser/task-context-storage-service.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/browser/task-context-storage-service.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InMemoryTaskContextStorage = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const ai_core_1 = __webpack_require__(/*! @theia/ai-core */ "../../node_modules/@theia/ai-core/lib/common/index.js");
const task_context_variable_1 = __webpack_require__(/*! ./task-context-variable */ "../../node_modules/@theia/ai-chat/lib/browser/task-context-variable.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
let InMemoryTaskContextStorage = class InMemoryTaskContextStorage {
    constructor() {
        this.summaries = new Map();
        this.onDidChangeEmitter = new core_1.Emitter();
        this.onDidChange = this.onDidChangeEmitter.event;
    }
    store(summary) {
        this.summaries.set(summary.id, summary);
        this.onDidChangeEmitter.fire();
    }
    getAll() {
        return Array.from(this.summaries.values());
    }
    get(identifier) {
        return this.summaries.get(identifier);
    }
    delete(identifier) {
        const didDelete = this.summaries.delete(identifier);
        if (didDelete) {
            this.onDidChangeEmitter.fire();
        }
        return didDelete;
    }
    clear() {
        if (this.summaries.size) {
            this.summaries.clear();
            this.onDidChangeEmitter.fire();
        }
    }
    async open(identifier) {
        const summary = this.get(identifier);
        if (!summary) {
            throw new Error('Unable to upon requested task context: none found.');
        }
        const resource = this.variableResourceResolver.getOrCreate({ variable: task_context_variable_1.TASK_CONTEXT_VARIABLE, arg: identifier }, {}, summary.summary);
        resource.update({ onSave: async (content) => { summary.summary = content; }, readOnly: false });
        await (0, browser_1.open)(this.openerService, resource.uri);
        resource.dispose();
    }
};
exports.InMemoryTaskContextStorage = InMemoryTaskContextStorage;
tslib_1.__decorate([
    (0, inversify_1.inject)(ai_core_1.AIVariableResourceResolver),
    tslib_1.__metadata("design:type", ai_core_1.AIVariableResourceResolver)
], InMemoryTaskContextStorage.prototype, "variableResourceResolver", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(browser_1.OpenerService),
    tslib_1.__metadata("design:type", Object)
], InMemoryTaskContextStorage.prototype, "openerService", void 0);
exports.InMemoryTaskContextStorage = InMemoryTaskContextStorage = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], InMemoryTaskContextStorage);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/browser/task-context-variable-contribution.js":
/*!*******************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/browser/task-context-variable-contribution.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TaskContextVariableContribution = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/ai-core/lib/browser */ "../../node_modules/@theia/ai-core/lib/browser/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const common_1 = __webpack_require__(/*! ../common */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
const monaco = __webpack_require__(/*! @theia/monaco-editor-core */ "../../node_modules/@theia/monaco-editor-core/esm/vs/editor/editor.main.js");
const task_context_service_1 = __webpack_require__(/*! ./task-context-service */ "../../node_modules/@theia/ai-chat/lib/browser/task-context-service.js");
const task_context_variable_1 = __webpack_require__(/*! ./task-context-variable */ "../../node_modules/@theia/ai-chat/lib/browser/task-context-variable.js");
const ai_chat_frontend_contribution_1 = __webpack_require__(/*! ./ai-chat-frontend-contribution */ "../../node_modules/@theia/ai-chat/lib/browser/ai-chat-frontend-contribution.js");
let TaskContextVariableContribution = class TaskContextVariableContribution {
    registerVariables(service) {
        service.registerResolver(task_context_variable_1.TASK_CONTEXT_VARIABLE, this);
        service.registerArgumentPicker(task_context_variable_1.TASK_CONTEXT_VARIABLE, this.pickSession.bind(this));
        service.registerArgumentCompletionProvider(task_context_variable_1.TASK_CONTEXT_VARIABLE, this.provideCompletionItems.bind(this));
        service.registerOpener(task_context_variable_1.TASK_CONTEXT_VARIABLE, this);
    }
    async pickSession() {
        const items = this.getItems();
        const selection = await this.quickInputService.showQuickPick(items);
        return selection === null || selection === void 0 ? void 0 : selection.id;
    }
    async provideCompletionItems(model, position, matchString) {
        const context = browser_1.AIVariableCompletionContext.get(task_context_variable_1.TASK_CONTEXT_VARIABLE.name, model, position, matchString);
        if (!context) {
            return undefined;
        }
        const { userInput, range, prefix } = context;
        return this.getItems().filter(candidate => core_1.QuickPickItem.is(candidate) && candidate.label.startsWith(userInput)).map(({ label, id }) => ({
            label,
            kind: monaco.languages.CompletionItemKind.Class,
            range,
            insertText: `${prefix}${id}`,
            detail: id,
            filterText: userInput,
            command: {
                title: ai_chat_frontend_contribution_1.VARIABLE_ADD_CONTEXT_COMMAND.label,
                id: ai_chat_frontend_contribution_1.VARIABLE_ADD_CONTEXT_COMMAND.id,
                arguments: [task_context_variable_1.TASK_CONTEXT_VARIABLE.name, id]
            }
        }));
    }
    getItems() {
        const currentSession = this.chatService.getSessions().find(candidate => candidate.isActive);
        const existingSummaries = this.taskContextService.getAll().filter(candidate => !currentSession || currentSession.id !== candidate.sessionId);
        return existingSummaries;
    }
    canResolve(request, context) {
        return request.variable.id === task_context_variable_1.TASK_CONTEXT_VARIABLE.id ? 10000 : -5;
    }
    async resolve(request, _context) {
        if (request.variable.id !== task_context_variable_1.TASK_CONTEXT_VARIABLE.id || !request.arg) {
            return;
        }
        const value = await this.taskContextService.getSummary(request.arg).catch(() => undefined);
        return value ? { ...request, value, contextValue: value } : undefined;
    }
    canOpen(request, context) {
        return this.canResolve(request, context);
    }
    async open(request, _context) {
        if (request.variable.id !== task_context_variable_1.TASK_CONTEXT_VARIABLE.id || !request.arg) {
            throw new Error('Unable to service open request.');
        }
        return this.taskContextService.open(request.arg);
    }
};
exports.TaskContextVariableContribution = TaskContextVariableContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(core_1.QuickInputService),
    tslib_1.__metadata("design:type", Object)
], TaskContextVariableContribution.prototype, "quickInputService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.ChatService),
    tslib_1.__metadata("design:type", Object)
], TaskContextVariableContribution.prototype, "chatService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(task_context_service_1.TaskContextService),
    tslib_1.__metadata("design:type", task_context_service_1.TaskContextService)
], TaskContextVariableContribution.prototype, "taskContextService", void 0);
exports.TaskContextVariableContribution = TaskContextVariableContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], TaskContextVariableContribution);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/browser/task-context-variable-label-provider.js":
/*!*********************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/browser/task-context-variable-label-provider.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2025 Eclipse GmbH and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TaskContextVariableLabelProvider = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const ai_core_1 = __webpack_require__(/*! @theia/ai-core */ "../../node_modules/@theia/ai-core/lib/common/index.js");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const browser_1 = __webpack_require__(/*! @theia/core/lib/browser */ "../../node_modules/@theia/core/lib/browser/index.js");
const task_context_variable_contribution_1 = __webpack_require__(/*! ./task-context-variable-contribution */ "../../node_modules/@theia/ai-chat/lib/browser/task-context-variable-contribution.js");
const common_1 = __webpack_require__(/*! ../common */ "../../node_modules/@theia/ai-chat/lib/common/index.js");
const task_context_service_1 = __webpack_require__(/*! ./task-context-service */ "../../node_modules/@theia/ai-chat/lib/browser/task-context-service.js");
const task_context_variable_1 = __webpack_require__(/*! ./task-context-variable */ "../../node_modules/@theia/ai-chat/lib/browser/task-context-variable.js");
let TaskContextVariableLabelProvider = class TaskContextVariableLabelProvider {
    isMine(element) {
        return ai_core_1.AIVariableResolutionRequest.is(element) && element.variable.id === task_context_variable_1.TASK_CONTEXT_VARIABLE.id && !!element.arg;
    }
    canHandle(element) {
        return this.isMine(element) ? 10 : -1;
    }
    getIcon(element) {
        if (!this.isMine(element)) {
            return undefined;
        }
        return (0, browser_1.codicon)('clippy');
    }
    getName(element) {
        var _a, _b, _c;
        if (!this.isMine(element)) {
            return undefined;
        }
        const session = this.chatService.getSession(element.arg);
        return (_c = (_b = (_a = session === null || session === void 0 ? void 0 : session.title) !== null && _a !== void 0 ? _a : this.taskContextService.getLabel(element.arg)) !== null && _b !== void 0 ? _b : session === null || session === void 0 ? void 0 : session.id) !== null && _c !== void 0 ? _c : element.arg;
    }
    getLongName(element) {
        const short = this.getName(element);
        const details = this.getDetails(element);
        return `'${short}' (${details})`;
    }
    getDetails(element) {
        if (!this.isMine(element)) {
            return undefined;
        }
        return `id: ${element.arg}`;
    }
    getUri(element) {
        if (!ai_core_1.AIVariableResolutionRequest.is(element)) {
            return undefined;
        }
        return new core_1.URI(element.arg);
    }
};
exports.TaskContextVariableLabelProvider = TaskContextVariableLabelProvider;
tslib_1.__decorate([
    (0, inversify_1.inject)(common_1.ChatService),
    tslib_1.__metadata("design:type", Object)
], TaskContextVariableLabelProvider.prototype, "chatService", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(task_context_variable_contribution_1.TaskContextVariableContribution),
    tslib_1.__metadata("design:type", task_context_variable_contribution_1.TaskContextVariableContribution)
], TaskContextVariableLabelProvider.prototype, "chatVariableContribution", void 0);
tslib_1.__decorate([
    (0, inversify_1.inject)(task_context_service_1.TaskContextService),
    tslib_1.__metadata("design:type", task_context_service_1.TaskContextService)
], TaskContextVariableLabelProvider.prototype, "taskContextService", void 0);
exports.TaskContextVariableLabelProvider = TaskContextVariableLabelProvider = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], TaskContextVariableLabelProvider);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/common/chat-agents-variable-contribution.js":
/*!*****************************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/common/chat-agents-variable-contribution.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChatAgentsVariableContribution = exports.CHAT_AGENTS_VARIABLE = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const chat_agent_service_1 = __webpack_require__(/*! ./chat-agent-service */ "../../node_modules/@theia/ai-chat/lib/common/chat-agent-service.js");
exports.CHAT_AGENTS_VARIABLE = {
    id: 'chatAgents',
    name: 'chatAgents',
    description: 'Returns the list of chat agents available in the system'
};
let ChatAgentsVariableContribution = class ChatAgentsVariableContribution {
    registerVariables(service) {
        service.registerResolver(exports.CHAT_AGENTS_VARIABLE, this);
    }
    canResolve(request, _context) {
        if (request.variable.name === exports.CHAT_AGENTS_VARIABLE.name) {
            return 1;
        }
        return -1;
    }
    async resolve(request, context) {
        if (request.variable.name === exports.CHAT_AGENTS_VARIABLE.name) {
            return this.resolveAgentsVariable(request);
        }
    }
    resolveAgentsVariable(_request) {
        const agents = this.agents.getAgents().map(agent => ({
            id: agent.id,
            name: agent.name,
            description: agent.description
        }));
        const value = agents.map(agent => prettyPrintInMd(agent)).join('\n');
        return { variable: exports.CHAT_AGENTS_VARIABLE, value };
    }
};
exports.ChatAgentsVariableContribution = ChatAgentsVariableContribution;
tslib_1.__decorate([
    (0, inversify_1.inject)(chat_agent_service_1.ChatAgentService),
    tslib_1.__metadata("design:type", Object)
], ChatAgentsVariableContribution.prototype, "agents", void 0);
exports.ChatAgentsVariableContribution = ChatAgentsVariableContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ChatAgentsVariableContribution);
function prettyPrintInMd(agent) {
    return `- ${agent.id}
  - *ID*: ${agent.id}
  - *Name*: ${agent.name}
  - *Description*: ${agent.description.replace(/\n/g, ' ')}`;
}


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/common/chat-string-utils.js":
/*!*************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/common/chat-string-utils.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.dataToJsonCodeBlock = exports.stringJsonCodeBlock = void 0;
function stringJsonCodeBlock(input) {
    return `\`\`\`json\n${input}\n\`\`\``;
}
exports.stringJsonCodeBlock = stringJsonCodeBlock;
function dataToJsonCodeBlock(input) {
    return stringJsonCodeBlock(JSON.stringify(input, undefined, 2));
}
exports.dataToJsonCodeBlock = dataToJsonCodeBlock;


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/common/context-details-variable.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/common/context-details-variable.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ContextDetailsVariableContribution = exports.CONTEXT_DETAILS_VARIABLE = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const chat_string_utils_1 = __webpack_require__(/*! ./chat-string-utils */ "../../node_modules/@theia/ai-chat/lib/common/chat-string-utils.js");
const chat_agents_1 = __webpack_require__(/*! ./chat-agents */ "../../node_modules/@theia/ai-chat/lib/common/chat-agents.js");
const context_variables_1 = __webpack_require__(/*! ./context-variables */ "../../node_modules/@theia/ai-chat/lib/common/context-variables.js");
exports.CONTEXT_DETAILS_VARIABLE = {
    id: context_variables_1.CHAT_CONTEXT_DETAILS_VARIABLE_ID,
    description: core_1.nls.localize('theia/ai/core/contextDetailsVariable/description', 'Provides full text values and descriptions for all context elements.'),
    name: context_variables_1.CHAT_CONTEXT_DETAILS_VARIABLE_ID,
};
let ContextDetailsVariableContribution = class ContextDetailsVariableContribution {
    registerVariables(service) {
        service.registerResolver(exports.CONTEXT_DETAILS_VARIABLE, this);
    }
    canResolve(request, context) {
        return request.variable.name === exports.CONTEXT_DETAILS_VARIABLE.name ? 50 : 0;
    }
    async resolve(request, context) {
        /** By expecting context.request, we're assuming that this variable will not be resolved until the context has been resolved. */
        if (!chat_agents_1.ChatSessionContext.is(context) || request.variable.name !== exports.CONTEXT_DETAILS_VARIABLE.name || !context.request) {
            return undefined;
        }
        const data = context.request.context.variables.map(variable => ({
            type: variable.variable.name,
            ref: variable.value,
            content: variable.contextValue
        }));
        return {
            variable: exports.CONTEXT_DETAILS_VARIABLE,
            value: (0, chat_string_utils_1.dataToJsonCodeBlock)(data)
        };
    }
};
exports.ContextDetailsVariableContribution = ContextDetailsVariableContribution;
exports.ContextDetailsVariableContribution = ContextDetailsVariableContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ContextDetailsVariableContribution);


/***/ }),

/***/ "../../node_modules/@theia/ai-chat/lib/common/context-summary-variable.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@theia/ai-chat/lib/common/context-summary-variable.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2025 EclipseSource GmbH.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ContextSummaryVariableContribution = exports.CONTEXT_SUMMARY_VARIABLE = void 0;
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
const core_1 = __webpack_require__(/*! @theia/core */ "../../node_modules/@theia/core/lib/common/index.js");
const inversify_1 = __webpack_require__(/*! @theia/core/shared/inversify */ "../../node_modules/@theia/core/shared/inversify/index.js");
const chat_string_utils_1 = __webpack_require__(/*! ./chat-string-utils */ "../../node_modules/@theia/ai-chat/lib/common/chat-string-utils.js");
const chat_agents_1 = __webpack_require__(/*! ./chat-agents */ "../../node_modules/@theia/ai-chat/lib/common/chat-agents.js");
exports.CONTEXT_SUMMARY_VARIABLE = {
    id: 'contextSummary',
    description: core_1.nls.localize('theia/ai/core/contextSummaryVariable/description', 'Describes files in the context for a given session.'),
    name: 'contextSummary',
};
let ContextSummaryVariableContribution = class ContextSummaryVariableContribution {
    registerVariables(service) {
        service.registerResolver(exports.CONTEXT_SUMMARY_VARIABLE, this);
    }
    canResolve(request, context) {
        return request.variable.name === exports.CONTEXT_SUMMARY_VARIABLE.name ? 50 : 0;
    }
    async resolve(request, context) {
        if (!chat_agents_1.ChatSessionContext.is(context) || request.variable.name !== exports.CONTEXT_SUMMARY_VARIABLE.name) {
            return undefined;
        }
        const data = chat_agents_1.ChatSessionContext.getVariables(context).filter(variable => variable.variable.isContextVariable)
            .map(variable => ({
            type: variable.variable.name,
            // eslint-disable-next-line no-null/no-null
            instanceData: variable.arg || null,
            contextElementId: variable.variable.id + variable.arg
        }));
        return {
            variable: exports.CONTEXT_SUMMARY_VARIABLE,
            value: (0, chat_string_utils_1.dataToJsonCodeBlock)(data)
        };
    }
};
exports.ContextSummaryVariableContribution = ContextSummaryVariableContribution;
exports.ContextSummaryVariableContribution = ContextSummaryVariableContribution = tslib_1.__decorate([
    (0, inversify_1.injectable)()
], ContextSummaryVariableContribution);


/***/ }),

/***/ "../../node_modules/@theia/workspace/lib/browser/index.js":
/*!****************************************************************!*\
  !*** ../../node_modules/@theia/workspace/lib/browser/index.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


// *****************************************************************************
// Copyright (C) 2017 TypeFox and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0
// *****************************************************************************
Object.defineProperty(exports, "__esModule", ({ value: true }));
const tslib_1 = __webpack_require__(/*! tslib */ "../../node_modules/tslib/tslib.es6.mjs");
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-commands */ "../../node_modules/@theia/workspace/lib/browser/workspace-commands.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./canonical-uri-service */ "../../node_modules/@theia/workspace/lib/browser/canonical-uri-service.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-frontend-contribution */ "../../node_modules/@theia/workspace/lib/browser/workspace-frontend-contribution.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-frontend-module */ "../../node_modules/@theia/workspace/lib/browser/workspace-frontend-module.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-preferences */ "../../node_modules/@theia/workspace/lib/browser/workspace-preferences.js"), exports);
tslib_1.__exportStar(__webpack_require__(/*! ./workspace-trust-service */ "../../node_modules/@theia/workspace/lib/browser/workspace-trust-service.js"), exports);


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_theia_ai-chat_lib_browser_ai-chat-frontend-module_js.js.map