/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.util.gradle;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public final class Path
implements Comparable<Path> {
    private static final String PATH_SEPARATOR = ":";
    private static final Path ROOT_PATH = new Path(":");
    private final String path;

    private Path(String path) {
        this.path = (String)Preconditions.checkNotNull((Object)path);
        Preconditions.checkArgument((boolean)path.startsWith(PATH_SEPARATOR));
    }

    public String getPath() {
        return this.path;
    }

    public Path dropLastSegment() {
        int lastPathChar = this.path.lastIndexOf(PATH_SEPARATOR);
        return lastPathChar <= 0 ? ROOT_PATH : new Path(this.path.substring(0, lastPathChar));
    }

    @Override
    public int compareTo(Path other) {
        Preconditions.checkNotNull((Object)other);
        return PathComparator.INSTANCE.compare(this.path, other.path);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Path that = (Path)other;
        return Objects.equal((Object)this.path, (Object)that.path);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.path});
    }

    public static Path from(String path) {
        return new Path(path);
    }

    private static enum PathComparator implements java.util.Comparator<String>
    {
        INSTANCE;


        @Override
        public int compare(String path1, String path2) {
            int depthDiff = this.getDepth(path1) - this.getDepth(path2);
            if (depthDiff != 0) {
                return depthDiff;
            }
            return this.compareSegments(path1, path2);
        }

        private int compareSegments(String path1, String path2) {
            int diff;
            int colon1 = path1.indexOf(58);
            int colon2 = path2.indexOf(58);
            if (colon1 > 0 && colon2 > 0 && (diff = path1.substring(0, colon1).compareTo(path2.substring(0, colon2))) != 0) {
                return diff;
            }
            return colon1 == -1 ? path1.compareTo(path2) : this.compareSegments(path1.substring(colon1 + 1), path2.substring(colon2 + 1));
        }

        private int getDepth(String taskName) {
            int counter = 0;
            for (char c : taskName.toCharArray()) {
                if (c != ':') continue;
                ++counter;
            }
            return counter;
        }
    }

    public static enum Comparator implements java.util.Comparator<Path>
    {
        INSTANCE;


        @Override
        public int compare(Path o1, Path o2) {
            return o1.compareTo(o2);
        }
    }
}

