/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Objects;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.SourceField;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.corrections.DiagnosticsHelper;
import org.eclipse.lsp4j.Range;

public class CodeGenerationUtils {
    public static final String INSERT_AS_LAST_MEMBER = "lastMember";
    public static final String INSERT_BEFORE_CURSOR = "beforeCursor";
    public static final String INSERT_AFTER_CURSOR = "afterCursor";

    public static IJavaElement findInsertElement(IType type, Range cursor) {
        if (cursor == null) {
            return null;
        }
        String insertionLocation = JavaLanguageServerPlugin.getPreferencesManager().getPreferences().getCodeGenerationInsertionLocation();
        if (Objects.equals(insertionLocation, INSERT_AS_LAST_MEMBER)) {
            return null;
        }
        if (Objects.equals(insertionLocation, INSERT_BEFORE_CURSOR)) {
            return CodeGenerationUtils.findElementAtPosition(type, cursor);
        }
        return CodeGenerationUtils.findElementAfterPosition(type, cursor);
    }

    public static IJavaElement findInsertElement(IType type, int currentOffset) {
        String insertionLocation = JavaLanguageServerPlugin.getPreferencesManager().getPreferences().getCodeGenerationInsertionLocation();
        if (Objects.equals(insertionLocation, INSERT_AS_LAST_MEMBER)) {
            return null;
        }
        if (Objects.equals(insertionLocation, INSERT_BEFORE_CURSOR)) {
            return CodeGenerationUtils.findElementAtPosition(type, currentOffset);
        }
        return CodeGenerationUtils.findElementAfterPosition(type, currentOffset);
    }

    public static IJavaElement findInsertElementAfterLastField(IType type) {
        int lastOffset = 0;
        try {
            IJavaElement[] members;
            IJavaElement[] iJavaElementArray = members = type.getChildren();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                ISourceRange sourceRange;
                int offset;
                IJavaElement member = iJavaElementArray[n2];
                if (member instanceof SourceField && (offset = (sourceRange = ((IMember)member).getSourceRange()).getOffset() + sourceRange.getLength()) > lastOffset) {
                    lastOffset = offset;
                }
                ++n2;
            }
            return CodeGenerationUtils.findElementAfterPosition(type, lastOffset);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    private static IJavaElement findElementAtPosition(IType type, int currentOffset) {
        try {
            IJavaElement[] members;
            IJavaElement[] iJavaElementArray = members = type.getChildren();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement member = iJavaElementArray[n2];
                ISourceRange sourceRange = ((IMember)member).getSourceRange();
                if (currentOffset <= sourceRange.getOffset() + sourceRange.getLength()) {
                    return member;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return null;
    }

    private static IJavaElement findElementAtPosition(IType type, Range range) {
        if (range == null) {
            return null;
        }
        int startOffset = DiagnosticsHelper.getStartOffset(type.getCompilationUnit(), range);
        if (startOffset < 0) {
            return null;
        }
        return CodeGenerationUtils.findElementAtPosition(type, startOffset);
    }

    private static IJavaElement findElementAfterPosition(IType type, int currentOffset) {
        try {
            IJavaElement[] members;
            IJavaElement[] iJavaElementArray = members = type.getChildren();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement member = iJavaElementArray[n2];
                ISourceRange sourceRange = ((IMember)member).getSourceRange();
                if (currentOffset <= sourceRange.getOffset()) {
                    return member;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return null;
    }

    private static IJavaElement findElementAfterPosition(IType type, Range range) {
        if (range == null) {
            return null;
        }
        int endOffset = DiagnosticsHelper.getEndOffset(type.getCompilationUnit(), range);
        if (endOffset < 0) {
            return null;
        }
        return CodeGenerationUtils.findElementAfterPosition(type, endOffset);
    }
}

