/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.ls.core.internal.BuildWorkspaceStatus;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.handlers.WorkspaceDiagnosticsHandler;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.lsp4j.extended.ProjectBuildParams;

public class BuildWorkspaceHandler {
    private final ProjectsManager projectsManager;

    public BuildWorkspaceHandler(ProjectsManager projectsManager) {
        this.projectsManager = projectsManager;
    }

    public BuildWorkspaceStatus buildWorkspace(boolean forceReBuild, IProgressMonitor monitor) {
        try {
            IProject[] projects;
            if (monitor.isCanceled()) {
                return BuildWorkspaceStatus.CANCELLED;
            }
            if (ProjectsManager.getDefaultProject().exists()) {
                ProjectsManager.cleanupResources(ProjectsManager.getDefaultProject());
            }
            if (forceReBuild) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                ResourcesPlugin.getWorkspace().build(15, (IProgressMonitor)subMonitor.split(50));
                ResourcesPlugin.getWorkspace().build(6, (IProgressMonitor)subMonitor.split(50));
            } else {
                ResourcesPlugin.getWorkspace().build(10, monitor);
            }
            ArrayList<IMarker> problemMarkers = new ArrayList<IMarker>();
            IProject[] iProjectArray = projects = ProjectUtils.getAllProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                List<IMarker> markers;
                IProject project = iProjectArray[n2];
                if (!project.equals((Object)ProjectsManager.getDefaultProject()) && (markers = ResourceUtils.getErrorMarkers((IResource)project)) != null) {
                    problemMarkers.addAll(markers);
                }
                ++n2;
            }
            List errors = problemMarkers.stream().filter(m -> m.getAttribute("severity", 0) == 2).map(e -> BuildWorkspaceHandler.convertMarker(e)).collect(Collectors.toList());
            if (errors.isEmpty()) {
                return BuildWorkspaceStatus.SUCCEED;
            }
            WorkspaceDiagnosticsHandler.checkPreviewFeatureValidity(problemMarkers);
            String newline = System.getProperty("line.separator");
            JavaLanguageServerPlugin.logError("Error occured while building workspace. Details: " + newline + String.join((CharSequence)newline, errors));
            return BuildWorkspaceStatus.WITH_ERROR;
        }
        catch (CoreException e2) {
            JavaLanguageServerPlugin.logException("Failed to build workspace.", e2);
            return BuildWorkspaceStatus.FAILED;
        }
        catch (OperationCanceledException e3) {
            return BuildWorkspaceStatus.CANCELLED;
        }
    }

    public BuildWorkspaceStatus buildProjects(ProjectBuildParams params, IProgressMonitor monitor) {
        Collection<IProject> projects = ProjectUtils.getProjectsFromDocumentIdentifiers(params.getIdentifiers());
        if (projects.size() == 0) {
            JavaLanguageServerPlugin.logError("Build projects fail: Cannot find projects from given uris.");
            return BuildWorkspaceStatus.CANCELLED;
        }
        IBuildConfiguration[] configs = this.getBuildConfigurationsToBuild(projects);
        try {
            if (params.isFullBuild()) {
                ResourcesPlugin.getWorkspace().build(configs, 15, true, monitor);
                ResourcesPlugin.getWorkspace().build(configs, 6, true, monitor);
            } else {
                ResourcesPlugin.getWorkspace().build(configs, 10, true, monitor);
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Failed to build projects.", e);
            return BuildWorkspaceStatus.FAILED;
        }
        catch (OperationCanceledException e) {
            return BuildWorkspaceStatus.CANCELLED;
        }
        for (IProject project : projects) {
            if (project.equals((Object)ProjectsManager.getDefaultProject())) continue;
            try {
                List<IMarker> markers = ResourceUtils.getErrorMarkers((IResource)project);
                if (markers == null || markers.size() <= 0) continue;
                return BuildWorkspaceStatus.WITH_ERROR;
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Failed to get error markers from project: " + project.getName(), e);
                return BuildWorkspaceStatus.FAILED;
            }
        }
        return BuildWorkspaceStatus.SUCCEED;
    }

    protected IBuildConfiguration[] getBuildConfigurationsToBuild(Collection<IProject> projects) {
        HashSet<IBuildConfiguration> configs = new HashSet<IBuildConfiguration>();
        for (IProject project : projects) {
            if (project == null || !this.hasBuilder(project)) continue;
            try {
                configs.add(project.getActiveBuildConfig());
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Failed to get build config.", e);
            }
        }
        return configs.toArray(new IBuildConfiguration[configs.size()]);
    }

    protected boolean hasBuilder(IProject project) {
        if (!project.isAccessible()) {
            return false;
        }
        try {
            ICommand[] commands = project.getDescription().getBuildSpec();
            if (commands.length > 0) {
                return true;
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Failed to check project's builder.", e);
        }
        return false;
    }

    private static String convertMarker(IMarker marker) {
        int line;
        StringBuilder builder = new StringBuilder();
        String message = marker.getAttribute("message", "<no message>");
        String code = String.valueOf(marker.getAttribute("id", 0));
        builder.append(" message: ").append(message).append(";");
        builder.append(" code: ").append(code).append(";");
        IResource resource = marker.getResource();
        if (resource != null) {
            builder.append(" resource: ").append(resource.getLocation()).append(";");
        }
        if ((line = marker.getAttribute("lineNumber", -1)) > 0) {
            builder.append(" line: ").append(line);
        }
        return builder.toString();
    }
}

