/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.ls.core.internal.CancellableProgressMonitor;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.LanguageServerWorkingCopyOwner;
import org.eclipse.jdt.ls.core.internal.ServiceStatus;
import org.eclipse.lsp4j.Registration;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.Unregistration;
import org.eclipse.lsp4j.UnregistrationParams;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;

public class BaseJDTLanguageServer {
    public static final int FORCED_EXIT_CODE = 1;
    protected JavaClientConnection client;
    protected boolean shutdownReceived = false;
    private Set<String> registeredCapabilities = new HashSet<String>(3);

    public void connectClient(JavaClientConnection.JavaLanguageClient client) {
        this.client = new JavaClientConnection(client);
    }

    public JavaClientConnection getClientConnection() {
        return this.client;
    }

    public LanguageServerWorkingCopyOwner getWorkingCopyOwner() {
        return null;
    }

    public void sendStatus(ServiceStatus serverStatus, String status) {
        if (this.client != null) {
            this.client.sendStatus(serverStatus, status);
        }
    }

    public void unregisterCapability(String id, String method) {
        if (this.client != null && this.registeredCapabilities.remove(id)) {
            Unregistration unregistration = new Unregistration(id, method);
            UnregistrationParams unregistrationParams = new UnregistrationParams(Collections.singletonList(unregistration));
            this.client.unregisterCapability(unregistrationParams);
        }
    }

    public void registerCapability(String id, String method) {
        this.registerCapability(id, method, null);
    }

    public void registerCapability(String id, String method, Object options) {
        if (this.client != null && this.registeredCapabilities.add(id)) {
            Registration registration = new Registration(id, method, options);
            RegistrationParams registrationParams = new RegistrationParams(Collections.singletonList(registration));
            this.client.registerCapability(registrationParams);
        }
    }

    protected void toggleCapability(boolean enabled, String id, String capability, Object options) {
        if (enabled) {
            this.registerCapability(id, capability, options);
        } else {
            this.unregisterCapability(id, capability);
        }
    }

    protected <R> CompletableFuture<R> computeAsync(Function<IProgressMonitor, R> code) {
        return CompletableFutures.computeAsync(cc -> code.apply(this.toMonitor((CancelChecker)cc)));
    }

    protected IProgressMonitor toMonitor(CancelChecker checker) {
        return new CancellableProgressMonitor(checker);
    }
}

