/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.bs.core.internal.log;

import ch.epfl.scala.bsp4j.BuildClient;
import ch.epfl.scala.bsp4j.LogMessageParams;
import ch.epfl.scala.bsp4j.MessageType;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LogHandler
extends Handler {
    private final BuildClient client;

    public LogHandler(BuildClient client) {
        this.client = client;
    }

    @Override
    public void publish(LogRecord logRecord) {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        String timestamp = formatter.format((Object)new Date());
        String logMessage = String.format("[%s - %s] %s", logRecord.getLevel().getName(), timestamp, logRecord.getMessage());
        this.client.onBuildLogMessage(new LogMessageParams(this.convertLevelToMessageType(logRecord.getLevel()), logMessage));
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    private MessageType convertLevelToMessageType(Level level) {
        if (Level.SEVERE.equals(level)) {
            return MessageType.ERROR;
        }
        if (Level.WARNING.equals(level)) {
            return MessageType.WARNING;
        }
        return MessageType.INFORMATION;
    }
}

