/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.Filterable;
import org.junit.jupiter.engine.descriptor.TestFactoryTestDescriptor;
import org.junit.jupiter.engine.descriptor.TestMethodTestDescriptor;
import org.junit.jupiter.engine.descriptor.TestTemplateTestDescriptor;
import org.junit.jupiter.engine.discovery.MethodFinder;
import org.junit.jupiter.engine.discovery.predicates.IsNestedTestClass;
import org.junit.jupiter.engine.discovery.predicates.IsTestClassWithTests;
import org.junit.jupiter.engine.discovery.predicates.IsTestFactoryMethod;
import org.junit.jupiter.engine.discovery.predicates.IsTestMethod;
import org.junit.jupiter.engine.discovery.predicates.IsTestTemplateMethod;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ClassUtils;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.IterationSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.NestedMethodSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.support.discovery.SelectorResolver;

class MethodSelectorResolver
implements SelectorResolver {
    private static final Logger logger = LoggerFactory.getLogger(MethodSelectorResolver.class);
    private static final MethodFinder methodFinder = new MethodFinder();
    private static final Predicate<Class<?>> testClassPredicate = new IsTestClassWithTests().or(new IsNestedTestClass());
    protected final JupiterConfiguration configuration;

    MethodSelectorResolver(JupiterConfiguration configuration) {
        this.configuration = configuration;
    }

    public SelectorResolver.Resolution resolve(MethodSelector selector, SelectorResolver.Context context) {
        return this.resolve(context, Collections.emptyList(), selector.getJavaClass(), () -> ((MethodSelector)selector).getJavaMethod(), SelectorResolver.Match::exact);
    }

    public SelectorResolver.Resolution resolve(NestedMethodSelector selector, SelectorResolver.Context context) {
        return this.resolve(context, selector.getEnclosingClasses(), selector.getNestedClass(), () -> ((NestedMethodSelector)selector).getMethod(), SelectorResolver.Match::exact);
    }

    private SelectorResolver.Resolution resolve(SelectorResolver.Context context, List<Class<?>> enclosingClasses, Class<?> testClass, Supplier<Method> methodSupplier, BiFunction<TestDescriptor, Supplier<Set<? extends DiscoverySelector>>, SelectorResolver.Match> matchFactory) {
        if (!testClassPredicate.test(testClass)) {
            return SelectorResolver.Resolution.unresolved();
        }
        Method method = methodSupplier.get();
        Set matches = Arrays.stream(MethodType.values()).map(methodType -> ((MethodType)methodType).resolve(enclosingClasses, testClass, method, context, this.configuration)).filter(Optional::isPresent).map(Optional::get).map(testDescriptor -> (SelectorResolver.Match)matchFactory.apply((TestDescriptor)testDescriptor, this.expansionCallback((TestDescriptor)testDescriptor))).collect(Collectors.toSet());
        if (matches.size() > 1) {
            logger.warn(() -> {
                Stream<TestDescriptor> testDescriptors = matches.stream().map(SelectorResolver.Match::getTestDescriptor);
                return String.format("Possible configuration error: method [%s] resulted in multiple TestDescriptors %s. This is typically the result of annotating a method with multiple competing annotations such as @Test, @RepeatedTest, @ParameterizedTest, @TestFactory, etc.", method.toGenericString(), testDescriptors.map(d -> d.getClass().getName()).collect(Collectors.toList()));
            });
        }
        return matches.isEmpty() ? SelectorResolver.Resolution.unresolved() : SelectorResolver.Resolution.matches(matches);
    }

    public SelectorResolver.Resolution resolve(UniqueIdSelector selector, SelectorResolver.Context context) {
        UniqueId uniqueId = selector.getUniqueId();
        return Arrays.stream(MethodType.values()).map(methodType -> ((MethodType)methodType).resolveUniqueIdIntoTestDescriptor(uniqueId, context, this.configuration)).filter(Optional::isPresent).map(Optional::get).map(testDescriptor -> {
            boolean exactMatch = uniqueId.equals((Object)testDescriptor.getUniqueId());
            if (testDescriptor instanceof Filterable) {
                Filterable filterable = (Filterable)testDescriptor;
                if (exactMatch) {
                    filterable.getDynamicDescendantFilter().allowAll();
                } else {
                    filterable.getDynamicDescendantFilter().allowUniqueIdPrefix(uniqueId);
                }
            }
            return SelectorResolver.Resolution.match((SelectorResolver.Match)(exactMatch ? SelectorResolver.Match.exact((TestDescriptor)testDescriptor) : SelectorResolver.Match.partial((TestDescriptor)testDescriptor, this.expansionCallback((TestDescriptor)testDescriptor))));
        }).findFirst().orElse(SelectorResolver.Resolution.unresolved());
    }

    public SelectorResolver.Resolution resolve(IterationSelector selector, SelectorResolver.Context context) {
        if (selector.getParentSelector() instanceof MethodSelector) {
            MethodSelector methodSelector = (MethodSelector)selector.getParentSelector();
            return this.resolve(context, Collections.emptyList(), methodSelector.getJavaClass(), () -> ((MethodSelector)methodSelector).getJavaMethod(), (testDescriptor, childSelectorsSupplier) -> {
                if (testDescriptor instanceof Filterable) {
                    Filterable filterable = (Filterable)testDescriptor;
                    filterable.getDynamicDescendantFilter().allowIndex(selector.getIterationIndices());
                }
                return SelectorResolver.Match.partial((TestDescriptor)testDescriptor, (Supplier)childSelectorsSupplier);
            });
        }
        return SelectorResolver.Resolution.unresolved();
    }

    private Supplier<Set<? extends DiscoverySelector>> expansionCallback(TestDescriptor testDescriptor) {
        return () -> {
            if (testDescriptor instanceof Filterable) {
                Filterable filterable = (Filterable)testDescriptor;
                filterable.getDynamicDescendantFilter().allowAll();
            }
            return Collections.emptySet();
        };
    }

    private static enum MethodType {
        TEST((Predicate)new IsTestMethod(), "method", new String[0]){

            @Override
            protected TestDescriptor createTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method method, JupiterConfiguration configuration) {
                return new TestMethodTestDescriptor(uniqueId, testClass, method, configuration);
            }
        }
        ,
        TEST_FACTORY((Predicate)new IsTestFactoryMethod(), "test-factory", new String[]{"dynamic-container", "dynamic-test"}){

            @Override
            protected TestDescriptor createTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method method, JupiterConfiguration configuration) {
                return new TestFactoryTestDescriptor(uniqueId, testClass, method, configuration);
            }
        }
        ,
        TEST_TEMPLATE((Predicate)new IsTestTemplateMethod(), "test-template", new String[]{"test-template-invocation"}){

            @Override
            protected TestDescriptor createTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method method, JupiterConfiguration configuration) {
                return new TestTemplateTestDescriptor(uniqueId, testClass, method, configuration);
            }
        };

        private final Predicate<Method> methodPredicate;
        private final String segmentType;
        private final Set<String> dynamicDescendantSegmentTypes;

        private MethodType(Predicate<Method> methodPredicate, String segmentType, String ... dynamicDescendantSegmentTypes) {
            this.methodPredicate = methodPredicate;
            this.segmentType = segmentType;
            this.dynamicDescendantSegmentTypes = new LinkedHashSet<String>(Arrays.asList(dynamicDescendantSegmentTypes));
        }

        private Optional<TestDescriptor> resolve(List<Class<?>> enclosingClasses, Class<?> testClass, Method method, SelectorResolver.Context context, JupiterConfiguration configuration) {
            if (!this.methodPredicate.test(method)) {
                return Optional.empty();
            }
            return context.addToParent(() -> this.selectClass(enclosingClasses, testClass), parent -> Optional.of(this.createTestDescriptor(this.createUniqueId(method, (TestDescriptor)parent), testClass, method, configuration)));
        }

        private DiscoverySelector selectClass(List<Class<?>> enclosingClasses, Class<?> testClass) {
            if (enclosingClasses.isEmpty()) {
                return DiscoverySelectors.selectClass(testClass);
            }
            return DiscoverySelectors.selectNestedClass(enclosingClasses, testClass);
        }

        private Optional<TestDescriptor> resolveUniqueIdIntoTestDescriptor(UniqueId uniqueId, SelectorResolver.Context context, JupiterConfiguration configuration) {
            UniqueId.Segment lastSegment = uniqueId.getLastSegment();
            if (this.segmentType.equals(lastSegment.getType())) {
                return context.addToParent(() -> DiscoverySelectors.selectUniqueId((UniqueId)uniqueId.removeLastSegment()), parent -> {
                    String methodSpecPart = lastSegment.getValue();
                    Class<?> testClass = ((ClassBasedTestDescriptor)((Object)parent)).getTestClass();
                    return methodFinder.findMethod(methodSpecPart, testClass).filter(this.methodPredicate).map(method -> this.createTestDescriptor(this.createUniqueId((Method)method, (TestDescriptor)parent), testClass, (Method)method, configuration));
                });
            }
            if (this.dynamicDescendantSegmentTypes.contains(lastSegment.getType())) {
                return this.resolveUniqueIdIntoTestDescriptor(uniqueId.removeLastSegment(), context, configuration);
            }
            return Optional.empty();
        }

        private UniqueId createUniqueId(Method method, TestDescriptor parent) {
            String methodId = String.format("%s(%s)", method.getName(), ClassUtils.nullSafeToString((Class[])method.getParameterTypes()));
            return parent.getUniqueId().append(this.segmentType, methodId);
        }

        protected abstract TestDescriptor createTestDescriptor(UniqueId var1, Class<?> var2, Method var3, JupiterConfiguration var4);
    }
}

