/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.wikilink.internal;

import com.vladsch.flexmark.ext.wikilink.WikiImage;
import com.vladsch.flexmark.ext.wikilink.WikiLinkExtension;
import com.vladsch.flexmark.ext.wikilink.internal.WikiLinkOptions;
import com.vladsch.flexmark.html.LinkResolver;
import com.vladsch.flexmark.html.LinkResolverFactory;
import com.vladsch.flexmark.html.renderer.LinkResolverBasicContext;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.util.ast.Node;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WikiLinkLinkResolver
implements LinkResolver {
    private final WikiLinkOptions options;

    public WikiLinkLinkResolver(LinkResolverBasicContext context) {
        this.options = new WikiLinkOptions(context.getOptions());
    }

    @NotNull
    public ResolvedLink resolveLink(@NotNull Node node, @NotNull LinkResolverBasicContext context, @NotNull ResolvedLink link) {
        if (link.getLinkType() == WikiLinkExtension.WIKI_LINK) {
            int i;
            StringBuilder sb = new StringBuilder();
            boolean isWikiImage = node instanceof WikiImage;
            String wikiLink = link.getUrl();
            int iMax = wikiLink.length();
            boolean absolute = iMax > 0 && wikiLink.charAt(0) == '/';
            sb.append(isWikiImage ? this.options.getImagePrefix(absolute) : this.options.getLinkPrefix(absolute));
            boolean hadAnchorRef = false;
            boolean isEscaped = false;
            String linkEscapeChars = this.options.linkEscapeChars;
            String linkReplaceChars = this.options.linkReplaceChars;
            int n = i = absolute ? 1 : 0;
            while (i < iMax) {
                char c = wikiLink.charAt(i);
                if (!(c != '#' || hadAnchorRef || !this.options.allowAnchors || isEscaped && this.options.allowAnchorEscape)) {
                    sb.append(isWikiImage ? this.options.imageFileExtension : this.options.linkFileExtension);
                    sb.append(c);
                    hadAnchorRef = true;
                    isEscaped = false;
                } else if (c == '\\') {
                    if (isEscaped) {
                        sb.append("%5C");
                    }
                    isEscaped = !isEscaped;
                } else {
                    isEscaped = false;
                    if (c == '#' && !hadAnchorRef) {
                        sb.append("%23");
                    } else {
                        int pos = linkEscapeChars.indexOf(c);
                        if (pos < 0) {
                            sb.append(c);
                        } else {
                            sb.append(linkReplaceChars.charAt(pos));
                        }
                    }
                }
                ++i;
            }
            if (isEscaped) {
                sb.append("%5C");
            }
            if (!hadAnchorRef) {
                sb.append(isWikiImage ? this.options.imageFileExtension : this.options.linkFileExtension);
            }
            if (isWikiImage) {
                return new ResolvedLink(LinkType.IMAGE, (CharSequence)sb.toString(), null, LinkStatus.UNCHECKED);
            }
            return new ResolvedLink(LinkType.LINK, (CharSequence)sb.toString(), null, LinkStatus.UNCHECKED);
        }
        return link;
    }

    public static class Factory
    implements LinkResolverFactory {
        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return null;
        }

        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return null;
        }

        public boolean affectsGlobalScope() {
            return false;
        }

        @NotNull
        public LinkResolver apply(@NotNull LinkResolverBasicContext context) {
            return new WikiLinkLinkResolver(context);
        }
    }
}

