/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.decompiler;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ls.core.internal.DecompilerResult;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.StatusFactory;
import org.eclipse.jdt.ls.core.internal.decompiler.DecompilerImpl;
import org.eclipse.jdt.ls.core.internal.decompiler.DecompilerType;
import org.jetbrains.java.decompiler.main.decompiler.BaseDecompiler;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;

public class FernFlowerDecompiler
extends DecompilerImpl {
    public static final String DECOMPILER_HEADER = "// Source code is decompiled from a .class file using FernFlower decompiler (from Intellij IDEA).\n";

    public static boolean isDecompiledContents(String contents) {
        return contents != null && contents.startsWith(DECOMPILER_HEADER);
    }

    @Override
    protected DecompilerResult decompileContent(URI uri, IProgressMonitor monitor) throws CoreException {
        try {
            return this.getContent(new BytecodeProvider(uri), monitor);
        }
        catch (IOException e) {
            throw new CoreException(StatusFactory.newErrorStatus("Failed to decompile class file: " + String.valueOf(uri), e));
        }
    }

    @Override
    protected DecompilerResult decompileContent(IClassFile classFile, IProgressMonitor monitor) throws CoreException {
        try {
            return this.getContent(new BytecodeProvider(classFile), monitor);
        }
        catch (IOException e) {
            throw new CoreException(StatusFactory.newErrorStatus("Failed to decompile class file: " + String.valueOf(classFile), e));
        }
    }

    @Override
    protected DecompilerType getDecompilerType() {
        return DecompilerType.FERNFLOWER;
    }

    private DecompilerResult getContent(BytecodeProvider provider, IProgressMonitor monitor) throws CoreException {
        HashMap<String, String> decompilerOptions = new HashMap<String, String>();
        decompilerOptions.put("hdc", "0");
        decompilerOptions.put("iib", "1");
        decompilerOptions.put("rsy", "1");
        decompilerOptions.put("rbr", "1");
        decompilerOptions.put("dgs", "1");
        decompilerOptions.put("din", "1");
        decompilerOptions.put("den", "1");
        decompilerOptions.put("log", IFernflowerLogger.Severity.ERROR.name());
        decompilerOptions.put("asc", "0");
        decompilerOptions.put("bsm", "1");
        if (Boolean.getBoolean("jdt.ls.debug")) {
            decompilerOptions.put("__dump_original_lines__", "1");
        }
        ResultSaver resultSaver = new ResultSaver();
        BaseDecompiler fernflower = new BaseDecompiler((IBytecodeProvider)provider, (IResultSaver)resultSaver, decompilerOptions, new IFernflowerLogger(){

            public void writeMessage(String message, IFernflowerLogger.Severity severity) {
                if (severity.ordinal() >= IFernflowerLogger.Severity.ERROR.ordinal()) {
                    JavaLanguageServerPlugin.logError(message);
                }
            }

            public void writeMessage(String message, IFernflowerLogger.Severity severity, Throwable t) {
                if (severity.ordinal() >= IFernflowerLogger.Severity.ERROR.ordinal()) {
                    JavaLanguageServerPlugin.logException(message, t);
                }
            }
        });
        for (File file : provider.getAllClassFiles()) {
            fernflower.addSource(file);
        }
        fernflower.decompileContext();
        String decompiledCode = DECOMPILER_HEADER + resultSaver.content;
        TreeMap<Integer, Set> originalLineMappings = new TreeMap<Integer, Set>();
        TreeMap<Integer, Set> decompiledLineMappings = new TreeMap<Integer, Set>();
        if (resultSaver.originalLinesMapping != null) {
            int i = 0;
            while (i + 1 < resultSaver.originalLinesMapping.length) {
                int srcLine = resultSaver.originalLinesMapping[i];
                int decompiledLine = resultSaver.originalLinesMapping[i + 1] + 1;
                Set decompiled = originalLineMappings.computeIfAbsent(srcLine, k -> new TreeSet());
                decompiled.add(decompiledLine);
                Set src = decompiledLineMappings.computeIfAbsent(decompiledLine, k -> new TreeSet());
                src.add(srcLine);
                i += 2;
            }
        } else {
            JavaLanguageServerPlugin.logInfo("Line mappings not available for decompiled content - decompilation may have failed or line mapping was disabled");
        }
        ArrayList<Integer> originals = new ArrayList<Integer>(originalLineMappings.size() * 2);
        for (Map.Entry entry : originalLineMappings.entrySet()) {
            int original = (Integer)entry.getKey();
            Iterator iterator = ((Set)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                int value = (Integer)iterator.next();
                originals.add(original);
                originals.add(value);
            }
        }
        ArrayList<Integer> decompiles = new ArrayList<Integer>(decompiledLineMappings.size() * 2);
        for (Map.Entry entry : decompiledLineMappings.entrySet()) {
            int decompiled = (Integer)entry.getKey();
            Iterator iterator = ((Set)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                int value = (Integer)iterator.next();
                decompiles.add(decompiled);
                decompiles.add(value);
            }
        }
        return new DecompilerResult(decompiledCode, originals.stream().mapToInt(Integer::intValue).toArray(), decompiles.stream().mapToInt(Integer::intValue).toArray());
    }

    static class BytecodeProvider
    implements IBytecodeProvider {
        private Map<String, byte[]> bytecodeMap = new HashMap<String, byte[]>();
        private List<File> classFiles = new ArrayList<File>();

        public BytecodeProvider(URI uri) throws CoreException, IOException {
            this.collectClassFiles(uri);
        }

        public BytecodeProvider(IClassFile classFile) throws CoreException, IOException {
            this.collectClassFiles(classFile);
        }

        public List<File> getAllClassFiles() {
            return this.classFiles;
        }

        public byte[] getBytecode(String externalPath, String internalPath) throws IOException {
            byte[] bytes = this.bytecodeMap.get(externalPath);
            if (bytes == null) {
                throw new IOException("Class file not found: " + externalPath + " (available: " + String.valueOf(this.bytecodeMap.keySet()) + ")");
            }
            return bytes;
        }

        private void collectClassFiles(URI uri) throws CoreException, IOException {
            IClassFile classFile = JDTUtils.resolveClassFile(uri);
            if (classFile != null) {
                this.collectClassFiles(classFile);
                return;
            }
            Path classPath = Paths.get(uri);
            if (!Files.exists(classPath, new LinkOption[0])) {
                throw new IOException("Class file does not exist: " + String.valueOf(classPath));
            }
            File file = classPath.toFile();
            File topLevelFile = this.findTopLevelClassFile(file);
            LinkedHashSet<File> allClassFiles = new LinkedHashSet<File>();
            this.scanClassFiles(topLevelFile, allClassFiles);
            for (File classFileToProcess : allClassFiles) {
                this.processClassFile(classFileToProcess);
            }
        }

        private File findTopLevelClassFile(File file) throws IOException {
            String fileName = file.getName();
            if (!fileName.endsWith(".class")) {
                return file;
            }
            String baseName = fileName.substring(0, fileName.length() - 6);
            int dollarIndex = baseName.indexOf(36);
            if (dollarIndex > 0) {
                File topLevelFile;
                String topLevelBaseName = baseName.substring(0, dollarIndex);
                File parentDir = file.getParentFile();
                if (parentDir != null && (topLevelFile = new File(parentDir, topLevelBaseName + ".class")).exists()) {
                    return topLevelFile;
                }
            }
            return file;
        }

        private void scanClassFiles(File topLevelFile, Set<File> result) {
            result.add(topLevelFile);
            String fileName = topLevelFile.getName();
            if (fileName.endsWith(".class")) {
                File[] innerClasses;
                String baseName = fileName.substring(0, fileName.length() - 6);
                String mask = baseName + "$";
                File parentDir = topLevelFile.getParentFile();
                if (parentDir != null && parentDir.isDirectory() && (innerClasses = parentDir.listFiles((dir, name) -> name.startsWith(mask) && name.endsWith(".class"))) != null) {
                    Arrays.stream(innerClasses).forEach(result::add);
                }
            }
        }

        private void processClassFile(File file) throws IOException {
            String path = file.getPath();
            this.classFiles.add(file);
            this.bytecodeMap.put(path, Files.readAllBytes(file.toPath()));
        }

        private void collectClassFiles(IClassFile classFile) throws CoreException {
            IClassFile topLevelClassFile = this.findTopLevelClassFile(classFile);
            LinkedHashSet<IClassFile> allClassFiles = new LinkedHashSet<IClassFile>();
            this.scanClassFiles(topLevelClassFile, allClassFiles);
            for (IClassFile cf : allClassFiles) {
                this.processClassFile(cf);
            }
        }

        private IClassFile findTopLevelClassFile(IClassFile classFile) throws CoreException {
            IClassFile topLevelClassFile = classFile;
            if (classFile instanceof IOrdinaryClassFile) {
                IType type;
                IOrdinaryClassFile ordinaryClassFile = (IOrdinaryClassFile)classFile;
                IType topLevelType = type = ordinaryClassFile.getType();
                while (topLevelType.getDeclaringType() != null) {
                    topLevelType = topLevelType.getDeclaringType();
                }
                if (topLevelType != type) {
                    topLevelClassFile = topLevelType.getClassFile();
                }
            }
            return topLevelClassFile;
        }

        private void scanClassFiles(IClassFile classFile, Set<IClassFile> result) throws CoreException {
            if (classFile instanceof IOrdinaryClassFile) {
                IType[] innerTypes;
                IOrdinaryClassFile ordinaryClassFile = (IOrdinaryClassFile)classFile;
                if (!result.add(classFile)) {
                    return;
                }
                IType type = ordinaryClassFile.getType();
                IType[] iTypeArray = innerTypes = type.getTypes();
                int n = innerTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IType innerType = iTypeArray[n2];
                    IOrdinaryClassFile innerClassFile = innerType.getClassFile();
                    if (innerClassFile != null) {
                        this.scanClassFiles((IClassFile)innerClassFile, result);
                    }
                    ++n2;
                }
            }
        }

        private void processClassFile(IClassFile classFile) throws CoreException {
            File file = new File(classFile.getElementName()).getAbsoluteFile();
            byte[] classBytes = classFile.getBytes();
            this.classFiles.add(file);
            this.bytecodeMap.put(file.getPath(), classBytes);
        }
    }

    static class ResultSaver
    implements IResultSaver {
        private String content;
        private int[] originalLinesMapping;

        ResultSaver() {
        }

        public void closeArchive(String arg0, String arg1) {
        }

        public void copyEntry(String arg0, String arg1, String arg2, String arg3) {
        }

        public void copyFile(String arg0, String arg1, String arg2) {
        }

        public void createArchive(String arg0, String arg1, Manifest arg2) {
        }

        public void saveClassEntry(String arg0, String arg1, String arg2, String arg3, String arg4) {
        }

        public void saveClassFile(String filename, String qualifiedName, String entryName, String content, int[] originalLinesMapping) {
            this.content = content;
            this.originalLinesMapping = originalLinesMapping;
        }

        public void saveDirEntry(String arg0, String arg1, String arg2) {
        }

        public void saveFolder(String arg0) {
        }
    }
}

