# MathMarkdown Example

**Inline Equations:**

You can include inline equations by enclosing them in single dollar signs ($). For example, the equation for the area of a circle is $A = \pi r^2$.

**Display Equations:**

To display equations on their own line, you can use double dollar signs ($$). For example, the quadratic formula is:

$$x = \frac{-b \pm \sqrt{b^2 - 4ac}}{2a}$$

**Greek Letters:**

MathMarkdown supports Greek letters using their LaTeX names. For example, you can write alpha ($\alpha$), beta ($\beta$), and gamma ($\gamma$) using the LaTeX notation.

**Fractions and Exponents:**

You can create fractions using the `\frac` command. For example, $\frac{1}{2}$ represents one-half.

Exponents can be written using the caret (^) symbol. For example, $2^3$ represents two raised to the power of three.

**Summation and Integration:**

MathMarkdown also supports summation and integration symbols. For example, the sum of the first $n$ natural numbers can be written as:

$$\sum_{i=1}^{n} i = \frac{n(n+1)}{2}$$

The definite integral of a function $f(x)$ from $a$ to $b$ can be written as:

$$\int_{a}^{b} f(x) dx$$

**Matrices:**

You can create matrices using the `matrix` environment. For example, the following matrix represents a 2x2 identity matrix:

$$
\begin{matrix}
1 & 0 \\
0 & 1 \\
\end{matrix}
$$