/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.themes;

import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.core.internal.utils.StringUtils;
import org.eclipse.tm4e.core.registry.IThemeSource;
import org.eclipse.tm4e.registry.TMResource;
import org.eclipse.tm4e.ui.TMUIPlugin;
import org.eclipse.tm4e.ui.internal.themes.TMThemeTokenProvider;
import org.eclipse.tm4e.ui.internal.utils.UI;
import org.eclipse.tm4e.ui.themes.ColorManager;
import org.eclipse.tm4e.ui.themes.ITheme;
import org.eclipse.tm4e.ui.themes.ITokenProvider;
import org.eclipse.tm4e.ui.themes.css.CSSTokenProvider;

public class Theme
extends TMResource
implements ITheme {
    private static final long RECHECK_INTERVAL_NANOS = TimeUnit.SECONDS.toNanos(5L);
    private static final String DARK_ATTR = "dark";
    private static final String DEFAULT_ATTR = "default";
    private @Nullable ITokenProvider tokenProvider;
    private final String id;
    private final String name;
    private boolean dark;
    private boolean isDefault;
    private long lastModified = -1L;
    private long lastModifiedRecheck = -1L;

    public Theme() {
        this.name = "<set-by-gson>";
        this.id = "<set-by-gson>";
    }

    public Theme(String id, String path, String name, boolean dark) {
        super(path);
        this.id = id;
        this.name = name;
        this.dark = dark;
        this.isDefault = false;
    }

    public Theme(IConfigurationElement ce) {
        super(ce);
        this.id = (String)NullSafetyHelper.castNonNull((Object)ce.getAttribute("id"));
        this.name = (String)NullSafetyHelper.castNonNull((Object)ce.getAttribute("name"));
        this.dark = Boolean.parseBoolean(ce.getAttribute(DARK_ATTR));
        this.isDefault = Boolean.parseBoolean(ce.getAttribute(DEFAULT_ATTR));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IToken getToken(String textMateTokenType) {
        ITokenProvider provider = this.getTokenProvider();
        return provider == null ? ITokenProvider.DEFAULT_TOKEN : provider.getToken(textMateTokenType);
    }

    private @Nullable Color getPriorityColor(@Nullable Color themeColor, String prefStoreKey) {
        return UI.isDarkEclipseTheme() == this.isDark() ? ColorManager.getInstance().getPriorityColor(themeColor, prefStoreKey) : themeColor;
    }

    @Override
    public @Nullable Color getEditorForeground() {
        ITokenProvider provider = this.getTokenProvider();
        return this.getPriorityColor(provider != null ? provider.getEditorForeground() : null, "AbstractTextEditor.Color.Foreground");
    }

    @Override
    public @Nullable Color getEditorBackground() {
        ITokenProvider provider = this.getTokenProvider();
        return this.getPriorityColor(provider != null ? provider.getEditorBackground() : null, "AbstractTextEditor.Color.Background");
    }

    @Override
    public @Nullable Color getEditorSelectionForeground() {
        ITokenProvider provider = this.getTokenProvider();
        return this.getPriorityColor(provider != null ? provider.getEditorSelectionForeground() : null, "AbstractTextEditor.Color.SelectionForeground");
    }

    @Override
    public @Nullable Color getEditorSelectionBackground() {
        ITokenProvider provider = this.getTokenProvider();
        return this.getPriorityColor(provider != null ? provider.getEditorSelectionBackground() : null, "AbstractTextEditor.Color.SelectionBackground");
    }

    @Override
    public @Nullable Color getEditorCurrentLineHighlight() {
        ITokenProvider provider = this.getTokenProvider();
        Color themeColor = provider != null ? provider.getEditorCurrentLineHighlight() : null;
        ColorManager manager = ColorManager.getInstance();
        return manager.isColorUserDefined("AbstractTextEditor.Color.Background") ? manager.getPreferenceEditorColor("currentLineColor") : themeColor;
    }

    private @Nullable ITokenProvider getTokenProvider() {
        block35: {
            if (this.tokenProvider != null && !this.isModified()) break block35;
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (InputStream in = this.getInputStream();){
                    String extension;
                    String path = this.getPath();
                    this.tokenProvider = switch (extension = path.substring(path.lastIndexOf(46) + 1).trim().toLowerCase()) {
                        case "css" -> new CSSTokenProvider(in);
                        case "json" -> new TMThemeTokenProvider(IThemeSource.ContentType.JSON, in);
                        case "yaml-tmtheme", "yml", "yaml" -> new TMThemeTokenProvider(IThemeSource.ContentType.YAML, in);
                        case "tmtheme", "xml", "plist" -> new TMThemeTokenProvider(IThemeSource.ContentType.XML, in);
                        default -> throw new IllegalArgumentException("Unsupported file type: " + path);
                    };
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception ex) {
                TMUIPlugin.logError(ex);
                return null;
            }
        }
        return this.tokenProvider;
    }

    private boolean isModified() {
        long now = System.nanoTime();
        if (now > this.lastModifiedRecheck) {
            this.lastModifiedRecheck = now + RECHECK_INTERVAL_NANOS;
            long oldModified = this.lastModified;
            this.lastModified = this.getLastModified();
            return this.lastModified != oldModified;
        }
        return false;
    }

    @Override
    public boolean isDark() {
        return this.dark;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public void initializeViewerColors(StyledText styledText) {
        Color color = this.getEditorBackground();
        if (color != null) {
            styledText.setBackground(color);
        }
        if ((color = this.getEditorForeground()) != null) {
            styledText.setForeground(color);
        }
        if ((color = this.getEditorSelectionBackground()) != null) {
            styledText.setSelectionBackground(color);
        }
        if ((color = this.getEditorSelectionForeground()) != null) {
            styledText.setSelectionForeground(color);
        }
    }

    public String toString() {
        return StringUtils.toString((Object)this, sb -> {
            sb.append("id=").append(this.getId());
            sb.append(",name=").append(this.getName());
            sb.append(",dark=").append(this.isDark());
            sb.append(",default=").append(this.isDefault());
        });
    }
}

