/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.crypto.macs;

import org.python.bouncycastle.crypto.CipherParameters;
import org.python.bouncycastle.crypto.DataLengthException;
import org.python.bouncycastle.crypto.Mac;
import org.python.bouncycastle.crypto.params.KeyParameter;
import org.python.bouncycastle.crypto.util.Pack;
import org.python.bouncycastle.util.Arrays;

public class SipHash
implements Mac {
    protected final int c;
    protected final int d;
    protected long k0;
    protected long k1;
    protected long v0;
    protected long v1;
    protected long v2;
    protected long v3;
    protected long v4;
    protected byte[] buf = new byte[8];
    protected int bufPos = 0;
    protected int wordCount = 0;

    public SipHash() {
        this.c = 2;
        this.d = 4;
    }

    public SipHash(int n, int n2) {
        this.c = n;
        this.d = n2;
    }

    public String getAlgorithmName() {
        return "SipHash-" + this.c + "-" + this.d;
    }

    public int getMacSize() {
        return 8;
    }

    public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
        if (!(cipherParameters instanceof KeyParameter)) {
            throw new IllegalArgumentException("'params' must be an instance of KeyParameter");
        }
        KeyParameter keyParameter = (KeyParameter)cipherParameters;
        byte[] byArray = keyParameter.getKey();
        if (byArray.length != 16) {
            throw new IllegalArgumentException("'params' must be a 128-bit key");
        }
        this.k0 = Pack.littleEndianToLong(byArray, 0);
        this.k1 = Pack.littleEndianToLong(byArray, 8);
        this.reset();
    }

    public void update(byte by) throws IllegalStateException {
        this.buf[this.bufPos] = by;
        if (++this.bufPos == this.buf.length) {
            this.processMessageWord();
            this.bufPos = 0;
        }
    }

    public void update(byte[] byArray, int n, int n2) throws DataLengthException, IllegalStateException {
        for (int i = 0; i < n2; ++i) {
            this.buf[this.bufPos] = byArray[n + i];
            if (++this.bufPos != this.buf.length) continue;
            this.processMessageWord();
            this.bufPos = 0;
        }
    }

    public long doFinal() throws DataLengthException, IllegalStateException {
        this.buf[7] = (byte)((this.wordCount << 3) + this.bufPos & 0xFF);
        while (this.bufPos < 7) {
            this.buf[this.bufPos++] = 0;
        }
        this.processMessageWord();
        this.v2 ^= 0xFFL;
        this.applySipRounds(this.d);
        long l = this.v0 ^ this.v1 ^ this.v2 ^ this.v3;
        this.reset();
        return l;
    }

    public int doFinal(byte[] byArray, int n) throws DataLengthException, IllegalStateException {
        long l = this.doFinal();
        Pack.longToLittleEndian(l, byArray, n);
        return 8;
    }

    public void reset() {
        this.v0 = this.k0 ^ 0x736F6D6570736575L;
        this.v1 = this.k1 ^ 0x646F72616E646F6DL;
        this.v2 = this.k0 ^ 0x6C7967656E657261L;
        this.v3 = this.k1 ^ 0x7465646279746573L;
        Arrays.fill(this.buf, (byte)0);
        this.bufPos = 0;
        this.wordCount = 0;
    }

    protected void processMessageWord() {
        ++this.wordCount;
        long l = Pack.littleEndianToLong(this.buf, 0);
        this.v3 ^= l;
        this.applySipRounds(this.c);
        this.v0 ^= l;
    }

    protected void applySipRounds(int n) {
        for (int i = 0; i < n; ++i) {
            this.v0 += this.v1;
            this.v2 += this.v3;
            this.v1 = SipHash.rotateLeft(this.v1, 13);
            this.v3 = SipHash.rotateLeft(this.v3, 16);
            this.v1 ^= this.v0;
            this.v3 ^= this.v2;
            this.v0 = SipHash.rotateLeft(this.v0, 32);
            this.v2 += this.v1;
            this.v0 += this.v3;
            this.v1 = SipHash.rotateLeft(this.v1, 17);
            this.v3 = SipHash.rotateLeft(this.v3, 21);
            this.v1 ^= this.v2;
            this.v3 ^= this.v0;
            this.v2 = SipHash.rotateLeft(this.v2, 32);
        }
    }

    protected static long rotateLeft(long l, int n) {
        return l << n | l >>> 64 - n;
    }
}

