/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.language.settings.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Set;
import org.eclipse.cdt.core.AbstractExecutableExtensionBase;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsEditableProvider;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsBaseProvider;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsGenericProvider;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsSerializableProvider;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.LanguageSettingEntriesSerializer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class LanguageSettingsExtensionManager {
    static final String PROVIDER_EXTENSION_POINT_ID = "org.eclipse.cdt.core.LanguageSettingsProvider";
    static final String PROVIDER_EXTENSION_SIMPLE_ID = "LanguageSettingsProvider";
    static final String ATTR_ID = "id";
    static final String ATTR_NAME = "name";
    static final String ATTR_CLASS = "class";
    static final String ATTR_PREFER_NON_SHARED = "prefer-non-shared";
    static final String ELEM_PROVIDER = "provider";
    static final String ELEM_LANGUAGE_SCOPE = "language-scope";
    static final String ELEM_ENTRY = "entry";
    static final String ATTR_ENTRY_NAME = "name";
    static final String ATTR_ENTRY_KIND = "kind";
    static final String ATTR_ENTRY_VALUE = "value";
    static final String ELEM_ENTRY_FLAG = "flag";
    private static final LinkedHashMap<String, ILanguageSettingsProvider> fExtensionProviders = new LinkedHashMap();

    static {
        try {
            LanguageSettingsExtensionManager.loadProviderExtensions();
        }
        catch (Throwable e) {
            CCorePlugin.log("Error loading language settings providers extensions", e);
        }
    }

    private static synchronized void loadProviderExtensions() {
        ArrayList<ILanguageSettingsProvider> providers = new ArrayList<ILanguageSettingsProvider>();
        LanguageSettingsExtensionManager.loadProviderExtensions(Platform.getExtensionRegistry(), providers);
        Collections.sort(providers, new Comparator<ILanguageSettingsProvider>(){

            @Override
            public int compare(ILanguageSettingsProvider pr1, ILanguageSettingsProvider pr2) {
                return pr1.getName().compareTo(pr2.getName());
            }
        });
        fExtensionProviders.clear();
        for (ILanguageSettingsProvider provider : providers) {
            fExtensionProviders.put(provider.getId(), provider);
        }
    }

    private static void loadProviderExtensions(IExtensionRegistry registry, Collection<ILanguageSettingsProvider> providers) {
        providers.clear();
        IExtensionPoint extension = registry.getExtensionPoint("org.eclipse.cdt.core", PROVIDER_EXTENSION_SIMPLE_ID);
        if (extension != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = extension.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement cfgEl = iConfigurationElementArray[n4];
                    ILanguageSettingsProvider provider = null;
                    String id = null;
                    try {
                        if (cfgEl.getName().equals(ELEM_PROVIDER)) {
                            id = LanguageSettingsExtensionManager.determineAttributeValue(cfgEl, ATTR_ID);
                            provider = LanguageSettingsExtensionManager.createExecutableExtension(cfgEl);
                            LanguageSettingsExtensionManager.configureExecutableProvider(provider, cfgEl);
                            providers.add(provider);
                        }
                    }
                    catch (Throwable e) {
                        CCorePlugin.log("Cannot load LanguageSettingsProvider extension id=" + id, e);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private static String determineAttributeValue(IConfigurationElement ce, String attr) {
        String value = ce.getAttribute(attr);
        return value != null ? value : "";
    }

    private static ILanguageSettingsProvider createExecutableExtension(IConfigurationElement ce) throws CoreException {
        String ceClass = ce.getAttribute(ATTR_CLASS);
        ILanguageSettingsProvider provider = null;
        provider = ceClass == null || ceClass.trim().length() == 0 || ceClass.equals(LanguageSettingsBaseProvider.class.getCanonicalName()) ? new LanguageSettingsBaseProvider() : (ILanguageSettingsProvider)ce.createExecutableExtension(ATTR_CLASS);
        return provider;
    }

    private static void configureExecutableProvider(ILanguageSettingsProvider provider, IConfigurationElement ce) {
        String ceId = LanguageSettingsExtensionManager.determineAttributeValue(ce, ATTR_ID);
        String ceName = LanguageSettingsExtensionManager.determineAttributeValue(ce, "name");
        HashMap<String, String> ceAttributes = new HashMap<String, String>();
        ArrayList<String> languages = null;
        ArrayList<ICLanguageSettingEntry> entries = null;
        String[] stringArray = ce.getAttributeNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attr = stringArray[n2];
            if (!(attr.equals(ATTR_ID) || attr.equals("name") || attr.equals(ATTR_CLASS))) {
                ceAttributes.put(attr, LanguageSettingsExtensionManager.determineAttributeValue(ce, attr));
            }
            ++n2;
        }
        stringArray = ce.getChildren(ELEM_LANGUAGE_SCOPE);
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String ceLang = stringArray[n2];
            String langId = LanguageSettingsExtensionManager.determineAttributeValue((IConfigurationElement)ceLang, ATTR_ID);
            if (langId.length() > 0) {
                if (languages == null) {
                    languages = new ArrayList<String>();
                }
                languages.add(langId);
            }
            ++n2;
        }
        stringArray = ce.getChildren(ELEM_ENTRY);
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String ceEntry = stringArray[n2];
            try {
                int entryKind = LanguageSettingEntriesSerializer.stringToKind(LanguageSettingsExtensionManager.determineAttributeValue((IConfigurationElement)ceEntry, ATTR_ENTRY_KIND));
                String entryName = LanguageSettingsExtensionManager.determineAttributeValue((IConfigurationElement)ceEntry, "name");
                String entryValue = LanguageSettingsExtensionManager.determineAttributeValue((IConfigurationElement)ceEntry, ATTR_ENTRY_VALUE);
                int flags = 0;
                IConfigurationElement[] iConfigurationElementArray = ceEntry.getChildren(ELEM_ENTRY_FLAG);
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement ceFlags = iConfigurationElementArray[n4];
                    int bitFlag = LanguageSettingEntriesSerializer.composeFlags(LanguageSettingsExtensionManager.determineAttributeValue(ceFlags, ATTR_ENTRY_VALUE));
                    flags |= bitFlag;
                    ++n4;
                }
                ICLanguageSettingEntry entry = (ICLanguageSettingEntry)CDataUtil.createEntry(entryKind, entryName, entryValue, null, flags);
                if (entries == null) {
                    entries = new ArrayList<ICLanguageSettingEntry>();
                }
                entries.add(entry);
            }
            catch (Exception e) {
                CCorePlugin.log("Error creating language settings entry ", e);
            }
            ++n2;
        }
        if (provider instanceof LanguageSettingsBaseProvider) {
            ((LanguageSettingsBaseProvider)provider).configureProvider(ceId, ceName, languages, entries, ceAttributes);
        } else if (provider instanceof AbstractExecutableExtensionBase) {
            ((AbstractExecutableExtensionBase)((Object)provider)).setId(ceId);
            ((AbstractExecutableExtensionBase)((Object)provider)).setName(ceName);
        }
    }

    private static ILanguageSettingsProvider loadProviderFromRegistry(String attr, String attrValue, IExtensionRegistry registry, boolean configure) {
        try {
            IExtensionPoint extension = registry.getExtensionPoint("org.eclipse.cdt.core", PROVIDER_EXTENSION_SIMPLE_ID);
            if (extension != null) {
                IExtension[] extensions;
                IExtension[] iExtensionArray = extensions = extension.getExtensions();
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension ext = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement cfgEl = iConfigurationElementArray[n4];
                        if (cfgEl.getName().equals(ELEM_PROVIDER) && attrValue.equals(cfgEl.getAttribute(attr))) {
                            ILanguageSettingsProvider provider = LanguageSettingsExtensionManager.createExecutableExtension(cfgEl);
                            if (configure) {
                                LanguageSettingsExtensionManager.configureExecutableProvider(provider, cfgEl);
                            }
                            return provider;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            CCorePlugin.log("Error creating language settings provider.", e);
        }
        return null;
    }

    static ILanguageSettingsProvider instantiateProviderClass(String className) throws CoreException {
        if (className == null || className.equals(LanguageSettingsSerializableProvider.class.getName())) {
            return new LanguageSettingsSerializableProvider();
        }
        if (className.equals(LanguageSettingsGenericProvider.class.getName())) {
            return new LanguageSettingsGenericProvider();
        }
        ILanguageSettingsProvider provider = LanguageSettingsExtensionManager.loadProviderFromRegistry(ATTR_CLASS, className, Platform.getExtensionRegistry(), false);
        if (provider == null) {
            String msg = "Not able to load provider class=" + className;
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", msg));
        }
        return provider;
    }

    static ILanguageSettingsProvider loadProvider(String id) {
        if (id == null) {
            return null;
        }
        ILanguageSettingsProvider provider = LanguageSettingsExtensionManager.loadProviderFromRegistry(ATTR_ID, id, Platform.getExtensionRegistry(), true);
        if (provider == null) {
            String msg = "Not able to load provider id=" + id;
            CCorePlugin.log((IStatus)new Status(4, "org.eclipse.cdt.core", msg, (Throwable)new Exception(msg)));
        }
        return provider;
    }

    public static Set<String> getExtensionProviderIds() {
        return fExtensionProviders.keySet();
    }

    public static ILanguageSettingsEditableProvider getProviderCopy(ILanguageSettingsEditableProvider provider, boolean deep) {
        try {
            if (deep) {
                return provider.clone();
            }
            return provider.cloneShallow();
        }
        catch (CloneNotSupportedException e) {
            CCorePlugin.log("Error cloning provider " + provider.getId() + ", class " + String.valueOf(provider.getClass()), e);
            return null;
        }
    }

    public static ILanguageSettingsProvider getExtensionProviderCopy(String id, boolean deep) {
        ILanguageSettingsProvider provider = fExtensionProviders.get(id);
        if (provider instanceof ILanguageSettingsEditableProvider) {
            return LanguageSettingsExtensionManager.getProviderCopy((ILanguageSettingsEditableProvider)provider, deep);
        }
        return null;
    }

    public static boolean isEqualExtensionProvider(ILanguageSettingsProvider provider, boolean deep) {
        ILanguageSettingsProvider extensionProviderShallow;
        String id = provider.getId();
        if (deep || !(provider instanceof ILanguageSettingsEditableProvider)) {
            ILanguageSettingsProvider extensionProvider = fExtensionProviders.get(id);
            return provider.equals(extensionProvider);
        }
        ILanguageSettingsEditableProvider providerShallow = LanguageSettingsExtensionManager.getProviderCopy((ILanguageSettingsEditableProvider)provider, false);
        return providerShallow == (extensionProviderShallow = LanguageSettingsExtensionManager.getExtensionProviderCopy(id, false)) || providerShallow != null && providerShallow.equals(extensionProviderShallow);
    }

    public static boolean isPreferShared(String id) {
        ILanguageSettingsProvider provider = fExtensionProviders.get(id);
        if (provider instanceof LanguageSettingsBaseProvider && provider instanceof ILanguageSettingsEditableProvider) {
            return !((LanguageSettingsBaseProvider)provider).getPropertyBool(ATTR_PREFER_NON_SHARED);
        }
        return true;
    }
}

