/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messagestransport;

import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.IRosModelProvider;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.RosModelUtils;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.connections.IRosConnectionsModel;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.connections.RosConnectionsModelAnalysis;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messagestransport.IRosMessagesTransportModel;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messagestransport.RosMessagesTransportModel;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;

public class RosMessagesTransportModelAnalysis
extends TmfAbstractAnalysisModule
implements IRosModelProvider<IRosMessagesTransportModel> {
    public static final @NonNull String ID = "org.eclipse.tracecompass.incubator.ros.core.analysis.model.messagestransport";
    private @Nullable IProgressMonitor fMonitor;
    private @Nullable RosMessagesTransportModel fModel = null;

    public RosMessagesTransportModelAnalysis() {
        this.setId(ID);
    }

    @Override
    public @Nullable RosMessagesTransportModel getModel() {
        return this.fModel;
    }

    protected boolean executeAnalysis(@NonNull IProgressMonitor monitor) throws TmfAnalysisException {
        ITmfTrace trace = this.getTrace();
        if (!(trace instanceof TmfExperiment)) {
            throw new IllegalStateException();
        }
        @Nullable IRosConnectionsModel connectionsModel = (IRosConnectionsModel)RosModelUtils.getModelFromAnalysis(trace, RosConnectionsModelAnalysis.class, "org.eclipse.tracecompass.incubator.ros.core.analysis.model.connections");
        if (connectionsModel == null) {
            return false;
        }
        RosMessagesTransportModel model = new RosMessagesTransportModel(trace, connectionsModel);
        model.generateModel();
        this.fModel = model;
        return !monitor.isCanceled();
    }

    protected @NonNull Iterable<@NonNull IAnalysisModule> getDependentAnalyses() {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return Collections.emptySet();
        }
        RosConnectionsModelAnalysis connectionsModel = (RosConnectionsModelAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, RosConnectionsModelAnalysis.class, (String)"org.eclipse.tracecompass.incubator.ros.core.analysis.model.connections");
        if (connectionsModel == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(connectionsModel);
    }

    protected void canceling() {
        IProgressMonitor mon = this.fMonitor;
        if (mon != null && !mon.isCanceled()) {
            mon.setCanceled(true);
        }
    }
}

